/*
 * Decompiled with CFR 0.152.
 */
package parquet.bytes;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    protected ByteBuffer byteBuf;

    public ByteBufferInputStream(ByteBuffer buffer) {
        this(buffer, buffer.position(), buffer.remaining());
    }

    public ByteBufferInputStream(ByteBuffer buffer, int offset, int count) {
        buffer.position(offset);
        this.byteBuf = buffer.slice();
        this.byteBuf.limit(count);
    }

    @Override
    public int read() throws IOException {
        if (!this.byteBuf.hasRemaining()) {
            return -1;
        }
        return this.byteBuf.get() & 0xFF;
    }

    @Override
    public int read(byte[] bytes, int offset, int length) throws IOException {
        int count = Math.min(this.byteBuf.remaining(), length);
        if (count == 0) {
            return -1;
        }
        this.byteBuf.get(bytes, offset, count);
        return count;
    }

    @Override
    public long skip(long n) {
        if (n > (long)this.byteBuf.remaining()) {
            n = this.byteBuf.remaining();
        }
        int pos = this.byteBuf.position();
        this.byteBuf.position((int)((long)pos + n));
        return n;
    }

    @Override
    public int available() {
        return this.byteBuf.remaining();
    }
}

