/*
 * Decompiled with CFR 0.152.
 */
package parquet.hadoop.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.EnumSet;
import org.apache.hadoop.fs.FSDataInputStream;
import parquet.Log;
import parquet.org.apache.thrift.TBase;
import parquet.org.apache.thrift.TException;
import parquet.org.apache.thrift.protocol.TCompactProtocol;
import parquet.org.apache.thrift.transport.TIOStreamTransport;
import parquet.org.apache.thrift.transport.TTransport;
import parquet.org.apache.thrift.transport.TTransportException;

public class CompatibilityUtil {
    private static final boolean useV21;
    private static final Log LOG;
    private static final Constructor<?> ELASTIC_BYTE_BUFFER_CONSTRUCTOR;
    private static final Class<?> ElasticByteBufferCls;
    private static final Class<?> ByteBufferCls;
    private static final Class<? extends Enum> ReadOptionCls;
    private static final Method READ_METHOD;
    private static final Method RELEASE_BUFFER_METHOD;
    private static final Method GET_BUFFER_METHOD;
    private static final Method PUT_BUFFER_METHOD;
    private static final Object bufferPool;
    private static final int MAX_SIZE = 0x100000;

    static {
        LOG = Log.getLog(CompatibilityUtil.class);
        boolean v21 = true;
        String PACKAGE = "org.apache.hadoop";
        try {
            Class.forName("org.apache.hadoop.io.ElasticByteBufferPool");
        }
        catch (ClassNotFoundException cnfe) {
            v21 = false;
        }
        useV21 = v21;
        try {
            if (v21) {
                ElasticByteBufferCls = Class.forName("org.apache.hadoop.io.ElasticByteBufferPool");
                ELASTIC_BYTE_BUFFER_CONSTRUCTOR = ElasticByteBufferCls.getConstructor(new Class[0]);
                ByteBufferCls = Class.forName("org.apache.hadoop.io.ByteBufferPool");
                Class<?> FSDataInputStreamCls = Class.forName("org.apache.hadoop.fs.FSDataInputStream");
                ReadOptionCls = Class.forName("org.apache.hadoop.fs.ReadOption");
                READ_METHOD = FSDataInputStreamCls.getMethod("read", ByteBufferCls, Integer.TYPE, EnumSet.class);
                RELEASE_BUFFER_METHOD = FSDataInputStreamCls.getMethod("releaseBuffer", ByteBuffer.class);
                GET_BUFFER_METHOD = ElasticByteBufferCls.getMethod("getBuffer", Boolean.TYPE, Integer.TYPE);
                PUT_BUFFER_METHOD = ElasticByteBufferCls.getMethod("putBuffer", ByteBuffer.class);
                bufferPool = ELASTIC_BYTE_BUFFER_CONSTRUCTOR.newInstance(new Object[0]);
            } else {
                ELASTIC_BYTE_BUFFER_CONSTRUCTOR = null;
                ElasticByteBufferCls = null;
                ByteBufferCls = null;
                ReadOptionCls = null;
                READ_METHOD = null;
                RELEASE_BUFFER_METHOD = null;
                GET_BUFFER_METHOD = null;
                PUT_BUFFER_METHOD = null;
                bufferPool = null;
            }
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Can't find class", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Can't find constructor ", e);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Can't create instance ", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Can't create instance ", e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Can't create instance ", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Can't create instance ", e);
        }
    }

    public static void releaseBuffer(FSDataInputStream f, ByteBuffer buf) {
        if (useV21) {
            try {
                RELEASE_BUFFER_METHOD.invoke((Object)f, buf);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Can't call method", e);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Can't call method", e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException("Can't call method", e);
            }
        }
    }

    public static int getInt(FSDataInputStream f) throws IOException {
        ByteBuffer int32Buf = CompatibilityUtil.getBuf(f, 4).order(ByteOrder.LITTLE_ENDIAN);
        if (int32Buf.remaining() == 4) {
            int res = int32Buf.getInt();
            CompatibilityUtil.releaseBuffer(f, int32Buf);
            return res;
        }
        ByteBuffer tmpBuf = int32Buf;
        int32Buf = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
        int32Buf.put(tmpBuf);
        CompatibilityUtil.releaseBuffer(f, tmpBuf);
        while (int32Buf.hasRemaining()) {
            tmpBuf = CompatibilityUtil.getBuf(f, int32Buf.remaining());
            int32Buf.put(tmpBuf);
            CompatibilityUtil.releaseBuffer(f, tmpBuf);
        }
        return int32Buf.getInt();
    }

    public static ByteBuffer getBuf(FSDataInputStream f, int maxSize) throws IOException {
        ByteBuffer res = null;
        if (useV21) {
            try {
                res = (ByteBuffer)READ_METHOD.invoke((Object)f, ELASTIC_BYTE_BUFFER_CONSTRUCTOR.newInstance(new Object[0]), maxSize, EnumSet.of(Enum.valueOf(ReadOptionCls, "SKIP_CHECKSUMS")));
            }
            catch (Exception e) {
                byte[] buf = new byte[maxSize];
                f.read(buf, 0, maxSize);
                res = ByteBuffer.wrap(buf);
            }
        } else {
            byte[] buf = new byte[maxSize];
            int size = f.read(buf, 0, maxSize);
            res = ByteBuffer.wrap(buf, 0, size);
        }
        if (res == null) {
            throw new EOFException("Null ByteBuffer returned");
        }
        return res;
    }

    public static ByteBuffer getBuf(FSDataInputStream f, ByteBuffer readBuf, int maxSize) throws IOException {
        Class[] ZCopyArgs = new Class[]{ByteBuffer.class};
        int res = 0;
        int l = readBuf.remaining();
        if (useV21) {
            try {
                res = f.read(readBuf);
            }
            catch (UnsupportedOperationException e) {
                byte[] buf = new byte[maxSize];
                res = f.read(buf);
                readBuf.put(buf, 0, maxSize);
            }
        } else {
            byte[] buf = new byte[maxSize];
            res = f.read(buf);
            readBuf.put(buf, 0, maxSize);
        }
        if (res == 0) {
            throw new EOFException("Null ByteBuffer returned");
        }
        return readBuf;
    }

    public static void bbCopy(ByteBuffer dst, ByteBuffer src) {
        int n = Math.min(dst.remaining(), src.remaining());
        int i = 0;
        while (i < n) {
            dst.put(src.get());
            ++i;
        }
    }

    public static <T extends TBase<?, ?>> T read(FSDataInputStream f, T tbase) throws IOException {
        try {
            tbase.read(new TCompactProtocol(new TIOStreamTransport((InputStream)f)));
            return tbase;
        }
        catch (TException e) {
            throw new IOException("can not read " + tbase.getClass() + ": " + e.getMessage(), e);
        }
    }

    private static final class FSDISTransport
    extends TTransport {
        private final FSDataInputStream fsdis;
        private ByteBuffer tbuf;
        private ByteBuffer slice;

        private FSDISTransport(FSDataInputStream f) {
            this.fsdis = f;
        }

        @Override
        public boolean isOpen() {
            return true;
        }

        @Override
        public boolean peek() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void open() throws TTransportException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int read(byte[] bytes, int i, int i2) throws TTransportException {
            throw new UnsupportedOperationException("ByteBuffer API to be used");
        }

        @Override
        public int readAll(byte[] buf, int off, int len) throws TTransportException {
            ByteBuffer tmpBuf = this.readFully(len);
            tmpBuf.get(buf, off, len);
            return len;
        }

        @Override
        public void write(byte[] buf) throws TTransportException {
            throw new UnsupportedOperationException("Read-Only implementation");
        }

        @Override
        public void write(byte[] bytes, int i, int i2) throws TTransportException {
            throw new UnsupportedOperationException("Read-Only implementation");
        }

        @Override
        public void flush() throws TTransportException {
            throw new UnsupportedOperationException("Read-Only implementation");
        }

        @Override
        public byte[] getBuffer() {
            if (this.tbuf == null) {
                return null;
            }
            int pos = this.tbuf.position();
            this.tbuf.rewind();
            byte[] buf = new byte[this.tbuf.remaining()];
            this.tbuf.get(buf);
            this.tbuf.position(pos);
            return buf;
        }

        @Override
        public int getBufferPosition() {
            if (this.tbuf == null) {
                return 0;
            }
            return this.tbuf.position();
        }

        @Override
        public int getBytesRemainingInBuffer() {
            if (this.tbuf == null) {
                return 0;
            }
            return this.tbuf.remaining();
        }

        @Override
        public void consumeBuffer(int len) {
            if (this.tbuf == null) {
                return;
            }
            int pos = this.tbuf.position();
            this.tbuf.position(pos + len);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public byte readByte() throws TTransportException {
            try {
                while (true) {
                    if (this.tbuf == null) {
                        this.tbuf = CompatibilityUtil.getBuf(this.fsdis, 0x100000);
                    }
                    if (this.tbuf.hasRemaining()) {
                        byte by = this.tbuf.get();
                        return by;
                    }
                    this.release(this.tbuf);
                    continue;
                    break;
                }
            }
            catch (IOException ioe) {
                throw new TTransportException("Hadoop FS", (Throwable)ioe);
            }
            finally {
                this.release(this.tbuf);
            }
        }

        public ByteBuffer readFully(int size) throws TTransportException {
            try {
                Buffer newBuf = null;
                do {
                    if (this.tbuf == null) {
                        this.tbuf = CompatibilityUtil.getBuf(this.fsdis, 0x100000);
                    }
                    if (newBuf == null) {
                        if (this.tbuf.remaining() >= size) {
                            int lim = this.tbuf.limit();
                            this.tbuf.limit(this.tbuf.position() + size);
                            this.slice = this.tbuf.slice();
                            this.tbuf.position(this.tbuf.limit());
                            this.tbuf.limit(lim);
                            return this.slice;
                        }
                        try {
                            newBuf = (ByteBuffer)GET_BUFFER_METHOD.invoke(bufferPool, false, size);
                        }
                        catch (IllegalAccessException e) {
                            throw new TTransportException("Hadoop FS", (Throwable)e);
                        }
                        catch (IllegalArgumentException e) {
                            throw new TTransportException("Hadoop FS", (Throwable)e);
                        }
                        catch (InvocationTargetException e) {
                            throw new TTransportException("Hadoop FS", (Throwable)e);
                        }
                        ((ByteBuffer)newBuf).limit(size).position(0);
                    }
                    CompatibilityUtil.bbCopy(newBuf, this.tbuf);
                    this.release(this.tbuf);
                } while (newBuf.hasRemaining());
                ((ByteBuffer)newBuf).flip();
                if (newBuf.remaining() != size) {
                    throw new TTransportException("boom");
                }
                return newBuf;
            }
            catch (IOException ioe) {
                throw new TTransportException("Hadoop FS", (Throwable)ioe);
            }
        }

        public void release(ByteBuffer b) {
            if (b == null) {
                return;
            }
            if (b == this.slice) {
                this.slice = null;
            } else if (b == this.tbuf) {
                if (!this.tbuf.hasRemaining()) {
                    CompatibilityUtil.releaseBuffer(this.fsdis, this.tbuf);
                    this.tbuf = null;
                }
            } else {
                try {
                    PUT_BUFFER_METHOD.invoke(bufferPool, b);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException("Can't call method", e);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Can't call method", e);
                }
                catch (InvocationTargetException e) {
                    throw new IllegalArgumentException("Can't call method", e);
                }
            }
        }
    }
}

