/*
 * Decompiled with CFR 0.152.
 */
package parquet.hadoop.metadata;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.List;
import parquet.hadoop.metadata.BlockMetaData;
import parquet.hadoop.metadata.FileMetaData;
import parquet.org.codehaus.jackson.JsonGenerationException;
import parquet.org.codehaus.jackson.JsonParseException;
import parquet.org.codehaus.jackson.map.JsonMappingException;
import parquet.org.codehaus.jackson.map.ObjectMapper;
import parquet.org.codehaus.jackson.map.SerializationConfig;

public class ParquetMetadata {
    private static ObjectMapper objectMapper = new ObjectMapper();
    private static ObjectMapper prettyObjectMapper = new ObjectMapper();
    private final FileMetaData fileMetaData;
    private final List<BlockMetaData> blocks;

    static {
        prettyObjectMapper.configure(SerializationConfig.Feature.INDENT_OUTPUT, true);
    }

    public static String toJSON(ParquetMetadata parquetMetaData) {
        return ParquetMetadata.toJSON(parquetMetaData, objectMapper);
    }

    public static String toPrettyJSON(ParquetMetadata parquetMetaData) {
        return ParquetMetadata.toJSON(parquetMetaData, prettyObjectMapper);
    }

    private static String toJSON(ParquetMetadata parquetMetaData, ObjectMapper mapper) {
        StringWriter stringWriter = new StringWriter();
        try {
            mapper.writeValue(stringWriter, (Object)parquetMetaData);
        }
        catch (JsonGenerationException e) {
            throw new RuntimeException(e);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return stringWriter.toString();
    }

    public static ParquetMetadata fromJSON(String json) {
        try {
            return objectMapper.readValue((Reader)new StringReader(json), ParquetMetadata.class);
        }
        catch (JsonParseException e) {
            throw new RuntimeException(e);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ParquetMetadata(FileMetaData fileMetaData, List<BlockMetaData> blocks) {
        this.fileMetaData = fileMetaData;
        this.blocks = blocks;
    }

    public List<BlockMetaData> getBlocks() {
        return this.blocks;
    }

    public FileMetaData getFileMetaData() {
        return this.fileMetaData;
    }

    public String toString() {
        return "ParquetMetaData{" + this.fileMetaData + ", blocks: " + this.blocks + "}";
    }
}

