/*
 * Decompiled with CFR 0.152.
 */
package parquet.hadoop.metadata;

import parquet.format.CompressionCodec;
import parquet.hadoop.codec.CompressionCodecNotSupportedException;

public enum CompressionCodecName {
    UNCOMPRESSED(null, CompressionCodec.UNCOMPRESSED, ""),
    SNAPPY("parquet.hadoop.codec.SnappyCodec", CompressionCodec.SNAPPY, ".snappy"),
    GZIP("org.apache.hadoop.io.compress.GzipCodec", CompressionCodec.GZIP, ".gz"),
    LZO("com.hadoop.compression.lzo.LzoCodec", CompressionCodec.LZO, ".lzo");

    private final String hadoopCompressionCodecClass;
    private final CompressionCodec parquetCompressionCodec;
    private final String extension;

    public static CompressionCodecName fromConf(String name) {
        if (name == null) {
            return UNCOMPRESSED;
        }
        return CompressionCodecName.valueOf(name.toUpperCase());
    }

    public static CompressionCodecName fromCompressionCodec(Class<?> clazz) {
        if (clazz == null) {
            return UNCOMPRESSED;
        }
        String name = clazz.getName();
        CompressionCodecName[] compressionCodecNameArray = CompressionCodecName.values();
        int n = compressionCodecNameArray.length;
        int n2 = 0;
        while (n2 < n) {
            CompressionCodecName codec = compressionCodecNameArray[n2];
            if (name.equals(codec.getHadoopCompressionCodecClassName())) {
                return codec;
            }
            ++n2;
        }
        throw new CompressionCodecNotSupportedException(clazz);
    }

    public static CompressionCodecName fromParquet(CompressionCodec codec) {
        CompressionCodecName[] compressionCodecNameArray = CompressionCodecName.values();
        int n = compressionCodecNameArray.length;
        int n2 = 0;
        while (n2 < n) {
            CompressionCodecName codecName = compressionCodecNameArray[n2];
            if (codec.equals(codecName.parquetCompressionCodec)) {
                return codecName;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Unknown compression codec " + codec);
    }

    private CompressionCodecName(String hadoopCompressionCodecClass, CompressionCodec parquetCompressionCodec, String extension) {
        this.hadoopCompressionCodecClass = hadoopCompressionCodecClass;
        this.parquetCompressionCodec = parquetCompressionCodec;
        this.extension = extension;
    }

    public String getHadoopCompressionCodecClassName() {
        return this.hadoopCompressionCodecClass;
    }

    public Class getHadoopCompressionCodecClass() {
        String codecClassName = this.getHadoopCompressionCodecClassName();
        if (codecClassName == null) {
            return null;
        }
        try {
            return Class.forName(codecClassName);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public CompressionCodec getParquetCompressionCodec() {
        return this.parquetCompressionCodec;
    }

    public String getExtension() {
        return this.extension;
    }
}

