/*
 * Decompiled with CFR 0.152.
 */
package parquet.hadoop;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import parquet.Log;
import parquet.filter.UnboundRecordFilter;
import parquet.hadoop.BadConfigurationException;
import parquet.hadoop.Footer;
import parquet.hadoop.ParquetFileReader;
import parquet.hadoop.ParquetFileWriter;
import parquet.hadoop.ParquetInputSplit;
import parquet.hadoop.ParquetRecordReader;
import parquet.hadoop.api.InitContext;
import parquet.hadoop.api.ReadSupport;
import parquet.hadoop.metadata.BlockMetaData;
import parquet.hadoop.metadata.ColumnChunkMetaData;
import parquet.hadoop.metadata.FileMetaData;
import parquet.hadoop.metadata.GlobalMetaData;
import parquet.hadoop.metadata.ParquetMetadata;
import parquet.hadoop.util.ConfigurationUtil;
import parquet.hadoop.util.ContextUtil;
import parquet.io.ParquetDecodingException;
import parquet.schema.MessageType;
import parquet.schema.MessageTypeParser;

public class ParquetInputFormat<T>
extends FileInputFormat<Void, T> {
    private static final Log LOG = Log.getLog(ParquetInputFormat.class);
    public static final String READ_SUPPORT_CLASS = "parquet.read.support.class";
    public static final String UNBOUND_RECORD_FILTER = "parquet.read.filter";
    private Class<?> readSupportClass;
    private List<Footer> footers;
    private static final PathFilter hiddenFileFilter = new PathFilter(){

        public boolean accept(Path p) {
            String name = p.getName();
            return !name.startsWith("_") && !name.startsWith(".");
        }
    };

    public static void setReadSupportClass(Job job, Class<?> readSupportClass) {
        ContextUtil.getConfiguration((JobContext)job).set(READ_SUPPORT_CLASS, readSupportClass.getName());
    }

    public static void setUnboundRecordFilter(Job job, Class<? extends UnboundRecordFilter> filterClass) {
        ContextUtil.getConfiguration((JobContext)job).set(UNBOUND_RECORD_FILTER, filterClass.getName());
    }

    public static Class<?> getUnboundRecordFilter(Configuration configuration) {
        return ConfigurationUtil.getClassFromConfig(configuration, UNBOUND_RECORD_FILTER, UnboundRecordFilter.class);
    }

    public static void setReadSupportClass(JobConf conf, Class<?> readSupportClass) {
        conf.set(READ_SUPPORT_CLASS, readSupportClass.getName());
    }

    public static Class<?> getReadSupportClass(Configuration configuration) {
        return ConfigurationUtil.getClassFromConfig(configuration, READ_SUPPORT_CLASS, ReadSupport.class);
    }

    public ParquetInputFormat() {
    }

    public <S extends ReadSupport<T>> ParquetInputFormat(Class<S> readSupportClass) {
        this.readSupportClass = readSupportClass;
    }

    public RecordReader<Void, T> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        ReadSupport<T> readSupport = this.getReadSupport(ContextUtil.getConfiguration((JobContext)taskAttemptContext));
        Class<?> unboundRecordFilterClass = ParquetInputFormat.getUnboundRecordFilter(ContextUtil.getConfiguration((JobContext)taskAttemptContext));
        if (unboundRecordFilterClass == null) {
            return new ParquetRecordReader<T>(readSupport);
        }
        try {
            return new ParquetRecordReader<T>(readSupport, (UnboundRecordFilter)unboundRecordFilterClass.newInstance());
        }
        catch (InstantiationException e) {
            throw new BadConfigurationException("could not instantiate unbound record filter class", e);
        }
        catch (IllegalAccessException e) {
            throw new BadConfigurationException("could not instantiate unbound record filter class", e);
        }
    }

    public ReadSupport<T> getReadSupport(Configuration configuration) {
        try {
            if (this.readSupportClass == null) {
                this.readSupportClass = ParquetInputFormat.getReadSupportClass(configuration);
            }
            return (ReadSupport)this.readSupportClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new BadConfigurationException("could not instantiate read support class", e);
        }
        catch (IllegalAccessException e) {
            throw new BadConfigurationException("could not instantiate read support class", e);
        }
    }

    static <T> List<ParquetInputSplit> generateSplits(List<BlockMetaData> rowGroupBlocks, BlockLocation[] hdfsBlocksArray, FileStatus fileStatus, FileMetaData fileMetaData, String requestedSchema, Map<String, String> readSupportMetadata, long minSplitSize, long maxSplitSize) throws IOException {
        if (maxSplitSize < minSplitSize || maxSplitSize < 0L || minSplitSize < 0L) {
            throw new ParquetDecodingException("maxSplitSize and minSplitSize should be positive and max should be greater or equal to the minSplitSize: maxSplitSize = " + maxSplitSize + "; minSplitSize is " + minSplitSize);
        }
        String fileSchema = fileMetaData.getSchema().toString().intern();
        HDFSBlocks hdfsBlocks = new HDFSBlocks(hdfsBlocksArray);
        hdfsBlocks.checkBelongingToANewHDFSBlock(rowGroupBlocks.get(0));
        SplitInfo currentSplit = new SplitInfo(hdfsBlocks.getCurrentBlock());
        ArrayList<SplitInfo> splitRowGroups = new ArrayList<SplitInfo>();
        ParquetInputFormat.checkSorted(rowGroupBlocks);
        for (BlockMetaData rowGroupMetadata : rowGroupBlocks) {
            if (hdfsBlocks.checkBelongingToANewHDFSBlock(rowGroupMetadata) && currentSplit.getCompressedByteSize() >= minSplitSize && currentSplit.getCompressedByteSize() > 0L || currentSplit.getCompressedByteSize() >= maxSplitSize) {
                splitRowGroups.add(currentSplit);
                currentSplit = new SplitInfo(hdfsBlocks.getCurrentBlock());
            }
            currentSplit.addRowGroup(rowGroupMetadata);
        }
        if (currentSplit.getRowGroupCount() > 0) {
            splitRowGroups.add(currentSplit);
        }
        ArrayList<ParquetInputSplit> resultSplits = new ArrayList<ParquetInputSplit>();
        for (SplitInfo splitInfo : splitRowGroups) {
            ParquetInputSplit split = splitInfo.getParquetInputSplit(fileStatus, fileMetaData, requestedSchema, readSupportMetadata, fileSchema);
            resultSplits.add(split);
        }
        return resultSplits;
    }

    private static void checkSorted(List<BlockMetaData> rowGroupBlocks) {
        long previousOffset = 0L;
        for (BlockMetaData rowGroup : rowGroupBlocks) {
            long currentOffset = rowGroup.getStartingPos();
            if (currentOffset >= previousOffset) continue;
            throw new ParquetDecodingException("row groups are not sorted: previous row groups starts at " + previousOffset + ", current row group starts at " + currentOffset);
        }
    }

    public List<InputSplit> getSplits(JobContext jobContext) throws IOException {
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        splits.addAll(this.getSplits(ContextUtil.getConfiguration(jobContext), this.getFooters(jobContext)));
        return splits;
    }

    public List<ParquetInputSplit> getSplits(Configuration configuration, List<Footer> footers) throws IOException {
        long maxSplitSize = configuration.getLong("mapred.max.split.size", Long.MAX_VALUE);
        long minSplitSize = Math.max(this.getFormatMinSplitSize(), configuration.getLong("mapred.min.split.size", 0L));
        if (maxSplitSize < 0L || minSplitSize < 0L) {
            throw new ParquetDecodingException("maxSplitSize or minSplitSie should not be negative: maxSplitSize = " + maxSplitSize + "; minSplitSize = " + minSplitSize);
        }
        ArrayList<ParquetInputSplit> splits = new ArrayList<ParquetInputSplit>();
        GlobalMetaData globalMetaData = ParquetFileWriter.getGlobalMetaData(footers);
        ReadSupport.ReadContext readContext = this.getReadSupport(configuration).init(new InitContext(configuration, globalMetaData.getKeyValueMetaData(), globalMetaData.getSchema()));
        for (Footer footer : footers) {
            Path file = footer.getFile();
            LOG.debug(file);
            FileSystem fs = file.getFileSystem(configuration);
            FileStatus fileStatus = fs.getFileStatus(file);
            ParquetMetadata parquetMetaData = footer.getParquetMetadata();
            List<BlockMetaData> blocks = parquetMetaData.getBlocks();
            BlockLocation[] fileBlockLocations = fs.getFileBlockLocations(fileStatus, 0L, fileStatus.getLen());
            splits.addAll(ParquetInputFormat.generateSplits(blocks, fileBlockLocations, fileStatus, parquetMetaData.getFileMetaData(), readContext.getRequestedSchema().toString(), readContext.getReadSupportMetadata(), minSplitSize, maxSplitSize));
        }
        return splits;
    }

    protected List<FileStatus> listStatus(JobContext jobContext) throws IOException {
        return ParquetInputFormat.getAllFileRecursively(super.listStatus(jobContext), ContextUtil.getConfiguration(jobContext));
    }

    private static List<FileStatus> getAllFileRecursively(List<FileStatus> files, Configuration conf) throws IOException {
        ArrayList<FileStatus> result = new ArrayList<FileStatus>();
        int len = files.size();
        int i = 0;
        while (i < len) {
            FileStatus file = files.get(i);
            if (file.isDir()) {
                Path p = file.getPath();
                FileSystem fs = p.getFileSystem(conf);
                ParquetInputFormat.staticAddInputPathRecursively(result, fs, p, hiddenFileFilter);
            } else {
                result.add(file);
            }
            ++i;
        }
        LOG.info("Total input paths to process : " + result.size());
        return result;
    }

    private static void staticAddInputPathRecursively(List<FileStatus> result, FileSystem fs, Path path, PathFilter inputFilter) throws IOException {
        FileStatus[] fileStatusArray = fs.listStatus(path, inputFilter);
        int n = fileStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            FileStatus stat = fileStatusArray[n2];
            if (stat.isDir()) {
                ParquetInputFormat.staticAddInputPathRecursively(result, fs, stat.getPath(), inputFilter);
            } else {
                result.add(stat);
            }
            ++n2;
        }
    }

    public List<Footer> getFooters(JobContext jobContext) throws IOException {
        if (this.footers == null) {
            this.footers = this.getFooters(ContextUtil.getConfiguration(jobContext), this.listStatus(jobContext));
        }
        return this.footers;
    }

    public List<Footer> getFooters(Configuration configuration, List<FileStatus> statuses) throws IOException {
        LOG.debug("reading " + statuses.size() + " files");
        return ParquetFileReader.readAllFootersInParallelUsingSummaryFiles(configuration, statuses);
    }

    public GlobalMetaData getGlobalMetaData(JobContext jobContext) throws IOException {
        return ParquetFileWriter.getGlobalMetaData(this.getFooters(jobContext));
    }

    private static class HDFSBlocks {
        BlockLocation[] hdfsBlocks;
        int currentStartHdfsBlockIndex = 0;
        int currentMidPointHDFSBlockIndex = 0;

        private HDFSBlocks(BlockLocation[] hdfsBlocks) {
            this.hdfsBlocks = hdfsBlocks;
            Comparator<BlockLocation> comparator = new Comparator<BlockLocation>(){

                @Override
                public int compare(BlockLocation b1, BlockLocation b2) {
                    return Long.signum(b1.getOffset() - b2.getOffset());
                }
            };
            Arrays.sort(hdfsBlocks, comparator);
        }

        private long getHDFSBlockEndingPosition(int hdfsBlockIndex) {
            BlockLocation hdfsBlock = this.hdfsBlocks[hdfsBlockIndex];
            return hdfsBlock.getOffset() + hdfsBlock.getLength() - 1L;
        }

        private boolean checkBelongingToANewHDFSBlock(BlockMetaData rowGroupMetadata) {
            boolean isNewHdfsBlock = false;
            long rowGroupMidPoint = rowGroupMetadata.getStartingPos() + rowGroupMetadata.getCompressedSize() / 2L;
            while (rowGroupMidPoint > this.getHDFSBlockEndingPosition(this.currentMidPointHDFSBlockIndex)) {
                isNewHdfsBlock = true;
                ++this.currentMidPointHDFSBlockIndex;
                if (this.currentMidPointHDFSBlockIndex < this.hdfsBlocks.length) continue;
                throw new ParquetDecodingException("the row group is not in hdfs blocks in the file: midpoint of row groups is " + rowGroupMidPoint + ", the end of the hdfs block is " + this.getHDFSBlockEndingPosition(this.currentMidPointHDFSBlockIndex - 1));
            }
            while (rowGroupMetadata.getStartingPos() > this.getHDFSBlockEndingPosition(this.currentStartHdfsBlockIndex)) {
                ++this.currentStartHdfsBlockIndex;
                if (this.currentStartHdfsBlockIndex < this.hdfsBlocks.length) continue;
                throw new ParquetDecodingException("The row group does not start in this file: row group offset is " + rowGroupMetadata.getStartingPos() + " but the end of hdfs blocks of file is " + this.getHDFSBlockEndingPosition(this.currentStartHdfsBlockIndex));
            }
            return isNewHdfsBlock;
        }

        public BlockLocation get(int hdfsBlockIndex) {
            return this.hdfsBlocks[hdfsBlockIndex];
        }

        public BlockLocation getCurrentBlock() {
            return this.hdfsBlocks[this.currentStartHdfsBlockIndex];
        }
    }

    private static class SplitInfo {
        List<BlockMetaData> rowGroups = new ArrayList<BlockMetaData>();
        BlockLocation hdfsBlock;
        long compressedByteSize = 0L;

        public SplitInfo(BlockLocation currentBlock) {
            this.hdfsBlock = currentBlock;
        }

        private void addRowGroup(BlockMetaData rowGroup) {
            this.rowGroups.add(rowGroup);
            this.compressedByteSize += rowGroup.getCompressedSize();
        }

        public long getCompressedByteSize() {
            return this.compressedByteSize;
        }

        public List<BlockMetaData> getRowGroups() {
            return this.rowGroups;
        }

        int getRowGroupCount() {
            return this.rowGroups.size();
        }

        public ParquetInputSplit getParquetInputSplit(FileStatus fileStatus, FileMetaData fileMetaData, String requestedSchema, Map<String, String> readSupportMetadata, String fileSchema) throws IOException {
            MessageType requested = MessageTypeParser.parseMessageType(requestedSchema);
            long length = 0L;
            for (BlockMetaData block : this.getRowGroups()) {
                List<ColumnChunkMetaData> columns = block.getColumns();
                for (ColumnChunkMetaData column : columns) {
                    if (!requested.containsPath(column.getPath().toArray())) continue;
                    length += column.getTotalSize();
                }
            }
            return new ParquetInputSplit(fileStatus.getPath(), this.hdfsBlock.getOffset(), length, this.hdfsBlock.getHosts(), this.getRowGroups(), requestedSchema, fileSchema, fileMetaData.getKeyValueMetaData(), readSupportMetadata);
        }
    }
}

