/*
 * Decompiled with CFR 0.152.
 */
package parquet.column.values.dictionary;

import java.io.IOException;
import java.nio.ByteBuffer;
import parquet.Preconditions;
import parquet.bytes.BytesUtils;
import parquet.column.Dictionary;
import parquet.column.Encoding;
import parquet.column.page.DictionaryPage;
import parquet.column.values.plain.PlainValuesReader;
import parquet.io.ParquetDecodingException;
import parquet.io.api.Binary;

public abstract class PlainValuesDictionary
extends Dictionary {
    protected PlainValuesDictionary(DictionaryPage dictionaryPage) throws IOException {
        super(dictionaryPage.getEncoding());
        if (dictionaryPage.getEncoding() != Encoding.PLAIN_DICTIONARY) {
            throw new ParquetDecodingException("Dictionary data encoding type not supported: " + (Object)((Object)dictionaryPage.getEncoding()));
        }
    }

    public static class PlainBinaryDictionary
    extends PlainValuesDictionary {
        private Binary[] binaryDictionaryContent = null;

        public PlainBinaryDictionary(DictionaryPage dictionaryPage) throws IOException {
            this(dictionaryPage, null);
        }

        public PlainBinaryDictionary(DictionaryPage dictionaryPage, Integer length) throws IOException {
            super(dictionaryPage);
            ByteBuffer dictionaryBytes = dictionaryPage.getBytes().toByteBuffer();
            this.binaryDictionaryContent = new Binary[dictionaryPage.getDictionarySize()];
            int offset = dictionaryBytes.position();
            if (length == null) {
                int i = 0;
                while (i < this.binaryDictionaryContent.length) {
                    int len = BytesUtils.readIntLittleEndian(dictionaryBytes, offset);
                    this.binaryDictionaryContent[i] = Binary.fromByteBuffer(dictionaryBytes, offset += 4, len);
                    offset += len;
                    ++i;
                }
            } else {
                Preconditions.checkArgument(length > 0, "Invalid byte array length: " + length);
                int i = 0;
                while (i < this.binaryDictionaryContent.length) {
                    this.binaryDictionaryContent[i] = Binary.fromByteBuffer(dictionaryBytes, offset, length);
                    offset += length.intValue();
                    ++i;
                }
            }
        }

        @Override
        public Binary decodeToBinary(int id) {
            return this.binaryDictionaryContent[id];
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("PlainBinaryDictionary {\n");
            int i = 0;
            while (i < this.binaryDictionaryContent.length) {
                sb.append(i).append(" => ").append(this.binaryDictionaryContent[i]).append("\n");
                ++i;
            }
            return sb.append("}").toString();
        }

        @Override
        public int getMaxId() {
            return this.binaryDictionaryContent.length - 1;
        }
    }

    public static class PlainDoubleDictionary
    extends PlainValuesDictionary {
        private double[] doubleDictionaryContent = null;

        public PlainDoubleDictionary(DictionaryPage dictionaryPage) throws IOException {
            super(dictionaryPage);
            ByteBuffer dictionaryByteBuf = dictionaryPage.getBytes().toByteBuffer();
            this.doubleDictionaryContent = new double[dictionaryPage.getDictionarySize()];
            PlainValuesReader.DoublePlainValuesReader doubleReader = new PlainValuesReader.DoublePlainValuesReader();
            doubleReader.initFromPage(dictionaryPage.getDictionarySize(), dictionaryByteBuf, dictionaryByteBuf.position());
            int i = 0;
            while (i < this.doubleDictionaryContent.length) {
                this.doubleDictionaryContent[i] = doubleReader.readDouble();
                ++i;
            }
        }

        @Override
        public double decodeToDouble(int id) {
            return this.doubleDictionaryContent[id];
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("PlainDoubleDictionary {\n");
            int i = 0;
            while (i < this.doubleDictionaryContent.length) {
                sb.append(i).append(" => ").append(this.doubleDictionaryContent[i]).append("\n");
                ++i;
            }
            return sb.append("}").toString();
        }

        @Override
        public int getMaxId() {
            return this.doubleDictionaryContent.length - 1;
        }
    }

    public static class PlainFloatDictionary
    extends PlainValuesDictionary {
        private float[] floatDictionaryContent = null;

        public PlainFloatDictionary(DictionaryPage dictionaryPage) throws IOException {
            super(dictionaryPage);
            ByteBuffer dictionaryByteBuf = dictionaryPage.getBytes().toByteBuffer();
            this.floatDictionaryContent = new float[dictionaryPage.getDictionarySize()];
            PlainValuesReader.FloatPlainValuesReader floatReader = new PlainValuesReader.FloatPlainValuesReader();
            floatReader.initFromPage(dictionaryPage.getDictionarySize(), dictionaryByteBuf, dictionaryByteBuf.position());
            int i = 0;
            while (i < this.floatDictionaryContent.length) {
                this.floatDictionaryContent[i] = floatReader.readFloat();
                ++i;
            }
        }

        @Override
        public float decodeToFloat(int id) {
            return this.floatDictionaryContent[id];
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("PlainFloatDictionary {\n");
            int i = 0;
            while (i < this.floatDictionaryContent.length) {
                sb.append(i).append(" => ").append(this.floatDictionaryContent[i]).append("\n");
                ++i;
            }
            return sb.append("}").toString();
        }

        @Override
        public int getMaxId() {
            return this.floatDictionaryContent.length - 1;
        }
    }

    public static class PlainIntegerDictionary
    extends PlainValuesDictionary {
        private int[] intDictionaryContent = null;

        public PlainIntegerDictionary(DictionaryPage dictionaryPage) throws IOException {
            super(dictionaryPage);
            ByteBuffer dictionaryByteBuf = dictionaryPage.getBytes().toByteBuffer();
            this.intDictionaryContent = new int[dictionaryPage.getDictionarySize()];
            PlainValuesReader.IntegerPlainValuesReader intReader = new PlainValuesReader.IntegerPlainValuesReader();
            intReader.initFromPage(dictionaryPage.getDictionarySize(), dictionaryByteBuf, dictionaryByteBuf.position());
            int i = 0;
            while (i < this.intDictionaryContent.length) {
                this.intDictionaryContent[i] = intReader.readInteger();
                ++i;
            }
        }

        @Override
        public int decodeToInt(int id) {
            return this.intDictionaryContent[id];
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("PlainIntegerDictionary {\n");
            int i = 0;
            while (i < this.intDictionaryContent.length) {
                sb.append(i).append(" => ").append(this.intDictionaryContent[i]).append("\n");
                ++i;
            }
            return sb.append("}").toString();
        }

        @Override
        public int getMaxId() {
            return this.intDictionaryContent.length - 1;
        }
    }

    public static class PlainLongDictionary
    extends PlainValuesDictionary {
        private long[] longDictionaryContent = null;

        public PlainLongDictionary(DictionaryPage dictionaryPage) throws IOException {
            super(dictionaryPage);
            ByteBuffer dictionaryByteBuf = dictionaryPage.getBytes().toByteBuffer();
            this.longDictionaryContent = new long[dictionaryPage.getDictionarySize()];
            PlainValuesReader.LongPlainValuesReader longReader = new PlainValuesReader.LongPlainValuesReader();
            longReader.initFromPage(dictionaryPage.getDictionarySize(), dictionaryByteBuf, dictionaryByteBuf.position());
            int i = 0;
            while (i < this.longDictionaryContent.length) {
                this.longDictionaryContent[i] = longReader.readLong();
                ++i;
            }
        }

        @Override
        public long decodeToLong(int id) {
            return this.longDictionaryContent[id];
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("PlainLongDictionary {\n");
            int i = 0;
            while (i < this.longDictionaryContent.length) {
                sb.append(i).append(" => ").append(this.longDictionaryContent[i]).append("\n");
                ++i;
            }
            return sb.append("}").toString();
        }

        @Override
        public int getMaxId() {
            return this.longDictionaryContent.length - 1;
        }
    }
}

