/*
 * Decompiled with CFR 0.152.
 */
package parquet.column.values.deltalengthbytearray;

import java.io.IOException;
import parquet.Log;
import parquet.bytes.ByteBufferAllocator;
import parquet.bytes.BytesInput;
import parquet.bytes.CapacityByteArrayOutputStream;
import parquet.bytes.LittleEndianDataOutputStream;
import parquet.column.Encoding;
import parquet.column.values.ValuesWriter;
import parquet.column.values.delta.DeltaBinaryPackingValuesWriter;
import parquet.io.ParquetEncodingException;
import parquet.io.api.Binary;

public class DeltaLengthByteArrayValuesWriter
extends ValuesWriter {
    private static final Log LOG = Log.getLog(DeltaLengthByteArrayValuesWriter.class);
    private ValuesWriter lengthWriter;
    private CapacityByteArrayOutputStream arrayOut;
    private LittleEndianDataOutputStream out;
    private ByteBufferAllocator allocator;

    public DeltaLengthByteArrayValuesWriter(int initialSize, ByteBufferAllocator allocator) {
        this.arrayOut = new CapacityByteArrayOutputStream(initialSize, allocator);
        this.out = new LittleEndianDataOutputStream(this.arrayOut);
        this.allocator = allocator;
        this.lengthWriter = new DeltaBinaryPackingValuesWriter(128, 4, initialSize, this.allocator);
    }

    @Override
    public void writeBytes(Binary v) {
        try {
            this.lengthWriter.writeInteger(v.length());
            this.out.write(v.getBytes());
        }
        catch (IOException e) {
            throw new ParquetEncodingException("could not write bytes", e);
        }
    }

    @Override
    public long getBufferedSize() {
        return this.lengthWriter.getBufferedSize() + this.arrayOut.size();
    }

    @Override
    public BytesInput getBytes() {
        try {
            this.out.flush();
        }
        catch (IOException e) {
            throw new ParquetEncodingException("could not write page", e);
        }
        if (Log.DEBUG) {
            LOG.debug("writing a buffer of size " + this.arrayOut.size());
        }
        return BytesInput.concat(this.lengthWriter.getBytes(), BytesInput.from(this.arrayOut));
    }

    @Override
    public Encoding getEncoding() {
        return Encoding.DELTA_LENGTH_BYTE_ARRAY;
    }

    @Override
    public void reset() {
        this.lengthWriter.reset();
        this.arrayOut.reset();
    }

    @Override
    public void close() {
        this.lengthWriter.close();
        this.arrayOut.close();
    }

    @Override
    public long getAllocatedSize() {
        return this.lengthWriter.getAllocatedSize() + (long)this.arrayOut.getCapacity();
    }

    @Override
    public String memUsageString(String prefix) {
        return this.arrayOut.memUsageString(String.valueOf(this.lengthWriter.memUsageString(prefix)) + " DELTA_LENGTH_BYTE_ARRAY");
    }
}

