/*
 * Decompiled with CFR 0.152.
 */
package parquet.column.values.boundedint;

import java.io.IOException;
import java.nio.ByteBuffer;
import parquet.io.ParquetDecodingException;

class BitReader {
    private int currentByte = 0;
    private int currentPosition = 8;
    private ByteBuffer buf;
    private int currentBufferPosition = 0;
    private static final int[] byteGetValueMask = new int[8];
    private static final int[] readMask = new int[32];
    private int endBufferPosistion;

    static {
        int currentMask = 1;
        int i = 0;
        while (i < byteGetValueMask.length) {
            BitReader.byteGetValueMask[i] = currentMask;
            currentMask <<= 1;
            ++i;
        }
        currentMask = 0;
        i = 0;
        while (i < readMask.length) {
            BitReader.readMask[i] = currentMask;
            currentMask <<= 1;
            ++currentMask;
            ++i;
        }
    }

    BitReader() {
    }

    public void prepare(ByteBuffer buf, int offset, int length) {
        this.buf = buf;
        this.endBufferPosistion = offset + length;
        this.currentByte = 0;
        this.currentPosition = 8;
        this.currentBufferPosition = offset;
    }

    private static boolean extractBit(int val, int bit) {
        return (val & byteGetValueMask[bit]) != 0;
    }

    public int readNBitInteger(int bitsPerValue) {
        int bits = bitsPerValue + this.currentPosition;
        int currentValue = this.currentByte >>> this.currentPosition;
        int toShift = 8 - this.currentPosition;
        while (bits >= 8) {
            this.currentByte = this.getNextByte();
            currentValue |= this.currentByte << toShift;
            toShift += 8;
            bits -= 8;
        }
        this.currentPosition = (bitsPerValue + this.currentPosition) % 8;
        return currentValue &= readMask[bitsPerValue];
    }

    private int getNextByte() {
        if (this.currentBufferPosition < this.endBufferPosistion) {
            return this.buf.get(this.currentBufferPosition++) & 0xFF;
        }
        return 0;
    }

    public boolean readBit() throws IOException {
        if (this.currentPosition == 8) {
            this.currentByte = this.getNextByte();
            this.currentPosition = 0;
        }
        return BitReader.extractBit(this.currentByte, this.currentPosition++);
    }

    public int readByte() {
        this.currentByte |= this.getNextByte() << 8;
        int value = this.currentByte >>> this.currentPosition & 0xFF;
        this.currentByte >>>= 8;
        return value;
    }

    public int readUnsignedVarint() throws IOException {
        int b;
        int value = 0;
        int i = 0;
        while (((b = this.readByte()) & 0x80) != 0) {
            value |= (b & 0x7F) << i;
            if ((i += 7) <= 35) continue;
            throw new ParquetDecodingException("Variable length quantity is too long");
        }
        return value | b << i;
    }
}

