/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.ql.io.parquet.convert.HiveSchemaConverter;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.junit.Assert;
import org.junit.Test;
import parquet.schema.MessageType;
import parquet.schema.MessageTypeParser;
import parquet.schema.OriginalType;
import parquet.schema.Type;

public class TestHiveSchemaConverter {
    private List<String> createHiveColumnsFrom(String columnNamesStr) {
        List<Object> columnNames = columnNamesStr.length() == 0 ? new ArrayList() : Arrays.asList(columnNamesStr.split(","));
        return columnNames;
    }

    private List<TypeInfo> createHiveTypeInfoFrom(String columnsTypeStr) {
        ArrayList<TypeInfo> columnTypes = columnsTypeStr.length() == 0 ? new ArrayList<TypeInfo>() : TypeInfoUtils.getTypeInfosFromTypeString((String)columnsTypeStr);
        return columnTypes;
    }

    private void testConversion(String columnNamesStr, String columnsTypeStr, String expectedSchema) throws Exception {
        List<String> columnNames = this.createHiveColumnsFrom(columnNamesStr);
        List<TypeInfo> columnTypes = this.createHiveTypeInfoFrom(columnsTypeStr);
        MessageType messageTypeFound = HiveSchemaConverter.convert(columnNames, columnTypes);
        MessageType expectedMT = MessageTypeParser.parseMessageType((String)expectedSchema);
        Assert.assertEquals((String)("converting " + columnNamesStr + ": " + columnsTypeStr + " to " + expectedSchema), (Object)expectedMT, (Object)messageTypeFound);
    }

    @Test
    public void testSimpleType() throws Exception {
        this.testConversion("a,b,c", "int,double,boolean", "message hive_schema {\n  optional int32 a;\n  optional double b;\n  optional boolean c;\n}\n");
    }

    @Test
    public void testArray() throws Exception {
        this.testConversion("arrayCol", "array<int>", "message hive_schema {\n  optional group arrayCol (LIST) {\n    repeated group bag {\n      optional int32 array_element;\n    }\n  }\n}\n");
    }

    @Test
    public void testStruct() throws Exception {
        this.testConversion("structCol", "struct<a:int,b:double,c:boolean>", "message hive_schema {\n  optional group structCol {\n    optional int32 a;\n    optional double b;\n    optional boolean c;\n  }\n}\n");
    }

    @Test
    public void testMap() throws Exception {
        this.testConversion("mapCol", "map<string,string>", "message hive_schema {\n  optional group mapCol (MAP) {\n    repeated group map (MAP_KEY_VALUE) {\n      required binary key;\n      optional binary value;\n    }\n  }\n}\n");
    }

    @Test
    public void testMapOriginalType() throws Exception {
        String hiveColumnTypes = "map<string,string>";
        String hiveColumnNames = "mapCol";
        List<String> columnNames = this.createHiveColumnsFrom("mapCol");
        List<TypeInfo> columnTypes = this.createHiveTypeInfoFrom("map<string,string>");
        MessageType messageTypeFound = HiveSchemaConverter.convert(columnNames, columnTypes);
        Assert.assertEquals((long)1L, (long)messageTypeFound.getFieldCount());
        Type topLevel = (Type)messageTypeFound.getFields().get(0);
        Assert.assertEquals((Object)"mapCol", (Object)topLevel.getName());
        Assert.assertEquals((Object)OriginalType.MAP, (Object)topLevel.getOriginalType());
        Assert.assertEquals((Object)Type.Repetition.OPTIONAL, (Object)topLevel.getRepetition());
        Assert.assertEquals((long)1L, (long)topLevel.asGroupType().getFieldCount());
        Type secondLevel = (Type)topLevel.asGroupType().getFields().get(0);
        Assert.assertEquals((Object)"map", (Object)secondLevel.getName());
        Assert.assertEquals((Object)OriginalType.MAP_KEY_VALUE, (Object)secondLevel.getOriginalType());
        Assert.assertEquals((Object)Type.Repetition.REPEATED, (Object)secondLevel.getRepetition());
    }
}

