/*
 * Decompiled with CFR 0.152.
 */
package parquet.hive;

import java.lang.reflect.Method;
import parquet.Log;
import parquet.hive.HiveBinding;
import parquet.hive.internal.Hive010Binding;
import parquet.hive.internal.Hive012Binding;

public class HiveBindingFactory {
    private static final Log LOG = Log.getLog(HiveBindingFactory.class);
    private static final String HIVE_VERSION_CLASS_NAME = "org.apache.hive.common.util.HiveVersionInfo";
    private static final String HIVE_VERSION_METHOD_NAME = "getVersion";
    private static final String HIVE_UTILITIES_CLASS_NAME = "org.apache.hadoop.hive.ql.exec.Utilities";
    private static final String HIVE_012_INDICATOR_UTILITIES_GETMAPWORK = "getMapWork";
    private static final String HIVE_VERSION_NULL = "<null>";
    private static final Class<? extends HiveBinding> LATEST_BINDING = Hive012Binding.class;
    static final String HIVE_VERSION_UNKNOWN = "Unknown";
    static final String HIVE_VERSION_010 = "0.10";
    static final String HIVE_VERSION_011 = "0.11";
    static final String HIVE_VERSION_012 = "0.12";
    static final String HIVE_VERSION_013 = "0.13";

    public HiveBinding create() {
        Class<? extends HiveBinding> bindingClazz = this.create(HiveBindingFactory.class.getClassLoader());
        try {
            return bindingClazz.newInstance();
        }
        catch (Exception e) {
            throw new HiveBindingInstantiationError("Unexpected error creating instance of " + bindingClazz.getCanonicalName(), e);
        }
    }

    Class<? extends HiveBinding> create(ClassLoader classLoader) {
        Class<?> hiveVersionInfo;
        try {
            hiveVersionInfo = Class.forName(HIVE_VERSION_CLASS_NAME, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            LOG.debug("Class org.apache.hive.common.util.HiveVersionInfo, not found, returning " + Hive010Binding.class.getSimpleName());
            return Hive010Binding.class;
        }
        return this.createInternal(hiveVersionInfo);
    }

    Class<? extends HiveBinding> createInternal(Class hiveVersionInfo) {
        String hiveVersion;
        try {
            Method getVersionMethod = hiveVersionInfo.getMethod(HIVE_VERSION_METHOD_NAME, null);
            String rawVersion = (String)getVersionMethod.invoke(null, (Object[])null);
            LOG.debug("Raw Version from " + hiveVersionInfo.getSimpleName() + " is '" + rawVersion + "'");
            hiveVersion = HiveBindingFactory.trimVersion(rawVersion);
        }
        catch (Exception e) {
            throw new UnexpectedHiveVersionProviderError("Unexpected error whilst determining Hive version", e);
        }
        if (hiveVersion.equalsIgnoreCase(HIVE_VERSION_UNKNOWN)) {
            LOG.debug("Unknown hive version, attempting to guess");
            return this.createBindingForUnknownVersion();
        }
        if (hiveVersion.startsWith(HIVE_VERSION_010)) {
            LOG.debug("Hive version " + hiveVersion + ", returning " + Hive010Binding.class.getSimpleName());
            return Hive010Binding.class;
        }
        if (hiveVersion.startsWith(HIVE_VERSION_011)) {
            LOG.debug("Hive version " + hiveVersion + ", returning " + Hive010Binding.class.getSimpleName() + " as it's expected the 0.10 " + "binding will work with 0.11");
            return Hive010Binding.class;
        }
        if (hiveVersion.startsWith(HIVE_VERSION_013)) {
            throw new HiveBindingInstantiationError("Hive 0.13 contains native Parquet support and the parquet-hive jars from the parquet project should not be included in Hive's classpath.");
        }
        LOG.debug("Hive version " + hiveVersion + ", returning " + Hive012Binding.class.getSimpleName());
        return Hive012Binding.class;
    }

    private Class<? extends HiveBinding> createBindingForUnknownVersion() {
        try {
            Class<?> utilitiesClass = Class.forName(HIVE_UTILITIES_CLASS_NAME);
            for (Method method : utilitiesClass.getDeclaredMethods()) {
                if (!HIVE_012_INDICATOR_UTILITIES_GETMAPWORK.equals(method.getName())) continue;
                LOG.debug("Found org.apache.hadoop.hive.ql.exec.Utilities.getMapWork returning 0.12 binding");
                return Hive012Binding.class;
            }
            return Hive010Binding.class;
        }
        catch (ClassNotFoundException e) {
            LOG.debug("Could not find org.apache.hadoop.hive.ql.exec.Utilities, returning the latest binding since this class existed in 0.10, 0.11, and 0.12");
            return LATEST_BINDING;
        }
    }

    private static String trimVersion(String s) {
        if (s == null) {
            return HIVE_VERSION_NULL;
        }
        return s.trim();
    }

    static class UnexpectedHiveVersionProviderError
    extends Error {
        private static final long serialVersionUID = -7344858060142118L;

        public UnexpectedHiveVersionProviderError(String msg, Exception e) {
            super(msg, e);
        }
    }

    static class HiveBindingInstantiationError
    extends Error {
        private static final long serialVersionUID = -9348060142128L;

        public HiveBindingInstantiationError(String msg) {
            super(msg);
        }

        public HiveBindingInstantiationError(String msg, Exception e) {
            super(msg, e);
        }
    }
}

