/*
 * Decompiled with CFR 0.152.
 */
package parquet.column.values.bitpacking;

import java.io.IOException;
import java.nio.ByteBuffer;
import parquet.Log;
import parquet.bytes.ByteBufferInputStream;
import parquet.bytes.BytesUtils;
import parquet.column.values.ValuesReader;
import parquet.column.values.bitpacking.BitPacking;
import parquet.io.ParquetDecodingException;

public class BitPackingValuesReader
extends ValuesReader {
    private static final Log LOG = Log.getLog(BitPackingValuesReader.class);
    private ByteBufferInputStream in;
    private BitPacking.BitPackingReader bitPackingReader;
    private final int bitsPerValue;
    private int nextOffset;

    public BitPackingValuesReader(int bound) {
        this.bitsPerValue = BytesUtils.getWidthFromMaxInt(bound);
    }

    @Override
    public int readInteger() {
        try {
            return this.bitPackingReader.read();
        }
        catch (IOException e) {
            throw new ParquetDecodingException(e);
        }
    }

    @Override
    public void initFromPage(int valueCount, ByteBuffer in, int offset) throws IOException {
        int effectiveBitLength = valueCount * this.bitsPerValue;
        int length = BytesUtils.paddedByteCountFromBits(effectiveBitLength);
        if (Log.DEBUG) {
            LOG.debug("reading " + length + " bytes for " + valueCount + " values of size " + this.bitsPerValue + " bits.");
        }
        this.in = new ByteBufferInputStream(in.duplicate(), offset, length);
        this.bitPackingReader = BitPacking.createBitPackingReader(this.bitsPerValue, this.in, valueCount);
        this.nextOffset = offset + length;
    }

    @Override
    public void initFromPage(int valueCount, byte[] page, int offset) throws IOException {
        this.initFromPage(valueCount, ByteBuffer.wrap(page), offset);
    }

    @Override
    public int getNextOffset() {
        return this.nextOffset;
    }

    @Override
    public void skip() {
        this.readInteger();
    }
}

