/*
 * Decompiled with CFR 0.152.
 */
package parquet.hive;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import parquet.hive.HiveBindingFactory;
import parquet.hive.internal.Hive010Binding;
import parquet.hive.internal.Hive012Binding;

public class TestHiveBindingFactory {
    private HiveBindingFactory hiveBindingFactory;

    @Before
    public void setup() {
        this.hiveBindingFactory = new HiveBindingFactory();
    }

    @Test
    public void testMissingHiveVersionInfoClass() {
        Assert.assertEquals(Hive010Binding.class, (Object)this.hiveBindingFactory.create((ClassLoader)new NoopClassLoader()));
    }

    @Test(expected=HiveBindingFactory.UnexpectedHiveVersionProviderError.class)
    public void testNoHiveVersion() {
        this.hiveBindingFactory.createInternal(NoHiveVersion.class);
    }

    @Test
    public void testBlankHiveVersion() {
        this.hiveBindingFactory.createInternal(BlankHiveVersion.class);
        Assert.assertEquals(Hive012Binding.class, (Object)this.hiveBindingFactory.createInternal(BlankHiveVersion.class));
    }

    @Test
    public void testUnknownHiveVersion() {
        this.hiveBindingFactory.createInternal(BlankHiveVersion.class);
        Assert.assertEquals(Hive012Binding.class, (Object)this.hiveBindingFactory.createInternal(BlankHiveVersion.class));
    }

    @Test
    public void testNullHiveVersion() {
        this.hiveBindingFactory.createInternal(NullHiveVersion.class);
        Assert.assertEquals(Hive012Binding.class, (Object)this.hiveBindingFactory.createInternal(NullHiveVersion.class));
    }

    @Test
    public void testHive010() {
        Assert.assertEquals(Hive010Binding.class, (Object)this.hiveBindingFactory.createInternal(Hive010Version.class));
    }

    @Test
    public void testHive010WithSpaces() {
        Assert.assertEquals(Hive010Binding.class, (Object)this.hiveBindingFactory.createInternal(Hive010VersionWithSpaces.class));
    }

    @Test
    public void testHive011() {
        Assert.assertEquals(Hive010Binding.class, (Object)this.hiveBindingFactory.createInternal(Hive011Version.class));
    }

    @Test
    public void testHive012() {
        Assert.assertEquals(Hive012Binding.class, (Object)this.hiveBindingFactory.createInternal(Hive012Version.class));
    }

    @Test(expected=HiveBindingFactory.HiveBindingInstantiationError.class)
    public void testHive013() {
        this.hiveBindingFactory.createInternal(Hive013Version.class);
    }

    static class Hive013Version {
        Hive013Version() {
        }

        public static String getVersion() {
            return "0.13";
        }
    }

    static class Hive012Version {
        Hive012Version() {
        }

        public static String getVersion() {
            return "0.12";
        }
    }

    static class Hive011Version {
        Hive011Version() {
        }

        public static String getVersion() {
            return "0.11";
        }
    }

    static class Hive010VersionWithSpaces {
        Hive010VersionWithSpaces() {
        }

        public static String getVersion() {
            return " 0.10 ";
        }
    }

    static class Hive010Version {
        Hive010Version() {
        }

        public static String getVersion() {
            return "0.10";
        }
    }

    static class NullHiveVersion {
        NullHiveVersion() {
        }

        public static String getVersion() {
            return null;
        }
    }

    static class UnknownHiveVersion {
        UnknownHiveVersion() {
        }

        public static String getVersion() {
            return "Unknown";
        }
    }

    static class BlankHiveVersion {
        BlankHiveVersion() {
        }

        public static String getVersion() {
            return "";
        }
    }

    static class NoHiveVersion {
        NoHiveVersion() {
        }
    }

    static class NoopClassLoader
    extends ClassLoader {
        NoopClassLoader() {
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            throw new ClassNotFoundException(name);
        }
    }
}

