/*
 * Decompiled with CFR 0.152.
 */
package parquet.hadoop.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.junit.Assert;
import org.junit.Test;
import parquet.hadoop.util.SerializationUtil;

public class TestSerializationUtil {
    @Test
    public void testReadWriteObjectToConfAsBase64() throws Exception {
        HashMap<Integer, String> anObject = new HashMap<Integer, String>();
        anObject.put(7, "seven");
        anObject.put(8, "eight");
        Configuration conf = new Configuration();
        SerializationUtil.writeObjectToConfAsBase64((String)"anobject", anObject, (Configuration)conf);
        Map copy = (Map)SerializationUtil.readObjectFromConfAsBase64((String)"anobject", (Configuration)conf);
        Assert.assertEquals(anObject, (Object)copy);
        try {
            Set bad = (Set)SerializationUtil.readObjectFromConfAsBase64((String)"anobject", (Configuration)conf);
            Assert.fail((String)"This should throw a ClassCastException");
        }
        catch (ClassCastException e) {
            // empty catch block
        }
        conf = new Configuration();
        Object nullObj = null;
        SerializationUtil.writeObjectToConfAsBase64((String)"anobject", null, (Configuration)conf);
        Object copyObj = SerializationUtil.readObjectFromConfAsBase64((String)"anobject", (Configuration)conf);
        Assert.assertEquals(nullObj, (Object)copyObj);
    }

    @Test
    public void readObjectFromConfAsBase64UnsetKey() throws Exception {
        Assert.assertNull((Object)SerializationUtil.readObjectFromConfAsBase64((String)"non-existant-key", (Configuration)new Configuration()));
    }
}

