/*
 * Decompiled with CFR 0.152.
 */
package parquet.hadoop;

import java.util.Arrays;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.junit.Test;
import parquet.column.Encoding;
import parquet.column.ParquetProperties;
import parquet.example.data.Group;
import parquet.example.data.simple.SimpleGroupFactory;
import parquet.format.converter.ParquetMetadataConverter;
import parquet.hadoop.ParquetFileReader;
import parquet.hadoop.ParquetReader;
import parquet.hadoop.ParquetWriter;
import parquet.hadoop.TestUtils;
import parquet.hadoop.api.ReadSupport;
import parquet.hadoop.api.WriteSupport;
import parquet.hadoop.example.GroupReadSupport;
import parquet.hadoop.example.GroupWriteSupport;
import parquet.hadoop.metadata.BlockMetaData;
import parquet.hadoop.metadata.ColumnChunkMetaData;
import parquet.hadoop.metadata.CompressionCodecName;
import parquet.hadoop.metadata.ParquetMetadata;
import parquet.io.api.Binary;
import parquet.schema.MessageType;
import parquet.schema.MessageTypeParser;

public class TestParquetWriter {
    @Test
    public void test() throws Exception {
        Configuration conf = new Configuration();
        Path root = new Path("target/tests/TestParquetWriter/");
        TestUtils.enforceEmptyDir(conf, root);
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test { required binary binary_field; required int32 int32_field; required int64 int64_field; required boolean boolean_field; required float float_field; required double double_field; required fixed_len_byte_array(3) flba_field; required int96 int96_field; } ");
        GroupWriteSupport.setSchema((MessageType)schema, (Configuration)conf);
        SimpleGroupFactory f = new SimpleGroupFactory(schema);
        HashMap<String, Encoding> expected = new HashMap<String, Encoding>();
        expected.put("10-" + ParquetProperties.WriterVersion.PARQUET_1_0, Encoding.PLAIN_DICTIONARY);
        expected.put("1000-" + ParquetProperties.WriterVersion.PARQUET_1_0, Encoding.PLAIN);
        expected.put("10-" + ParquetProperties.WriterVersion.PARQUET_2_0, Encoding.RLE_DICTIONARY);
        expected.put("1000-" + ParquetProperties.WriterVersion.PARQUET_2_0, Encoding.DELTA_BYTE_ARRAY);
        for (int modulo : Arrays.asList(10, 1000)) {
            for (ParquetProperties.WriterVersion version : ParquetProperties.WriterVersion.values()) {
                Path file = new Path(root, version.name() + "_" + modulo);
                ParquetWriter writer = new ParquetWriter(file, (WriteSupport)new GroupWriteSupport(), CompressionCodecName.UNCOMPRESSED, 1024, 1024, 512, true, false, version, conf);
                for (int i = 0; i < 1000; ++i) {
                    writer.write((Object)f.newGroup().append("binary_field", "test" + i % modulo).append("int32_field", 32).append("int64_field", 64L).append("boolean_field", true).append("float_field", 1.0f).append("double_field", 2.0).append("flba_field", "foo").append("int96_field", Binary.fromByteArray((byte[])new byte[12])));
                }
                writer.close();
                ParquetReader reader = ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)file).withConf(conf).build();
                for (int i = 0; i < 1000; ++i) {
                    Group group = (Group)reader.read();
                    Assert.assertEquals((Object)("test" + i % modulo), (Object)group.getBinary("binary_field", 0).toStringUsingUTF8());
                    Assert.assertEquals((long)32L, (long)group.getInteger("int32_field", 0));
                    Assert.assertEquals((long)64L, (long)group.getLong("int64_field", 0));
                    Assert.assertEquals((Object)true, (Object)group.getBoolean("boolean_field", 0));
                    Assert.assertEquals((double)1.0, (double)group.getFloat("float_field", 0), (double)0.001);
                    Assert.assertEquals((double)2.0, (double)group.getDouble("double_field", 0), (double)0.001);
                    Assert.assertEquals((Object)"foo", (Object)group.getBinary("flba_field", 0).toStringUsingUTF8());
                    Assert.assertEquals((Object)Binary.fromByteArray((byte[])new byte[12]), (Object)group.getInt96("int96_field", 0));
                }
                reader.close();
                ParquetMetadata footer = ParquetFileReader.readFooter((Configuration)conf, (Path)file, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
                for (BlockMetaData blockMetaData : footer.getBlocks()) {
                    for (ColumnChunkMetaData column : blockMetaData.getColumns()) {
                        if (!column.getPath().toDotString().equals("binary_field")) continue;
                        String key = modulo + "-" + version;
                        Encoding expectedEncoding = (Encoding)expected.get(key);
                        Assert.assertTrue((String)(key + ":" + column.getEncodings() + " should contain " + expectedEncoding), (boolean)column.getEncodings().contains(expectedEncoding));
                    }
                }
            }
        }
    }
}

