/*
 * Decompiled with CFR 0.152.
 */
package parquet.hadoop;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import parquet.hadoop.InternalParquetRecordWriter;
import parquet.hadoop.ParquetOutputFormat;
import parquet.hadoop.api.WriteSupport;
import parquet.hadoop.example.GroupWriteSupport;
import parquet.hadoop.metadata.CompressionCodecName;
import parquet.schema.MessageType;
import parquet.schema.MessageTypeParser;

public class TestMemoryManager {
    Configuration conf = new Configuration();
    String writeSchema = "message example {\nrequired int32 line;\nrequired binary content;\n}";
    long expectPoolSize;
    int rowGroupSize;
    ParquetOutputFormat parquetOutputFormat;
    CompressionCodecName codec;

    @Before
    public void setUp() {
        GroupWriteSupport.setSchema((MessageType)MessageTypeParser.parseMessageType((String)this.writeSchema), (Configuration)this.conf);
        this.expectPoolSize = Math.round((float)ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax() * 0.95f);
        this.rowGroupSize = (int)Math.floor(this.expectPoolSize / 2L);
        this.conf.setInt("parquet.block.size", this.rowGroupSize);
        this.codec = CompressionCodecName.UNCOMPRESSED;
    }

    @After
    public void tearDown() throws Exception {
        FileUtils.deleteDirectory((File)new File("target/test"));
    }

    @Test
    public void testMemoryManager() throws Exception {
        RecordWriter writer1 = this.createWriter(1);
        this.verifyRowGroupSize(this.rowGroupSize);
        RecordWriter writer2 = this.createWriter(2);
        this.verifyRowGroupSize(this.rowGroupSize);
        RecordWriter writer3 = this.createWriter(3);
        this.verifyRowGroupSize((int)Math.floor(this.expectPoolSize / 3L));
        writer1.close(null);
        this.verifyRowGroupSize(this.rowGroupSize);
        writer2.close(null);
        this.verifyRowGroupSize(this.rowGroupSize);
        writer3.close(null);
        TestMemoryManager testMemoryManager = this;
        Assert.assertEquals((String)"memory pool size is incorrect.", (long)this.expectPoolSize, (long)testMemoryManager.parquetOutputFormat.getMemoryManager().getTotalMemoryPool());
    }

    private RecordWriter createWriter(int index) throws Exception {
        Path file = new Path("target/test/", "parquet" + index);
        this.parquetOutputFormat = new ParquetOutputFormat((WriteSupport)new GroupWriteSupport());
        return this.parquetOutputFormat.getRecordWriter(this.conf, file, this.codec);
    }

    private void verifyRowGroupSize(int expectRowGroupSize) {
        TestMemoryManager testMemoryManager = this;
        Set writers = testMemoryManager.parquetOutputFormat.getMemoryManager().getWriterList().keySet();
        for (InternalParquetRecordWriter writer : writers) {
            Assert.assertEquals((String)"wrong rowGroupSize", (double)expectRowGroupSize, (double)writer.getRowGroupSizeThreshold(), (double)1.0);
        }
    }
}

