/*
 * Decompiled with CFR 0.152.
 */
package parquet.format.converter;

import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;
import org.junit.Assert;
import org.junit.Test;
import parquet.example.Paper;
import parquet.format.ColumnChunk;
import parquet.format.ColumnMetaData;
import parquet.format.CompressionCodec;
import parquet.format.ConvertedType;
import parquet.format.Encoding;
import parquet.format.FieldRepetitionType;
import parquet.format.FileMetaData;
import parquet.format.PageHeader;
import parquet.format.PageType;
import parquet.format.RowGroup;
import parquet.format.SchemaElement;
import parquet.format.Type;
import parquet.format.Util;
import parquet.format.converter.ParquetMetadataConverter;
import parquet.schema.MessageType;
import parquet.schema.OriginalType;
import parquet.schema.PrimitiveType;
import parquet.schema.Type;
import parquet.schema.Types;

public class TestParquetMetadataConverter {
    @Test
    public void testPageHeader() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PageType type = PageType.DATA_PAGE;
        int compSize = 10;
        int uncSize = 20;
        PageHeader pageHeader = new PageHeader(type, uncSize, compSize);
        Util.writePageHeader((PageHeader)pageHeader, (OutputStream)out);
        PageHeader readPageHeader = Util.readPageHeader((InputStream)new ByteArrayInputStream(out.toByteArray()));
        Assert.assertEquals((Object)pageHeader, (Object)readPageHeader);
    }

    @Test
    public void testSchemaConverter() {
        ParquetMetadataConverter parquetMetadataConverter = new ParquetMetadataConverter();
        List parquetSchema = parquetMetadataConverter.toParquetSchema(Paper.schema);
        MessageType schema = parquetMetadataConverter.fromParquetSchema(parquetSchema);
        Assert.assertEquals((Object)Paper.schema, (Object)schema);
    }

    @Test
    public void testSchemaConverterDecimal() {
        ParquetMetadataConverter converter = new ParquetMetadataConverter();
        List schemaElements = converter.toParquetSchema((MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.DECIMAL)).precision(9).scale(2).named("aBinaryDecimal")).optional(PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(4).as(OriginalType.DECIMAL)).precision(9).scale(2).named("aFixedDecimal")).named("Message"));
        ArrayList expected = Lists.newArrayList((Object[])new SchemaElement[]{new SchemaElement("Message").setNum_children(2), new SchemaElement("aBinaryDecimal").setRepetition_type(FieldRepetitionType.REQUIRED).setType(Type.BYTE_ARRAY).setConverted_type(ConvertedType.DECIMAL).setPrecision(9).setScale(2), new SchemaElement("aFixedDecimal").setRepetition_type(FieldRepetitionType.OPTIONAL).setType(Type.FIXED_LEN_BYTE_ARRAY).setType_length(4).setConverted_type(ConvertedType.DECIMAL).setPrecision(9).setScale(2)});
        Assert.assertEquals((Object)expected, (Object)schemaElements);
    }

    @Test
    public void testEnumEquivalence() {
        ParquetMetadataConverter c = new ParquetMetadataConverter();
        for (parquet.column.Encoding encoding : parquet.column.Encoding.values()) {
            Assert.assertEquals((Object)encoding, (Object)c.getEncoding(c.getEncoding(encoding)));
        }
        for (parquet.column.Encoding encoding : Encoding.values()) {
            Assert.assertEquals((Object)encoding, (Object)c.getEncoding(c.getEncoding((Encoding)encoding)));
        }
        for (parquet.column.Encoding encoding : Type.Repetition.values()) {
            Assert.assertEquals((Object)encoding, (Object)c.fromParquetRepetition(c.toParquetRepetition((Type.Repetition)encoding)));
        }
        for (parquet.column.Encoding encoding : FieldRepetitionType.values()) {
            Assert.assertEquals((Object)encoding, (Object)c.toParquetRepetition(c.fromParquetRepetition((FieldRepetitionType)encoding)));
        }
        for (parquet.column.Encoding encoding : PrimitiveType.PrimitiveTypeName.values()) {
            Assert.assertEquals((Object)encoding, (Object)c.getPrimitive(c.getType((PrimitiveType.PrimitiveTypeName)encoding)));
        }
        for (parquet.column.Encoding encoding : Type.values()) {
            Assert.assertEquals((Object)encoding, (Object)c.getType(c.getPrimitive((Type)encoding)));
        }
        for (parquet.column.Encoding encoding : OriginalType.values()) {
            Assert.assertEquals((Object)encoding, (Object)c.getOriginalType(c.getConvertedType((OriginalType)encoding)));
        }
        for (parquet.column.Encoding encoding : ConvertedType.values()) {
            Assert.assertEquals((Object)encoding, (Object)c.getConvertedType(c.getOriginalType((ConvertedType)encoding)));
        }
    }

    private FileMetaData metadata(long ... sizes) {
        List schema = Collections.emptyList();
        ArrayList<RowGroup> rowGroups = new ArrayList<RowGroup>();
        long offset = 0L;
        for (long size : sizes) {
            ColumnChunk columnChunk = new ColumnChunk(offset);
            columnChunk.setMeta_data(new ColumnMetaData(Type.INT32, Collections.emptyList(), Collections.emptyList(), CompressionCodec.UNCOMPRESSED, 10L, size * 2L, size, offset));
            rowGroups.add(new RowGroup(Arrays.asList(columnChunk), size, 1L));
            offset += size;
        }
        return new FileMetaData(1, schema, (long)sizes.length, rowGroups);
    }

    private FileMetaData filter(FileMetaData md, long start, long end) {
        return ParquetMetadataConverter.filterFileMetaData((FileMetaData)new FileMetaData(md), (ParquetMetadataConverter.RangeMetadataFilter)new ParquetMetadataConverter.RangeMetadataFilter(start, end));
    }

    private void verifyMD(FileMetaData md, long ... offsets) {
        Assert.assertEquals((long)offsets.length, (long)md.row_groups.size());
        for (int i = 0; i < offsets.length; ++i) {
            long offset = offsets[i];
            RowGroup rowGroup = (RowGroup)md.getRow_groups().get(i);
            Assert.assertEquals((long)offset, (long)ParquetMetadataConverter.getOffset((RowGroup)rowGroup));
        }
    }

    private void verifyAllFilters(FileMetaData md, long splitWidth) {
        TreeSet<Long> offsetsFound = new TreeSet<Long>();
        for (long start = 0L; start < this.fileSize(md); start += splitWidth) {
            FileMetaData filtered = this.filter(md, start, start + splitWidth);
            for (RowGroup rg : filtered.getRow_groups()) {
                long o = ParquetMetadataConverter.getOffset((RowGroup)rg);
                if (offsetsFound.contains(o)) {
                    Assert.fail((String)("found the offset twice: " + o));
                    continue;
                }
                offsetsFound.add(o);
            }
        }
        if (offsetsFound.size() != md.row_groups.size()) {
            Assert.fail((String)("missing row groups, found: " + offsetsFound + "\nexpected " + md.getRow_groups()));
        }
    }

    private long fileSize(FileMetaData md) {
        long size = 0L;
        for (RowGroup rg : md.getRow_groups()) {
            size += rg.total_byte_size;
        }
        return size;
    }

    @Test
    public void testFilterMetaData() {
        this.verifyMD(this.filter(this.metadata(50L, 50L, 50L), 0L, 50L), 0L);
        this.verifyMD(this.filter(this.metadata(50L, 50L, 50L), 50L, 100L), 50L);
        this.verifyMD(this.filter(this.metadata(50L, 50L, 50L), 100L, 150L), 100L);
        this.verifyMD(this.filter(this.metadata(50L, 50L, 50L), 25L, 75L), 0L);
        this.verifyMD(this.filter(this.metadata(50L, 50L, 50L), 26L, 75L), new long[0]);
        this.verifyMD(this.filter(this.metadata(50L, 50L, 50L), 26L, 76L), 50L);
        this.verifyAllFilters(this.metadata(50L, 50L, 50L), 10L);
        this.verifyAllFilters(this.metadata(50L, 50L, 50L), 51L);
        this.verifyAllFilters(this.metadata(50L, 50L, 50L), 25L);
        this.verifyAllFilters(this.metadata(50L, 50L, 50L), 24L);
        this.verifyAllFilters(this.metadata(50L, 50L, 50L), 26L);
        this.verifyAllFilters(this.metadata(50L, 50L, 50L), 110L);
        this.verifyAllFilters(this.metadata(10L, 50L, 500L), 110L);
        this.verifyAllFilters(this.metadata(10L, 50L, 500L), 10L);
        this.verifyAllFilters(this.metadata(10L, 50L, 500L), 600L);
        this.verifyAllFilters(this.metadata(11L, 9L, 10L), 10L);
        this.verifyAllFilters(this.metadata(11L, 9L, 10L), 9L);
        this.verifyAllFilters(this.metadata(11L, 9L, 10L), 8L);
    }

    @Test
    public void randomTestFilterMetaData() {
        Random random = new Random(System.currentTimeMillis());
        for (int j = 0; j < 100; ++j) {
            long[] rgs = new long[random.nextInt(50)];
            for (int i = 0; i < rgs.length; ++i) {
                rgs[i] = random.nextInt(10000) + 1;
            }
            int splitSize = random.nextInt(10000);
            try {
                this.verifyAllFilters(this.metadata(rgs), splitSize);
                continue;
            }
            catch (AssertionError e) {
                throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)("fail verifyAllFilters(metadata(" + Arrays.toString(rgs) + "), " + splitSize + ")")))).initCause((Throwable)((Object)e)));
            }
        }
    }
}

