/*
 * Decompiled with CFR 0.152.
 */
package parquet.filter2.statisticslevel;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import parquet.column.Encoding;
import parquet.column.statistics.DoubleStatistics;
import parquet.column.statistics.IntStatistics;
import parquet.column.statistics.Statistics;
import parquet.common.schema.ColumnPath;
import parquet.filter2.predicate.FilterApi;
import parquet.filter2.predicate.FilterPredicate;
import parquet.filter2.predicate.LogicalInverseRewriter;
import parquet.filter2.predicate.Operators;
import parquet.filter2.predicate.UserDefinedPredicate;
import parquet.filter2.statisticslevel.StatisticsFilter;
import parquet.hadoop.metadata.ColumnChunkMetaData;
import parquet.hadoop.metadata.CompressionCodecName;
import parquet.schema.PrimitiveType;

public class TestStatisticsFilter {
    private static final Operators.IntColumn intColumn = FilterApi.intColumn((String)"int.column");
    private static final Operators.DoubleColumn doubleColumn = FilterApi.doubleColumn((String)"double.column");
    private static final IntStatistics intStats = new IntStatistics();
    private static final IntStatistics nullIntStats = new IntStatistics();
    private static final DoubleStatistics doubleStats = new DoubleStatistics();
    private static final List<ColumnChunkMetaData> columnMetas;
    private static final List<ColumnChunkMetaData> nullColumnMetas;

    private static ColumnChunkMetaData getIntColumnMeta(IntStatistics stats, long valueCount) {
        return ColumnChunkMetaData.get((ColumnPath)ColumnPath.get((String[])new String[]{"int", "column"}), (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32, (CompressionCodecName)CompressionCodecName.GZIP, new HashSet<Encoding>(Arrays.asList(Encoding.PLAIN)), (Statistics)stats, (long)0L, (long)0L, (long)valueCount, (long)0L, (long)0L);
    }

    private static ColumnChunkMetaData getDoubleColumnMeta(DoubleStatistics stats, long valueCount) {
        return ColumnChunkMetaData.get((ColumnPath)ColumnPath.get((String[])new String[]{"double", "column"}), (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE, (CompressionCodecName)CompressionCodecName.GZIP, new HashSet<Encoding>(Arrays.asList(Encoding.PLAIN)), (Statistics)stats, (long)0L, (long)0L, (long)valueCount, (long)0L, (long)0L);
    }

    @Test
    public void testEqNonNull() {
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(9)), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(10)), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(100)), columnMetas));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(101)), columnMetas));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(0)), nullColumnMetas));
    }

    @Test
    public void testEqNull() {
        IntStatistics statsNoNulls = new IntStatistics();
        statsNoNulls.setMinMax(10, 100);
        statsNoNulls.setNumNulls(0L);
        IntStatistics statsSomeNulls = new IntStatistics();
        statsSomeNulls.setMinMax(10, 100);
        statsSomeNulls.setNumNulls(3L);
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.eq((Operators.Column)intColumn, null), Arrays.asList(TestStatisticsFilter.getIntColumnMeta(statsNoNulls, 177L), TestStatisticsFilter.getDoubleColumnMeta(doubleStats, 177L))));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.eq((Operators.Column)intColumn, null), Arrays.asList(TestStatisticsFilter.getIntColumnMeta(statsSomeNulls, 177L), TestStatisticsFilter.getDoubleColumnMeta(doubleStats, 177L))));
    }

    @Test
    public void testNotEqNonNull() {
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.notEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(9)), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.notEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(10)), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.notEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(100)), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.notEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(101)), columnMetas));
        IntStatistics allSevens = new IntStatistics();
        allSevens.setMinMax(7, 7);
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.notEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(7)), Arrays.asList(TestStatisticsFilter.getIntColumnMeta(allSevens, 177L), TestStatisticsFilter.getDoubleColumnMeta(doubleStats, 177L))));
    }

    @Test
    public void testNotEqNull() {
        IntStatistics statsNoNulls = new IntStatistics();
        statsNoNulls.setMinMax(10, 100);
        statsNoNulls.setNumNulls(0L);
        IntStatistics statsSomeNulls = new IntStatistics();
        statsSomeNulls.setMinMax(10, 100);
        statsSomeNulls.setNumNulls(3L);
        IntStatistics statsAllNulls = new IntStatistics();
        statsAllNulls.setMinMax(0, 0);
        statsAllNulls.setNumNulls(177L);
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.notEq((Operators.Column)intColumn, null), Arrays.asList(TestStatisticsFilter.getIntColumnMeta(statsNoNulls, 177L), TestStatisticsFilter.getDoubleColumnMeta(doubleStats, 177L))));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.notEq((Operators.Column)intColumn, null), Arrays.asList(TestStatisticsFilter.getIntColumnMeta(statsSomeNulls, 177L), TestStatisticsFilter.getDoubleColumnMeta(doubleStats, 177L))));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.notEq((Operators.Column)intColumn, null), Arrays.asList(TestStatisticsFilter.getIntColumnMeta(statsAllNulls, 177L), TestStatisticsFilter.getDoubleColumnMeta(doubleStats, 177L))));
    }

    @Test
    public void testLt() {
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.lt((Operators.Column)intColumn, (Comparable)Integer.valueOf(9)), columnMetas));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.lt((Operators.Column)intColumn, (Comparable)Integer.valueOf(10)), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.lt((Operators.Column)intColumn, (Comparable)Integer.valueOf(100)), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.lt((Operators.Column)intColumn, (Comparable)Integer.valueOf(101)), columnMetas));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.lt((Operators.Column)intColumn, (Comparable)Integer.valueOf(0)), nullColumnMetas));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.lt((Operators.Column)intColumn, (Comparable)Integer.valueOf(7)), nullColumnMetas));
    }

    @Test
    public void testLtEq() {
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.ltEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(9)), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.ltEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(10)), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.ltEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(100)), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.ltEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(101)), columnMetas));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.ltEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(0)), nullColumnMetas));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.ltEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(7)), nullColumnMetas));
    }

    @Test
    public void testGt() {
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.gt((Operators.Column)intColumn, (Comparable)Integer.valueOf(9)), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.gt((Operators.Column)intColumn, (Comparable)Integer.valueOf(10)), columnMetas));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.gt((Operators.Column)intColumn, (Comparable)Integer.valueOf(100)), columnMetas));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.gt((Operators.Column)intColumn, (Comparable)Integer.valueOf(101)), columnMetas));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.gt((Operators.Column)intColumn, (Comparable)Integer.valueOf(0)), nullColumnMetas));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.gt((Operators.Column)intColumn, (Comparable)Integer.valueOf(7)), nullColumnMetas));
    }

    @Test
    public void testGtEq() {
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.gtEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(9)), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.gtEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(10)), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.gtEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(100)), columnMetas));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.gtEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(101)), columnMetas));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.gtEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(0)), nullColumnMetas));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.gtEq((Operators.Column)intColumn, (Comparable)Integer.valueOf(7)), nullColumnMetas));
    }

    @Test
    public void testAnd() {
        Operators.Eq yes = FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(9));
        Operators.Eq no = FilterApi.eq((Operators.Column)doubleColumn, (Comparable)Double.valueOf(50.0));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.and((FilterPredicate)yes, (FilterPredicate)yes), columnMetas));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.and((FilterPredicate)yes, (FilterPredicate)no), columnMetas));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.and((FilterPredicate)no, (FilterPredicate)yes), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.and((FilterPredicate)no, (FilterPredicate)no), columnMetas));
    }

    @Test
    public void testOr() {
        Operators.Eq yes = FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(9));
        Operators.Eq no = FilterApi.eq((Operators.Column)doubleColumn, (Comparable)Double.valueOf(50.0));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.or((FilterPredicate)yes, (FilterPredicate)yes), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.or((FilterPredicate)yes, (FilterPredicate)no), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.or((FilterPredicate)no, (FilterPredicate)yes), columnMetas));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)FilterApi.or((FilterPredicate)no, (FilterPredicate)no), columnMetas));
    }

    @Test
    public void testUdp() {
        Operators.UserDefined pred = FilterApi.userDefined((Operators.Column)intColumn, SevensAndEightsUdp.class);
        FilterPredicate invPred = LogicalInverseRewriter.rewrite((FilterPredicate)FilterApi.not((FilterPredicate)FilterApi.userDefined((Operators.Column)intColumn, SevensAndEightsUdp.class)));
        IntStatistics seven = new IntStatistics();
        seven.setMinMax(7, 7);
        IntStatistics eight = new IntStatistics();
        eight.setMinMax(8, 8);
        IntStatistics neither = new IntStatistics();
        neither.setMinMax(1, 2);
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)pred, Arrays.asList(TestStatisticsFilter.getIntColumnMeta(seven, 177L), TestStatisticsFilter.getDoubleColumnMeta(doubleStats, 177L))));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)pred, Arrays.asList(TestStatisticsFilter.getIntColumnMeta(eight, 177L), TestStatisticsFilter.getDoubleColumnMeta(doubleStats, 177L))));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)pred, Arrays.asList(TestStatisticsFilter.getIntColumnMeta(neither, 177L), TestStatisticsFilter.getDoubleColumnMeta(doubleStats, 177L))));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)invPred, Arrays.asList(TestStatisticsFilter.getIntColumnMeta(seven, 177L), TestStatisticsFilter.getDoubleColumnMeta(doubleStats, 177L))));
        Assert.assertTrue((boolean)StatisticsFilter.canDrop((FilterPredicate)invPred, Arrays.asList(TestStatisticsFilter.getIntColumnMeta(eight, 177L), TestStatisticsFilter.getDoubleColumnMeta(doubleStats, 177L))));
        Assert.assertFalse((boolean)StatisticsFilter.canDrop((FilterPredicate)invPred, Arrays.asList(TestStatisticsFilter.getIntColumnMeta(neither, 177L), TestStatisticsFilter.getDoubleColumnMeta(doubleStats, 177L))));
    }

    @Test
    public void testClearExceptionForNots() {
        List<ColumnChunkMetaData> columnMetas = Arrays.asList(TestStatisticsFilter.getDoubleColumnMeta(new DoubleStatistics(), 0L), TestStatisticsFilter.getIntColumnMeta(new IntStatistics(), 0L));
        FilterPredicate pred = FilterApi.and((FilterPredicate)FilterApi.not((FilterPredicate)FilterApi.eq((Operators.Column)doubleColumn, (Comparable)Double.valueOf(12.0))), (FilterPredicate)FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(17)));
        try {
            StatisticsFilter.canDrop((FilterPredicate)pred, columnMetas);
            Assert.fail((String)"This should throw");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"This predicate contains a not! Did you forget to run this predicate through LogicalInverseRewriter? not(eq(double.column, 12.0))", (Object)e.getMessage());
        }
    }

    @Test
    public void testMissingColumn() {
        List<ColumnChunkMetaData> columnMetas = Arrays.asList(TestStatisticsFilter.getIntColumnMeta(new IntStatistics(), 0L));
        try {
            StatisticsFilter.canDrop((FilterPredicate)FilterApi.and((FilterPredicate)FilterApi.eq((Operators.Column)doubleColumn, (Comparable)Double.valueOf(12.0)), (FilterPredicate)FilterApi.eq((Operators.Column)intColumn, (Comparable)Integer.valueOf(17))), columnMetas);
            Assert.fail((String)"This should throw");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"Column double.column not found in schema!", (Object)e.getMessage());
        }
    }

    static {
        intStats.setMinMax(10, 100);
        doubleStats.setMinMax(10.0, 100.0);
        nullIntStats.setMinMax(0, 0);
        nullIntStats.setNumNulls(177L);
        columnMetas = Arrays.asList(TestStatisticsFilter.getIntColumnMeta(intStats, 177L), TestStatisticsFilter.getDoubleColumnMeta(doubleStats, 177L));
        nullColumnMetas = Arrays.asList(TestStatisticsFilter.getIntColumnMeta(nullIntStats, 177L), TestStatisticsFilter.getDoubleColumnMeta(doubleStats, 177L));
    }

    public static class SevensAndEightsUdp
    extends UserDefinedPredicate<Integer> {
        public boolean keep(Integer value) {
            throw new RuntimeException("this method should not be called");
        }

        public boolean canDrop(parquet.filter2.predicate.Statistics<Integer> statistics) {
            return (Integer)statistics.getMin() == 7 && (Integer)statistics.getMax() == 7;
        }

        public boolean inverseCanDrop(parquet.filter2.predicate.Statistics<Integer> statistics) {
            return (Integer)statistics.getMin() == 8 && (Integer)statistics.getMax() == 8;
        }
    }
}

