/*
 * Decompiled with CFR 0.152.
 */
package parquet.filter2.recordlevel;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import parquet.example.data.Group;
import parquet.filter2.compat.FilterCompat;
import parquet.filter2.predicate.FilterApi;
import parquet.filter2.predicate.FilterPredicate;
import parquet.filter2.predicate.Operators;
import parquet.filter2.predicate.Statistics;
import parquet.filter2.predicate.UserDefinedPredicate;
import parquet.filter2.recordlevel.PhoneBookWriter;
import parquet.io.api.Binary;

public class TestRecordLevelFilters {
    private static File phonebookFile;
    private static List<PhoneBookWriter.User> users;

    public static List<PhoneBookWriter.User> makeUsers() {
        ArrayList<PhoneBookWriter.User> users = new ArrayList<PhoneBookWriter.User>();
        users.add(new PhoneBookWriter.User(17L, null, null, null));
        users.add(new PhoneBookWriter.User(18L, "bob", null, null));
        users.add(new PhoneBookWriter.User(19L, "alice", new ArrayList<PhoneBookWriter.PhoneNumber>(), null));
        users.add(new PhoneBookWriter.User(20L, "thing1", Arrays.asList(new PhoneBookWriter.PhoneNumber(5555555555L, null)), null));
        users.add(new PhoneBookWriter.User(27L, "thing2", Arrays.asList(new PhoneBookWriter.PhoneNumber(1111111111L, "home")), null));
        users.add(new PhoneBookWriter.User(28L, "popular", Arrays.asList(new PhoneBookWriter.PhoneNumber(1111111111L, "home"), new PhoneBookWriter.PhoneNumber(2222222222L, null), new PhoneBookWriter.PhoneNumber(3333333333L, "mobile")), null));
        users.add(new PhoneBookWriter.User(30L, null, Arrays.asList(new PhoneBookWriter.PhoneNumber(1111111111L, "home")), null));
        for (int i = 100; i < 200; ++i) {
            PhoneBookWriter.Location location = null;
            if (i % 3 == 1) {
                location = new PhoneBookWriter.Location(Double.valueOf(i), (double)i * 2.0);
            }
            if (i % 3 == 2) {
                location = new PhoneBookWriter.Location(Double.valueOf(i), null);
            }
            users.add(new PhoneBookWriter.User(i, "p" + i, Arrays.asList(new PhoneBookWriter.PhoneNumber(i, "cell")), location));
        }
        return users;
    }

    @BeforeClass
    public static void setup() throws IOException {
        users = TestRecordLevelFilters.makeUsers();
        phonebookFile = PhoneBookWriter.writeToFile(users);
    }

    private static List<Group> getExpected(UserFilter f) {
        ArrayList<Group> expected = new ArrayList<Group>();
        for (PhoneBookWriter.User u : users) {
            if (!f.keep(u)) continue;
            expected.add((Group)PhoneBookWriter.groupFromUser(u));
        }
        return expected;
    }

    private static void assertFilter(List<Group> found, UserFilter f) {
        List<Group> expected = TestRecordLevelFilters.getExpected(f);
        Assert.assertEquals((long)expected.size(), (long)found.size());
        Iterator<Group> expectedIter = expected.iterator();
        Iterator<Group> foundIter = found.iterator();
        while (expectedIter.hasNext()) {
            Assert.assertEquals((Object)expectedIter.next().toString(), (Object)foundIter.next().toString());
        }
    }

    @Test
    public void testNoFilter() throws Exception {
        List<Group> found = PhoneBookWriter.readFile(phonebookFile, FilterCompat.NOOP);
        TestRecordLevelFilters.assertFilter(found, new UserFilter(){

            @Override
            public boolean keep(PhoneBookWriter.User u) {
                return true;
            }
        });
    }

    @Test
    public void testAllFilter() throws Exception {
        Operators.BinaryColumn name = FilterApi.binaryColumn((String)"name");
        Operators.Eq pred = FilterApi.eq((Operators.Column)name, (Comparable)Binary.fromString((String)"no matches"));
        List<Group> found = PhoneBookWriter.readFile(phonebookFile, FilterCompat.get((FilterPredicate)pred));
        Assert.assertEquals(new ArrayList(), found);
    }

    @Test
    public void testNameNotNull() throws Exception {
        Operators.BinaryColumn name = FilterApi.binaryColumn((String)"name");
        Operators.NotEq pred = FilterApi.notEq((Operators.Column)name, null);
        List<Group> found = PhoneBookWriter.readFile(phonebookFile, FilterCompat.get((FilterPredicate)pred));
        TestRecordLevelFilters.assertFilter(found, new UserFilter(){

            @Override
            public boolean keep(PhoneBookWriter.User u) {
                return u.getName() != null;
            }
        });
    }

    @Test
    public void testNameNotStartWithP() throws Exception {
        Operators.BinaryColumn name = FilterApi.binaryColumn((String)"name");
        FilterPredicate pred = FilterApi.not((FilterPredicate)FilterApi.userDefined((Operators.Column)name, StartWithP.class));
        List<Group> found = PhoneBookWriter.readFile(phonebookFile, FilterCompat.get((FilterPredicate)pred));
        TestRecordLevelFilters.assertFilter(found, new UserFilter(){

            @Override
            public boolean keep(PhoneBookWriter.User u) {
                return u.getName() == null || !u.getName().startsWith("p");
            }
        });
    }

    @Test
    public void testComplex() throws Exception {
        Operators.BinaryColumn name = FilterApi.binaryColumn((String)"name");
        Operators.DoubleColumn lon = FilterApi.doubleColumn((String)"location.lon");
        Operators.DoubleColumn lat = FilterApi.doubleColumn((String)"location.lat");
        FilterPredicate pred = FilterApi.or((FilterPredicate)FilterApi.and((FilterPredicate)FilterApi.gt((Operators.Column)lon, (Comparable)Double.valueOf(150.0)), (FilterPredicate)FilterApi.notEq((Operators.Column)lat, null)), (FilterPredicate)FilterApi.eq((Operators.Column)name, (Comparable)Binary.fromString((String)"alice")));
        List<Group> found = PhoneBookWriter.readFile(phonebookFile, FilterCompat.get((FilterPredicate)pred));
        TestRecordLevelFilters.assertFilter(found, new UserFilter(){

            @Override
            public boolean keep(PhoneBookWriter.User u) {
                String name = u.getName();
                Double lat = null;
                Double lon = null;
                if (u.getLocation() != null) {
                    lat = u.getLocation().getLat();
                    lon = u.getLocation().getLon();
                }
                return lon != null && lon > 150.0 && lat != null || "alice".equals(name);
            }
        });
    }

    public static class StartWithP
    extends UserDefinedPredicate<Binary> {
        public boolean keep(Binary value) {
            if (value == null) {
                return false;
            }
            return value.toStringUsingUTF8().startsWith("p");
        }

        public boolean canDrop(Statistics<Binary> statistics) {
            return false;
        }

        public boolean inverseCanDrop(Statistics<Binary> statistics) {
            return false;
        }
    }

    private static interface UserFilter {
        public boolean keep(PhoneBookWriter.User var1);
    }
}

