/*
 * Decompiled with CFR 0.152.
 */
package parquet.hadoop;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import parquet.bytes.ByteBufferInputStream;
import parquet.bytes.BytesInput;
import parquet.hadoop.CodecFactory;
import parquet.hadoop.metadata.CompressionCodecName;

public class HeapCodecFactory
extends CodecFactory<CodecFactory.BytesCompressor, CodecFactory.BytesDecompressor> {
    public HeapCodecFactory(Configuration configuration) {
        super(configuration);
    }

    @Override
    public CodecFactory.BytesCompressor createCompressor(CompressionCodecName codecName, CompressionCodec codec, int pageSize) {
        return new HeapBytesCompressor(codecName, codec, pageSize);
    }

    @Override
    public CodecFactory.BytesDecompressor createDecompressor(CompressionCodec codec) {
        return new HeapBytesDecompressor(codec);
    }

    public static class HeapBytesCompressor
    extends CodecFactory.BytesCompressor {
        private final CompressionCodec codec;
        private final Compressor compressor;
        private final ByteArrayOutputStream compressedOutBuffer;
        private final CompressionCodecName codecName;

        public HeapBytesCompressor(CompressionCodecName codecName, CompressionCodec codec, int pageSize) {
            this.codecName = codecName;
            this.codec = codec;
            if (codec != null) {
                this.compressor = CodecPool.getCompressor((CompressionCodec)codec);
                this.compressedOutBuffer = new ByteArrayOutputStream(pageSize);
            } else {
                this.compressor = null;
                this.compressedOutBuffer = null;
            }
        }

        @Override
        public BytesInput compress(BytesInput bytes) throws IOException {
            BytesInput compressedBytes;
            if (this.codec == null) {
                compressedBytes = bytes;
            } else {
                this.compressedOutBuffer.reset();
                if (this.compressor != null) {
                    this.compressor.reset();
                }
                CompressionOutputStream cos = this.codec.createOutputStream((OutputStream)this.compressedOutBuffer, this.compressor);
                bytes.writeAllTo((OutputStream)cos);
                cos.finish();
                cos.close();
                compressedBytes = BytesInput.from((ByteArrayOutputStream)this.compressedOutBuffer);
            }
            return compressedBytes;
        }

        @Override
        protected void release() {
            if (this.compressor != null) {
                CodecPool.returnCompressor((Compressor)this.compressor);
            }
        }

        @Override
        public CompressionCodecName getCodecName() {
            return this.codecName;
        }
    }

    public static class HeapBytesDecompressor
    extends CodecFactory.BytesDecompressor {
        private final CompressionCodec codec;
        private final Decompressor decompressor;

        public HeapBytesDecompressor(CompressionCodec codec) {
            this.codec = codec;
            this.decompressor = codec != null ? CodecPool.getDecompressor((CompressionCodec)codec) : null;
        }

        @Override
        public BytesInput decompress(BytesInput bytes, int uncompressedSize) throws IOException {
            BytesInput decompressed;
            if (this.codec != null) {
                this.decompressor.reset();
                CompressionInputStream is = this.codec.createInputStream((InputStream)new ByteBufferInputStream(bytes.toByteBuffer()), this.decompressor);
                decompressed = BytesInput.from((InputStream)is, (int)uncompressedSize);
            } else {
                decompressed = bytes;
            }
            return decompressed;
        }

        @Override
        protected void release() {
            if (this.decompressor != null) {
                CodecPool.returnDecompressor((Decompressor)this.decompressor);
            }
        }
    }
}

