/*
 * Decompiled with CFR 0.152.
 */
package parquet.hadoop;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.util.ReflectionUtils;
import parquet.bytes.BytesInput;
import parquet.hadoop.BadConfigurationException;
import parquet.hadoop.metadata.CompressionCodecName;

public abstract class CodecFactory<C extends BytesCompressor, D extends BytesDecompressor> {
    protected static final Map<String, CompressionCodec> CODEC_BY_NAME = Collections.synchronizedMap(new HashMap());
    private final Map<CompressionCodecName, C> compressors = new HashMap<CompressionCodecName, C>();
    private final Map<CompressionCodecName, D> decompressors = new HashMap<CompressionCodecName, D>();
    protected final Configuration configuration;

    protected CodecFactory(Configuration configuration) {
        this.configuration = configuration;
    }

    public C getCompressor(CompressionCodecName codecName, int pageSize) {
        BytesCompressor comp = (BytesCompressor)this.compressors.get((Object)codecName);
        if (comp == null) {
            CompressionCodec codec = this.getCodec(codecName);
            comp = this.createCompressor(codecName, codec, pageSize);
            this.compressors.put(codecName, comp);
        }
        return (C)comp;
    }

    public D getDecompressor(CompressionCodecName codecName) {
        BytesDecompressor decomp = (BytesDecompressor)this.decompressors.get((Object)codecName);
        if (decomp == null) {
            CompressionCodec codec = this.getCodec(codecName);
            decomp = this.createDecompressor(codec);
            this.decompressors.put(codecName, decomp);
        }
        return (D)decomp;
    }

    protected abstract C createCompressor(CompressionCodecName var1, CompressionCodec var2, int var3);

    protected abstract D createDecompressor(CompressionCodec var1);

    protected CompressionCodec getCodec(CompressionCodecName codecName) {
        String codecClassName = codecName.getHadoopCompressionCodecClassName();
        if (codecClassName == null) {
            return null;
        }
        CompressionCodec codec = CODEC_BY_NAME.get(codecClassName);
        if (codec != null) {
            return codec;
        }
        try {
            Class<?> codecClass = Class.forName(codecClassName);
            codec = (CompressionCodec)ReflectionUtils.newInstance(codecClass, (Configuration)this.configuration);
            CODEC_BY_NAME.put(codecClassName, codec);
            return codec;
        }
        catch (ClassNotFoundException e) {
            throw new BadConfigurationException("Class " + codecClassName + " was not found", e);
        }
    }

    public void release() {
        for (BytesCompressor compressor : this.compressors.values()) {
            compressor.release();
        }
        this.compressors.clear();
        for (BytesDecompressor decompressor : this.decompressors.values()) {
            decompressor.release();
        }
        this.decompressors.clear();
    }

    public static abstract class BytesDecompressor {
        public abstract BytesInput decompress(BytesInput var1, int var2) throws IOException;

        protected abstract void release();
    }

    public static abstract class BytesCompressor {
        public abstract BytesInput compress(BytesInput var1) throws IOException;

        public abstract CompressionCodecName getCodecName();

        protected abstract void release();
    }
}

