/*
 * Decompiled with CFR 0.152.
 */
package parquet.filter2.recordlevel;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import parquet.example.data.Group;
import parquet.example.data.simple.SimpleGroup;
import parquet.filter2.compat.FilterCompat;
import parquet.filter2.recordlevel.TestRecordLevelFilters;
import parquet.hadoop.ParquetReader;
import parquet.hadoop.ParquetWriter;
import parquet.hadoop.api.ReadSupport;
import parquet.hadoop.api.WriteSupport;
import parquet.hadoop.example.GroupReadSupport;
import parquet.hadoop.example.GroupWriteSupport;
import parquet.schema.GroupType;
import parquet.schema.MessageType;
import parquet.schema.MessageTypeParser;

public class PhoneBookWriter {
    private static final String schemaString = "message user {\n  required int64 id;\n  optional binary name (UTF8);\n  optional group location {\n    optional double lon;\n    optional double lat;\n  }\n  optional group phoneNumbers {\n    repeated group phone {\n      required int64 number;\n      optional binary kind (UTF8);\n    }\n  }\n}\n";
    private static final MessageType schema = MessageTypeParser.parseMessageType((String)"message user {\n  required int64 id;\n  optional binary name (UTF8);\n  optional group location {\n    optional double lon;\n    optional double lat;\n  }\n  optional group phoneNumbers {\n    repeated group phone {\n      required int64 number;\n      optional binary kind (UTF8);\n    }\n  }\n}\n");

    public static SimpleGroup groupFromUser(User user) {
        SimpleGroup root = new SimpleGroup((GroupType)schema);
        root.append("id", user.getId());
        if (user.getName() != null) {
            root.append("name", user.getName());
        }
        if (user.getPhoneNumbers() != null) {
            Group phoneNumbers = root.addGroup("phoneNumbers");
            for (PhoneNumber number : user.getPhoneNumbers()) {
                Group phone = phoneNumbers.addGroup("phone");
                phone.append("number", number.getNumber());
                if (number.getKind() == null) continue;
                phone.append("kind", number.getKind());
            }
        }
        if (user.getLocation() != null) {
            Group location = root.addGroup("location");
            if (user.getLocation().getLon() != null) {
                location.append("lon", user.getLocation().getLon().doubleValue());
            }
            if (user.getLocation().getLat() != null) {
                location.append("lat", user.getLocation().getLat().doubleValue());
            }
        }
        return root;
    }

    public static File writeToFile(List<User> users) throws IOException {
        File f = File.createTempFile("phonebook", ".parquet");
        f.deleteOnExit();
        if (!f.delete()) {
            throw new IOException("couldn't delete tmp file" + f);
        }
        PhoneBookWriter.writeToFile(f, users);
        return f;
    }

    public static void writeToFile(File f, List<User> users) throws IOException {
        Configuration conf = new Configuration();
        GroupWriteSupport.setSchema((MessageType)schema, (Configuration)conf);
        ParquetWriter writer = new ParquetWriter(new Path(f.getAbsolutePath()), conf, (WriteSupport)new GroupWriteSupport());
        for (User u : users) {
            writer.write((Object)PhoneBookWriter.groupFromUser(u));
        }
        writer.close();
    }

    public static List<Group> readFile(File f, FilterCompat.Filter filter) throws IOException {
        Configuration conf = new Configuration();
        GroupWriteSupport.setSchema((MessageType)schema, (Configuration)conf);
        ParquetReader reader = ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)new Path(f.getAbsolutePath())).withConf(conf).withFilter(filter).build();
        ArrayList<Group> users = new ArrayList<Group>();
        Group current = (Group)reader.read();
        while (current != null) {
            users.add(current);
            current = (Group)reader.read();
        }
        return users;
    }

    public static void main(String[] args) throws IOException {
        File f = new File(args[0]);
        PhoneBookWriter.writeToFile(f, TestRecordLevelFilters.makeUsers());
    }

    public static class User {
        private final long id;
        private final String name;
        private final List<PhoneNumber> phoneNumbers;
        private final Location location;

        public User(long id, String name, List<PhoneNumber> phoneNumbers, Location location) {
            this.id = id;
            this.name = name;
            this.phoneNumbers = phoneNumbers;
            this.location = location;
        }

        public long getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public List<PhoneNumber> getPhoneNumbers() {
            return this.phoneNumbers;
        }

        public Location getLocation() {
            return this.location;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            User user = (User)o;
            if (this.id != user.id) {
                return false;
            }
            if (this.location != null ? !this.location.equals(user.location) : user.location != null) {
                return false;
            }
            if (this.name != null ? !this.name.equals(user.name) : user.name != null) {
                return false;
            }
            return !(this.phoneNumbers != null ? !this.phoneNumbers.equals(user.phoneNumbers) : user.phoneNumbers != null);
        }

        public int hashCode() {
            int result = (int)(this.id ^ this.id >>> 32);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.phoneNumbers != null ? this.phoneNumbers.hashCode() : 0);
            result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
            return result;
        }
    }

    public static class PhoneNumber {
        private final long number;
        private final String kind;

        public PhoneNumber(long number, String kind) {
            this.number = number;
            this.kind = kind;
        }

        public long getNumber() {
            return this.number;
        }

        public String getKind() {
            return this.kind;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PhoneNumber that = (PhoneNumber)o;
            if (this.number != that.number) {
                return false;
            }
            return !(this.kind != null ? !this.kind.equals(that.kind) : that.kind != null);
        }

        public int hashCode() {
            int result = (int)(this.number ^ this.number >>> 32);
            result = 31 * result + (this.kind != null ? this.kind.hashCode() : 0);
            return result;
        }
    }

    public static class Location {
        private final Double lon;
        private final Double lat;

        public Location(Double lon, Double lat) {
            this.lon = lon;
            this.lat = lat;
        }

        public Double getLon() {
            return this.lon;
        }

        public Double getLat() {
            return this.lat;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Location location = (Location)o;
            if (this.lat != null ? !this.lat.equals(location.lat) : location.lat != null) {
                return false;
            }
            return !(this.lon != null ? !this.lon.equals(location.lon) : location.lon != null);
        }

        public int hashCode() {
            int result = this.lon != null ? this.lon.hashCode() : 0;
            result = 31 * result + (this.lat != null ? this.lat.hashCode() : 0);
            return result;
        }
    }
}

