/*
 * Decompiled with CFR 0.152.
 */
package parquet.filter2.compat;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import parquet.column.statistics.IntStatistics;
import parquet.filter2.compat.FilterCompat;
import parquet.filter2.compat.RowGroupFilter;
import parquet.filter2.predicate.FilterApi;
import parquet.filter2.predicate.FilterPredicate;
import parquet.filter2.predicate.Operators;
import parquet.hadoop.TestInputFormat;
import parquet.hadoop.metadata.BlockMetaData;
import parquet.schema.MessageType;
import parquet.schema.MessageTypeParser;

public class TestRowGroupFilter {
    @Test
    public void testApplyRowGroupFilters() {
        ArrayList<BlockMetaData> blocks = new ArrayList<BlockMetaData>();
        IntStatistics stats1 = new IntStatistics();
        stats1.setMinMax(10, 100);
        stats1.setNumNulls(4L);
        BlockMetaData b1 = TestInputFormat.makeBlockFromStats(stats1, 301L);
        blocks.add(b1);
        IntStatistics stats2 = new IntStatistics();
        stats2.setMinMax(8, 102);
        stats2.setNumNulls(0L);
        BlockMetaData b2 = TestInputFormat.makeBlockFromStats(stats2, 302L);
        blocks.add(b2);
        IntStatistics stats3 = new IntStatistics();
        stats3.setMinMax(100, 102);
        stats3.setNumNulls(12L);
        BlockMetaData b3 = TestInputFormat.makeBlockFromStats(stats3, 303L);
        blocks.add(b3);
        IntStatistics stats4 = new IntStatistics();
        stats4.setMinMax(0, 0);
        stats4.setNumNulls(304L);
        BlockMetaData b4 = TestInputFormat.makeBlockFromStats(stats4, 304L);
        blocks.add(b4);
        IntStatistics stats5 = new IntStatistics();
        stats5.setMinMax(50, 50);
        stats5.setNumNulls(7L);
        BlockMetaData b5 = TestInputFormat.makeBlockFromStats(stats5, 305L);
        blocks.add(b5);
        IntStatistics stats6 = new IntStatistics();
        stats6.setMinMax(0, 0);
        stats6.setNumNulls(12L);
        BlockMetaData b6 = TestInputFormat.makeBlockFromStats(stats6, 306L);
        blocks.add(b6);
        MessageType schema = MessageTypeParser.parseMessageType((String)"message Document { optional int32 foo; }");
        Operators.IntColumn foo = FilterApi.intColumn((String)"foo");
        List filtered = RowGroupFilter.filterRowGroups((FilterCompat.Filter)FilterCompat.get((FilterPredicate)FilterApi.eq((Operators.Column)foo, (Comparable)Integer.valueOf(50))), blocks, (MessageType)schema);
        Assert.assertEquals(Arrays.asList(b1, b2, b5), (Object)filtered);
        filtered = RowGroupFilter.filterRowGroups((FilterCompat.Filter)FilterCompat.get((FilterPredicate)FilterApi.notEq((Operators.Column)foo, (Comparable)Integer.valueOf(50))), blocks, (MessageType)schema);
        Assert.assertEquals(Arrays.asList(b1, b2, b3, b4, b5, b6), (Object)filtered);
        filtered = RowGroupFilter.filterRowGroups((FilterCompat.Filter)FilterCompat.get((FilterPredicate)FilterApi.eq((Operators.Column)foo, null)), blocks, (MessageType)schema);
        Assert.assertEquals(Arrays.asList(b1, b3, b4, b5, b6), (Object)filtered);
        filtered = RowGroupFilter.filterRowGroups((FilterCompat.Filter)FilterCompat.get((FilterPredicate)FilterApi.notEq((Operators.Column)foo, null)), blocks, (MessageType)schema);
        Assert.assertEquals(Arrays.asList(b1, b2, b3, b5, b6), (Object)filtered);
        filtered = RowGroupFilter.filterRowGroups((FilterCompat.Filter)FilterCompat.get((FilterPredicate)FilterApi.eq((Operators.Column)foo, (Comparable)Integer.valueOf(0))), blocks, (MessageType)schema);
        Assert.assertEquals(Arrays.asList(b6), (Object)filtered);
    }
}

