/*
 * Decompiled with CFR 0.152.
 */
package parquet.hadoop;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapred.Utils;
import parquet.Log;
import parquet.bytes.ByteBufferInputStream;
import parquet.bytes.BytesInput;
import parquet.bytes.BytesUtils;
import parquet.column.ColumnDescriptor;
import parquet.column.page.DictionaryPage;
import parquet.column.page.Page;
import parquet.column.page.PageReadStore;
import parquet.format.PageHeader;
import parquet.format.Util;
import parquet.format.converter.ParquetMetadataConverter;
import parquet.hadoop.CodecFactory;
import parquet.hadoop.ColumnChunkIncReadStore;
import parquet.hadoop.ColumnChunkPageReadStore;
import parquet.hadoop.Footer;
import parquet.hadoop.ParquetFileWriter;
import parquet.hadoop.metadata.BlockMetaData;
import parquet.hadoop.metadata.ColumnChunkMetaData;
import parquet.hadoop.metadata.ColumnPath;
import parquet.hadoop.metadata.ParquetMetadata;
import parquet.hadoop.util.CompatibilityUtil;
import parquet.hadoop.util.counters.BenchmarkCounter;
import parquet.io.ParquetDecodingException;

public class ParquetFileReader
implements Closeable {
    private static final Log LOG = Log.getLog(ParquetFileReader.class);
    private static ParquetMetadataConverter parquetMetadataConverter = new ParquetMetadataConverter();
    private final CodecFactory codecFactory;
    private final List<BlockMetaData> blocks;
    private final FSDataInputStream f;
    private final FileSystem fs;
    private final Path filePath;
    private int currentBlock = 0;
    private final Map<ColumnPath, ColumnDescriptor> paths = new HashMap<ColumnPath, ColumnDescriptor>();

    public static List<Footer> readAllFootersInParallelUsingSummaryFiles(final Configuration configuration, List<FileStatus> partFiles) throws IOException {
        HashSet<Path> parents = new HashSet<Path>();
        for (FileStatus part : partFiles) {
            parents.add(part.getPath().getParent());
        }
        ArrayList summaries = new ArrayList();
        for (final Path path : parents) {
            summaries.add(new Callable<Map<Path, Footer>>(){

                @Override
                public Map<Path, Footer> call() throws Exception {
                    Path summaryFile;
                    FileSystem fileSystem = path.getFileSystem(configuration);
                    if (fileSystem.exists(summaryFile = new Path(path, "_metadata"))) {
                        if (Log.INFO) {
                            LOG.info((Object)("reading summary file: " + summaryFile));
                        }
                        List<Footer> footers = ParquetFileReader.readSummaryFile(configuration, fileSystem.getFileStatus(summaryFile));
                        HashMap<Path, Footer> map = new HashMap<Path, Footer>();
                        for (Footer footer : footers) {
                            footer = new Footer(new Path(path, footer.getFile().getName()), footer.getParquetMetadata());
                            map.put(footer.getFile(), footer);
                        }
                        return map;
                    }
                    return Collections.emptyMap();
                }
            });
        }
        HashMap cache = new HashMap();
        try {
            List<Map> footersFromSummaries = ParquetFileReader.runAllInParallel(5, summaries);
            for (Map footers : footersFromSummaries) {
                cache.putAll(footers);
            }
        }
        catch (ExecutionException e) {
            throw new IOException("Error reading summaries", e);
        }
        ArrayList<Footer> result = new ArrayList<Footer>(partFiles.size());
        ArrayList<FileStatus> toRead = new ArrayList<FileStatus>();
        for (FileStatus part : partFiles) {
            Footer f = (Footer)cache.get(part.getPath());
            if (f != null) {
                result.add(f);
                continue;
            }
            toRead.add(part);
        }
        if (toRead.size() > 0) {
            if (Log.INFO) {
                LOG.info((Object)("reading another " + toRead.size() + " footers"));
            }
            result.addAll(ParquetFileReader.readAllFootersInParallel(configuration, toRead));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> List<T> runAllInParallel(int parallelism, List<Callable<T>> toRun) throws ExecutionException {
        ExecutorService threadPool = Executors.newFixedThreadPool(parallelism);
        try {
            ArrayList<Future<T>> futures = new ArrayList<Future<T>>();
            for (Callable<T> callable : toRun) {
                futures.add(threadPool.submit(callable));
            }
            ArrayList result = new ArrayList(toRun.size());
            for (Future future : futures) {
                try {
                    result.add(future.get());
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("The thread was interrupted", e);
                }
            }
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            threadPool.shutdownNow();
        }
    }

    public static List<Footer> readAllFootersInParallel(final Configuration configuration, List<FileStatus> partFiles) throws IOException {
        ArrayList footers = new ArrayList();
        for (final FileStatus currentFile : partFiles) {
            footers.add(new Callable<Footer>(){

                @Override
                public Footer call() throws Exception {
                    try {
                        return new Footer(currentFile.getPath(), ParquetFileReader.readFooter(configuration, currentFile));
                    }
                    catch (IOException e) {
                        throw new IOException("Could not read footer for file " + currentFile, e);
                    }
                }
            });
        }
        try {
            return ParquetFileReader.runAllInParallel(5, footers);
        }
        catch (ExecutionException e) {
            throw new IOException("Could not read footer: " + e.getMessage(), e.getCause());
        }
    }

    public static List<Footer> readAllFootersInParallel(Configuration configuration, FileStatus fileStatus) throws IOException {
        ArrayList<FileStatus> statuses;
        FileSystem fs = fileStatus.getPath().getFileSystem(configuration);
        if (fileStatus.isDir()) {
            statuses = Arrays.asList(fs.listStatus(fileStatus.getPath(), (PathFilter)new Utils.OutputFileUtils.OutputFilesFilter()));
        } else {
            statuses = new ArrayList<FileStatus>();
            statuses.add(fileStatus);
        }
        return ParquetFileReader.readAllFootersInParallel(configuration, statuses);
    }

    public static List<Footer> readFooters(Configuration configuration, FileStatus pathStatus) throws IOException {
        try {
            Path summaryPath;
            FileSystem fs;
            if (pathStatus.isDir() && (fs = (summaryPath = new Path(pathStatus.getPath(), "_metadata")).getFileSystem(configuration)).exists(summaryPath)) {
                FileStatus summaryStatus = fs.getFileStatus(summaryPath);
                return ParquetFileReader.readSummaryFile(configuration, summaryStatus);
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("can not read summary file for " + pathStatus.getPath()), (Throwable)e);
        }
        return ParquetFileReader.readAllFootersInParallel(configuration, pathStatus);
    }

    public static List<Footer> readSummaryFile(Configuration configuration, FileStatus summaryStatus) throws IOException {
        Path parent = summaryStatus.getPath().getParent();
        ParquetMetadata mergedFooters = ParquetFileReader.readFooter(configuration, summaryStatus);
        HashMap<Path, ParquetMetadata> footers = new HashMap<Path, ParquetMetadata>();
        List<BlockMetaData> blocks = mergedFooters.getBlocks();
        for (BlockMetaData block : blocks) {
            String path = block.getPath();
            Path fullPath = new Path(parent, path);
            ParquetMetadata current = (ParquetMetadata)footers.get(fullPath);
            if (current == null) {
                current = new ParquetMetadata(mergedFooters.getFileMetaData(), new ArrayList<BlockMetaData>());
                footers.put(fullPath, current);
            }
            current.getBlocks().add(block);
        }
        ArrayList<Footer> result = new ArrayList<Footer>();
        for (Map.Entry entry : footers.entrySet()) {
            result.add(new Footer((Path)entry.getKey(), (ParquetMetadata)entry.getValue()));
        }
        return result;
    }

    public static final ParquetMetadata readFooter(Configuration configuration, Path file) throws IOException {
        FileSystem fileSystem = file.getFileSystem(configuration);
        return ParquetFileReader.readFooter(configuration, fileSystem.getFileStatus(file));
    }

    public static final List<Footer> readFooters(Configuration configuration, Path file) throws IOException {
        FileSystem fileSystem = file.getFileSystem(configuration);
        return ParquetFileReader.readFooters(configuration, fileSystem.getFileStatus(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ParquetMetadata readFooter(Configuration configuration, FileStatus file) throws IOException {
        FileSystem fileSystem = file.getPath().getFileSystem(configuration);
        FSDataInputStream f = fileSystem.open(file.getPath());
        try {
            int FOOTER_LENGTH_SIZE;
            long l = file.getLen();
            if (Log.DEBUG) {
                LOG.debug((Object)("File length " + l));
            }
            if (l < (long)(ParquetFileWriter.MAGIC.length + (FOOTER_LENGTH_SIZE = 4) + ParquetFileWriter.MAGIC.length)) {
                throw new RuntimeException(file.getPath() + " is not a Parquet file (too small)");
            }
            long footerLengthIndex = l - (long)FOOTER_LENGTH_SIZE - (long)ParquetFileWriter.MAGIC.length;
            if (Log.DEBUG) {
                LOG.debug((Object)("reading footer index at " + footerLengthIndex));
            }
            f.seek(footerLengthIndex);
            int footerLength = BytesUtils.readIntLittleEndian((InputStream)f);
            byte[] magic = new byte[ParquetFileWriter.MAGIC.length];
            f.readFully(magic);
            if (!Arrays.equals(ParquetFileWriter.MAGIC, magic)) {
                throw new RuntimeException(file.getPath() + " is not a Parquet file. expected magic number at tail " + Arrays.toString(ParquetFileWriter.MAGIC) + " but found " + Arrays.toString(magic));
            }
            long footerIndex = footerLengthIndex - (long)footerLength;
            if (Log.DEBUG) {
                LOG.debug((Object)("read footer length: " + footerLength + ", footer index: " + footerIndex));
            }
            if (footerIndex < (long)ParquetFileWriter.MAGIC.length || footerIndex >= footerLengthIndex) {
                throw new RuntimeException("corrupted file: the footer index is not within the file");
            }
            f.seek(footerIndex);
            ParquetMetadata parquetMetadata = parquetMetadataConverter.readParquetMetadata(f);
            return parquetMetadata;
        }
        finally {
            f.close();
        }
    }

    public ParquetFileReader(Configuration configuration, Path filePath, List<BlockMetaData> blocks, List<ColumnDescriptor> columns) throws IOException {
        this.filePath = filePath;
        this.fs = filePath.getFileSystem(configuration);
        this.f = this.fs.open(filePath);
        this.blocks = blocks;
        for (ColumnDescriptor col : columns) {
            this.paths.put(ColumnPath.get(col.getPath()), col);
        }
        this.codecFactory = new CodecFactory(configuration);
    }

    public PageReadStore readNextRowGroup() throws IOException {
        if (this.currentBlock == this.blocks.size()) {
            return null;
        }
        BlockMetaData block = this.blocks.get(this.currentBlock);
        if (block.getRowCount() == 0L) {
            throw new RuntimeException("Illegal row group of 0 rows");
        }
        ColumnChunkPageReadStore columnChunkPageReadStore = new ColumnChunkPageReadStore(block.getRowCount());
        ArrayList<ConsecutiveChunkList> allChunks = new ArrayList<ConsecutiveChunkList>();
        ConsecutiveChunkList currentChunks = null;
        for (ColumnChunkMetaData mc : block.getColumns()) {
            ColumnPath pathKey = mc.getPath();
            BenchmarkCounter.incrementTotalBytes(mc.getTotalSize());
            ColumnDescriptor columnDescriptor = this.paths.get(pathKey);
            if (columnDescriptor == null) continue;
            long startingPos = mc.getStartingPos();
            if (currentChunks == null || currentChunks.endPos() != startingPos) {
                currentChunks = new ConsecutiveChunkList(startingPos);
                allChunks.add(currentChunks);
            }
            currentChunks.addChunk(new ChunkDescriptor(columnDescriptor, mc, startingPos, (int)mc.getTotalSize()));
        }
        for (ConsecutiveChunkList consecutiveChunks : allChunks) {
            List<Chunk> chunks = consecutiveChunks.readAll(this.f);
            for (Chunk chunk : chunks) {
                columnChunkPageReadStore.addColumn(chunk.descriptor.col, chunk.readAllPages());
            }
        }
        ++this.currentBlock;
        return columnChunkPageReadStore;
    }

    public PageReadStore getPageReadStore() throws IOException {
        if (this.currentBlock == this.blocks.size()) {
            return null;
        }
        BlockMetaData block = this.blocks.get(this.currentBlock);
        ColumnChunkIncReadStore pageReadStore = new ColumnChunkIncReadStore(block.getRowCount(), this.codecFactory, this.fs, this.filePath);
        for (ColumnChunkMetaData column : block.getColumns()) {
            pageReadStore.addColumn(this.paths.get(column.getPath()), column);
        }
        return pageReadStore;
    }

    @Override
    public void close() throws IOException {
        this.f.close();
        this.codecFactory.release();
    }

    private class ConsecutiveChunkList {
        private final long offset;
        private int length;
        private final List<ChunkDescriptor> chunks = new ArrayList<ChunkDescriptor>();

        ConsecutiveChunkList(long offset) {
            this.offset = offset;
        }

        public void addChunk(ChunkDescriptor descriptor) {
            this.chunks.add(descriptor);
            this.length += descriptor.size;
        }

        public List<Chunk> readAll(FSDataInputStream f) throws IOException {
            ArrayList<Chunk> result = new ArrayList<Chunk>(this.chunks.size());
            f.seek(this.offset);
            ByteBuffer chunksByteBuffer = CompatibilityUtil.getBuf(f, this.length);
            BenchmarkCounter.incrementBytesRead(this.length);
            int currentChunkOffset = 0;
            for (int i = 0; i < this.chunks.size(); ++i) {
                ChunkDescriptor descriptor = this.chunks.get(i);
                if (i < this.chunks.size() - 1) {
                    result.add(new Chunk(descriptor, chunksByteBuffer, currentChunkOffset));
                } else {
                    result.add(new WorkaroundChunk(descriptor, chunksByteBuffer, currentChunkOffset, f));
                }
                currentChunkOffset += descriptor.size;
            }
            return result;
        }

        public long endPos() {
            return this.offset + (long)this.length;
        }
    }

    private static class ChunkDescriptor {
        private final ColumnDescriptor col;
        private final ColumnChunkMetaData metadata;
        private final long fileOffset;
        private final int size;

        private ChunkDescriptor(ColumnDescriptor col, ColumnChunkMetaData metadata, long fileOffset, int size) {
            this.col = col;
            this.metadata = metadata;
            this.fileOffset = fileOffset;
            this.size = size;
        }
    }

    private class WorkaroundChunk
    extends Chunk {
        private final FSDataInputStream f;

        private WorkaroundChunk(ChunkDescriptor descriptor, ByteBuffer byteBuf, int offset, FSDataInputStream f) {
            super(descriptor, byteBuf, offset);
            this.f = f;
        }

        @Override
        protected PageHeader readPageHeader() throws IOException {
            PageHeader pageHeader;
            int initialPos = this.pos();
            try {
                pageHeader = Util.readPageHeader((InputStream)((Object)this));
            }
            catch (IOException e) {
                this.byteBuf.rewind();
                LOG.info((Object)"completing the column chunk to read the page header");
                pageHeader = Util.readPageHeader((InputStream)new SequenceInputStream((InputStream)((Object)this), (InputStream)this.f));
            }
            return pageHeader;
        }

        @Override
        public BytesInput readAsBytesInput(int size) throws IOException {
            if (size > this.byteBuf.remaining()) {
                int l1 = this.byteBuf.remaining();
                int l2 = size - l1;
                LOG.info((Object)("completed the column chunk with " + l2 + " bytes"));
                return BytesInput.concat((BytesInput[])new BytesInput[]{super.readAsBytesInput(l1), BytesInput.copy((BytesInput)BytesInput.from((InputStream)this.f, (int)l2))});
            }
            return super.readAsBytesInput(size);
        }
    }

    private class Chunk
    extends ByteBufferInputStream {
        private final ChunkDescriptor descriptor;

        public Chunk(ChunkDescriptor descriptor, ByteBuffer buffer, int offset) {
            super(buffer, offset, descriptor.size);
            this.descriptor = descriptor;
        }

        protected PageHeader readPageHeader() throws IOException {
            return Util.readPageHeader((InputStream)((Object)this));
        }

        public ColumnChunkPageReadStore.ColumnChunkPageReader readAllPages() throws IOException {
            ArrayList<Page> pagesInChunk = new ArrayList<Page>();
            DictionaryPage dictionaryPage = null;
            long valuesCountReadSoFar = 0L;
            block4: while (valuesCountReadSoFar < this.descriptor.metadata.getValueCount()) {
                PageHeader pageHeader = this.readPageHeader();
                switch (pageHeader.type) {
                    case DICTIONARY_PAGE: {
                        if (dictionaryPage != null) {
                            throw new ParquetDecodingException("more than one dictionary page in column " + this.descriptor.col);
                        }
                        dictionaryPage = new DictionaryPage(this.readAsBytesInput(pageHeader.compressed_page_size), pageHeader.uncompressed_page_size, pageHeader.dictionary_page_header.num_values, parquetMetadataConverter.getEncoding(pageHeader.dictionary_page_header.encoding));
                        continue block4;
                    }
                    case DATA_PAGE: {
                        BytesInput bytesInput = this.readAsBytesInput(pageHeader.compressed_page_size);
                        int n = pageHeader.data_page_header.num_values;
                        int n2 = pageHeader.uncompressed_page_size;
                        parquetMetadataConverter;
                        pagesInChunk.add(new Page(bytesInput, n, n2, ParquetMetadataConverter.fromParquetStatistics(pageHeader.data_page_header.statistics, this.descriptor.col.getType()), parquetMetadataConverter.getEncoding(pageHeader.data_page_header.repetition_level_encoding), parquetMetadataConverter.getEncoding(pageHeader.data_page_header.definition_level_encoding), parquetMetadataConverter.getEncoding(pageHeader.data_page_header.encoding)));
                        valuesCountReadSoFar += (long)pageHeader.data_page_header.num_values;
                        continue block4;
                    }
                }
                if (Log.DEBUG) {
                    LOG.debug((Object)("skipping page of type " + pageHeader.type + " of size " + pageHeader.compressed_page_size));
                }
                this.skip(pageHeader.compressed_page_size);
            }
            if (valuesCountReadSoFar != this.descriptor.metadata.getValueCount()) {
                throw new IOException("Expected " + this.descriptor.metadata.getValueCount() + " values in column chunk at " + ParquetFileReader.this.filePath + " offset " + this.descriptor.metadata.getFirstDataPageOffset() + " but got " + valuesCountReadSoFar + " values instead over " + pagesInChunk.size() + " pages ending at file offset " + (this.descriptor.fileOffset + (long)this.pos()));
            }
            CodecFactory.BytesDecompressor decompressor = ParquetFileReader.this.codecFactory.getDecompressor(this.descriptor.metadata.getCodec());
            return new ColumnChunkPageReadStore.ColumnChunkPageReader(decompressor, pagesInChunk, dictionaryPage);
        }

        public int pos() {
            return this.byteBuf.position();
        }

        public BytesInput readAsBytesInput(int size) throws IOException {
            int pos = this.byteBuf.position();
            BytesInput r = BytesInput.from((ByteBuffer)this.byteBuf, (int)pos, (int)size);
            this.byteBuf.position(pos + size);
            return r;
        }
    }
}

