/*
 * Decompiled with CFR 0.152.
 */
package parquet.hadoop;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import parquet.column.Encoding;
import parquet.column.statistics.BinaryStatistics;
import parquet.column.statistics.Statistics;
import parquet.hadoop.ParquetInputFormat;
import parquet.hadoop.ParquetInputSplit;
import parquet.hadoop.metadata.BlockMetaData;
import parquet.hadoop.metadata.ColumnChunkMetaData;
import parquet.hadoop.metadata.ColumnPath;
import parquet.hadoop.metadata.CompressionCodecName;
import parquet.hadoop.metadata.FileMetaData;
import parquet.io.ParquetDecodingException;
import parquet.schema.MessageType;
import parquet.schema.MessageTypeParser;
import parquet.schema.PrimitiveType;

public class TestInputFormat {
    List<BlockMetaData> blocks;
    BlockLocation[] hdfsBlocks;
    FileStatus fileStatus;
    MessageType schema;
    FileMetaData fileMetaData;

    @Before
    public void setUp() {
        this.blocks = new ArrayList<BlockMetaData>();
        int i = 0;
        while (i < 10) {
            this.blocks.add(this.newBlock(i * 10, 10L));
            ++i;
        }
        this.fileStatus = new FileStatus(100L, false, 2, 50L, 0L, new Path("hdfs://foo.namenode:1234/bar"));
        this.schema = MessageTypeParser.parseMessageType((String)"message doc { required binary foo; }");
        this.fileMetaData = new FileMetaData(this.schema, new HashMap(), "parquet-mr");
    }

    @Test
    public void testThrowExceptionWhenMaxSplitSizeIsSmallerThanMinSplitSize() throws IOException {
        try {
            this.generateSplitByMinMaxSize(50L, 49L);
            Assert.fail((String)"should throw exception when max split size is smaller than the min split size");
        }
        catch (ParquetDecodingException e) {
            Assert.assertEquals((Object)"maxSplitSize and minSplitSize should be positive and max should be greater or equal to the minSplitSize: maxSplitSize = 49; minSplitSize is 50", (Object)e.getMessage());
        }
    }

    @Test
    public void testThrowExceptionWhenMaxSplitSizeIsNegative() throws IOException {
        try {
            this.generateSplitByMinMaxSize(-100L, -50L);
            Assert.fail((String)"should throw exception when max split size is negative");
        }
        catch (ParquetDecodingException e) {
            Assert.assertEquals((Object)"maxSplitSize and minSplitSize should be positive and max should be greater or equal to the minSplitSize: maxSplitSize = -50; minSplitSize is -100", (Object)e.getMessage());
        }
    }

    @Test
    public void testGenerateSplitsAlignedWithHDFSBlock() throws IOException {
        this.withHDFSBlockSize(50L, 50L);
        List<ParquetInputSplit> splits = this.generateSplitByMinMaxSize(50L, 50L);
        this.shouldSplitBlockSizeBe(splits, 5, 5);
        this.shouldSplitLocationBe(splits, 0, 1);
        this.shouldSplitLengthBe(splits, 50, 50);
        splits = this.generateSplitByMinMaxSize(0L, Long.MAX_VALUE);
        this.shouldSplitBlockSizeBe(splits, 5, 5);
        this.shouldSplitLocationBe(splits, 0, 1);
        this.shouldSplitLengthBe(splits, 50, 50);
    }

    @Test
    public void testRowGroupNotAlignToHDFSBlock() throws IOException {
        this.withHDFSBlockSize(51L, 51L);
        List<ParquetInputSplit> splits = this.generateSplitByMinMaxSize(50L, 50L);
        this.shouldSplitBlockSizeBe(splits, 5, 5);
        this.shouldSplitLocationBe(splits, 0, 0);
        this.shouldSplitLengthBe(splits, 50, 50);
        this.withHDFSBlockSize(49L, 49L);
        splits = this.generateSplitByMinMaxSize(50L, 50L);
        this.shouldSplitBlockSizeBe(splits, 5, 5);
        this.shouldSplitLocationBe(splits, 0, 1);
        this.shouldSplitLengthBe(splits, 50, 50);
        this.withHDFSBlockSize(44L, 44L, 44L);
        splits = this.generateSplitByMinMaxSize(40L, 50L);
        this.shouldSplitBlockSizeBe(splits, 4, 5, 1);
        this.shouldSplitLocationBe(splits, 0, 0, 2);
        this.shouldSplitLengthBe(splits, 40, 50, 10);
    }

    @Test
    public void testGenerateSplitsNotAlignedWithHDFSBlock() throws IOException, InterruptedException {
        this.withHDFSBlockSize(50L, 50L);
        List<ParquetInputSplit> splits = this.generateSplitByMinMaxSize(55L, 56L);
        this.shouldSplitBlockSizeBe(splits, 6, 4);
        this.shouldSplitLocationBe(splits, 0, 1);
        this.shouldSplitLengthBe(splits, 60, 40);
        this.withHDFSBlockSize(51L, 51L);
        splits = this.generateSplitByMinMaxSize(55L, 56L);
        this.shouldSplitBlockSizeBe(splits, 6, 4);
        this.shouldSplitLocationBe(splits, 0, 1);
        this.shouldSplitLengthBe(splits, 60, 40);
        this.withHDFSBlockSize(49L, 49L, 49L);
        splits = this.generateSplitByMinMaxSize(55L, 56L);
        this.shouldSplitBlockSizeBe(splits, 6, 4);
        this.shouldSplitLocationBe(splits, 0, 1);
        this.shouldSplitLengthBe(splits, 60, 40);
    }

    @Test
    public void testGenerateSplitsSmallerThanMaxSizeAndAlignToHDFS() throws Exception {
        this.withHDFSBlockSize(50L, 50L);
        List<ParquetInputSplit> splits = this.generateSplitByMinMaxSize(18L, 30L);
        this.shouldSplitBlockSizeBe(splits, 3, 2, 3, 2);
        this.shouldSplitLocationBe(splits, 0, 0, 1, 1);
        this.shouldSplitLengthBe(splits, 30, 20, 30, 20);
        this.withHDFSBlockSize(51L, 51L);
        splits = this.generateSplitByMinMaxSize(18L, 30L);
        this.shouldSplitBlockSizeBe(splits, 3, 2, 3, 2);
        this.shouldSplitLocationBe(splits, 0, 0, 0, 1);
        this.shouldSplitLengthBe(splits, 30, 20, 30, 20);
        this.withHDFSBlockSize(49L, 49L, 49L);
        splits = this.generateSplitByMinMaxSize(18L, 30L);
        this.shouldSplitBlockSizeBe(splits, 3, 2, 3, 2);
        this.shouldSplitLocationBe(splits, 0, 0, 1, 1);
        this.shouldSplitLengthBe(splits, 30, 20, 30, 20);
    }

    @Test
    public void testGenerateSplitsCrossHDFSBlockBoundaryToSatisfyMinSize() throws Exception {
        this.withHDFSBlockSize(50L, 50L);
        List<ParquetInputSplit> splits = this.generateSplitByMinMaxSize(25L, 30L);
        this.shouldSplitBlockSizeBe(splits, 3, 3, 3, 1);
        this.shouldSplitLocationBe(splits, 0, 0, 1, 1);
        this.shouldSplitLengthBe(splits, 30, 30, 30, 10);
    }

    @Test
    public void testMultipleRowGroupsInABlockToAlignHDFSBlock() throws Exception {
        this.withHDFSBlockSize(50L, 50L);
        List<ParquetInputSplit> splits = this.generateSplitByMinMaxSize(10L, 18L);
        this.shouldSplitBlockSizeBe(splits, 2, 2, 1, 2, 2, 1);
        this.shouldSplitLocationBe(splits, 0, 0, 0, 1, 1, 1);
        this.shouldSplitLengthBe(splits, 20, 20, 10, 20, 20, 10);
        this.withHDFSBlockSize(51L, 51L);
        splits = this.generateSplitByMinMaxSize(10L, 18L);
        this.shouldSplitBlockSizeBe(splits, 2, 2, 1, 2, 2, 1);
        this.shouldSplitLocationBe(splits, 0, 0, 0, 0, 1, 1);
        this.shouldSplitLengthBe(splits, 20, 20, 10, 20, 20, 10);
        this.withHDFSBlockSize(49L, 49L);
        splits = this.generateSplitByMinMaxSize(10L, 18L);
        this.shouldSplitBlockSizeBe(splits, 2, 2, 1, 2, 2, 1);
        this.shouldSplitLocationBe(splits, 0, 0, 0, 1, 1, 1);
        this.shouldSplitLengthBe(splits, 20, 20, 10, 20, 20, 10);
    }

    private List<ParquetInputSplit> generateSplitByMinMaxSize(long min, long max) throws IOException {
        return ParquetInputFormat.generateSplits(this.blocks, (BlockLocation[])this.hdfsBlocks, (FileStatus)this.fileStatus, (FileMetaData)this.fileMetaData, (String)this.schema.toString(), (Map)new HashMap<String, String>(){
            {
                this.put("specific", "foo");
            }
        }, (long)min, (long)max);
    }

    private void shouldSplitBlockSizeBe(List<ParquetInputSplit> splits, int ... sizes) {
        Assert.assertEquals((long)sizes.length, (long)splits.size());
        int i = 0;
        while (i < sizes.length) {
            Assert.assertEquals((long)sizes[i], (long)splits.get(i).getBlocks().size());
            Assert.assertEquals((Object)"foo", splits.get(i).getReadSupportMetadata().get("specific"));
            ++i;
        }
    }

    private void shouldSplitLocationBe(List<ParquetInputSplit> splits, int ... locations) throws IOException {
        Assert.assertEquals((long)locations.length, (long)splits.size());
        int i = 0;
        while (i < locations.length) {
            Assert.assertEquals((Object)("[foo" + locations[i] + ".datanode, bar" + locations[i] + ".datanode]"), (Object)Arrays.toString(splits.get(i).getLocations()));
            ++i;
        }
    }

    private void shouldSplitLengthBe(List<ParquetInputSplit> splits, int ... lengths) {
        Assert.assertEquals((long)lengths.length, (long)splits.size());
        int i = 0;
        while (i < lengths.length) {
            Assert.assertEquals((long)lengths[i], (long)splits.get(i).getLength());
            ++i;
        }
    }

    private void withHDFSBlockSize(long ... blockSizes) {
        this.hdfsBlocks = new BlockLocation[blockSizes.length];
        long offset = 0L;
        int i = 0;
        while (i < blockSizes.length) {
            long blockSize = blockSizes[i];
            this.hdfsBlocks[i] = new BlockLocation(new String[0], new String[]{"foo" + i + ".datanode", "bar" + i + ".datanode"}, offset, blockSize);
            offset += blockSize;
            ++i;
        }
    }

    private BlockMetaData newBlock(long start, long compressedBlockSize) {
        BlockMetaData blockMetaData = new BlockMetaData();
        long uncompressedSize = compressedBlockSize * 2L;
        ColumnChunkMetaData column = ColumnChunkMetaData.get((ColumnPath)ColumnPath.get((String[])new String[]{"foo"}), (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (CompressionCodecName)CompressionCodecName.GZIP, new HashSet<Encoding>(Arrays.asList(Encoding.PLAIN)), (Statistics)new BinaryStatistics(), (long)start, (long)0L, (long)0L, (long)compressedBlockSize, (long)uncompressedSize);
        blockMetaData.addColumn(column);
        blockMetaData.setTotalByteSize(uncompressedSize);
        return blockMetaData;
    }
}

