/*
 * Decompiled with CFR 0.152.
 */
package parquet.hadoop;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TextInputFormat;
import org.junit.Before;
import org.junit.Test;
import parquet.example.data.Group;
import parquet.example.data.simple.SimpleGroupFactory;
import parquet.hadoop.example.GroupWriteSupport;
import parquet.hadoop.mapred.DeprecatedParquetOutputFormat;
import parquet.hadoop.metadata.CompressionCodecName;
import parquet.schema.MessageType;
import parquet.schema.MessageTypeParser;

public class DeprecatedOutputFormatTest {
    final Path parquetPath = new Path("target/test/example/TestInputOutputFormat/parquet");
    final Path inputPath = new Path("src/test/java/parquet/hadoop/example/TestInputOutputFormat.java");
    final Path outputPath = new Path("target/test/example/TestInputOutputFormat/out");
    JobConf jobConf;
    RunningJob mapRedJob;
    private String writeSchema;
    private Configuration conf;

    @Before
    public void setUp() {
        this.conf = new Configuration();
        this.jobConf = new JobConf();
        this.writeSchema = "message example {\nrequired int32 line;\nrequired binary content;\n}";
    }

    private void runMapReduceJob(CompressionCodecName codec) throws IOException, ClassNotFoundException, InterruptedException {
        FileSystem fileSystem = this.parquetPath.getFileSystem(this.conf);
        fileSystem.delete(this.parquetPath, true);
        fileSystem.delete(this.outputPath, true);
        this.jobConf.setInputFormat(TextInputFormat.class);
        TextInputFormat.addInputPath((JobConf)this.jobConf, (Path)this.inputPath);
        this.jobConf.setNumReduceTasks(0);
        this.jobConf.setOutputFormat(DeprecatedParquetOutputFormat.class);
        DeprecatedParquetOutputFormat.setCompression((Configuration)this.jobConf, (CompressionCodecName)codec);
        DeprecatedParquetOutputFormat.setOutputPath((JobConf)this.jobConf, (Path)this.parquetPath);
        DeprecatedParquetOutputFormat.setWriteSupportClass((Configuration)this.jobConf, GroupWriteSupport.class);
        GroupWriteSupport.setSchema((MessageType)MessageTypeParser.parseMessageType((String)this.writeSchema), (Configuration)this.jobConf);
        this.jobConf.setMapperClass(DeprecatedMapper.class);
        this.mapRedJob = JobClient.runJob((JobConf)this.jobConf);
    }

    @Test
    public void testReadWrite() throws Exception {
        this.runMapReduceJob(CompressionCodecName.GZIP);
        assert (this.mapRedJob.isSuccessful());
    }

    public static class DeprecatedMapper
    implements Mapper<LongWritable, Text, Void, Group> {
        private SimpleGroupFactory factory;

        public void configure(JobConf job) {
            this.factory = new SimpleGroupFactory(GroupWriteSupport.getSchema((Configuration)job));
        }

        public void map(LongWritable key, Text value, OutputCollector<Void, Group> outputCollector, Reporter reporter) throws IOException {
            Group group = this.factory.newGroup().append("line", (int)key.get()).append("content", value.toString());
            outputCollector.collect(null, (Object)group);
        }

        public void close() {
        }
    }
}

