/*
 * Decompiled with CFR 0.152.
 */
package parquet.format.converter;

import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import parquet.example.Paper;
import parquet.format.ConvertedType;
import parquet.format.Encoding;
import parquet.format.FieldRepetitionType;
import parquet.format.PageHeader;
import parquet.format.PageType;
import parquet.format.SchemaElement;
import parquet.format.Type;
import parquet.format.Util;
import parquet.format.converter.ParquetMetadataConverter;
import parquet.schema.MessageType;
import parquet.schema.OriginalType;
import parquet.schema.PrimitiveType;
import parquet.schema.Type;
import parquet.schema.Types;

public class TestParquetMetadataConverter {
    @Test
    public void testPageHeader() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PageType type = PageType.DATA_PAGE;
        int compSize = 10;
        int uncSize = 20;
        PageHeader pageHeader = new PageHeader(type, uncSize, compSize);
        Util.writePageHeader((PageHeader)pageHeader, (OutputStream)out);
        PageHeader readPageHeader = Util.readPageHeader((InputStream)new ByteArrayInputStream(out.toByteArray()));
        Assert.assertEquals((Object)pageHeader, (Object)readPageHeader);
    }

    @Test
    public void testSchemaConverter() {
        ParquetMetadataConverter parquetMetadataConverter = new ParquetMetadataConverter();
        List parquetSchema = parquetMetadataConverter.toParquetSchema(Paper.schema);
        MessageType schema = parquetMetadataConverter.fromParquetSchema(parquetSchema);
        Assert.assertEquals((Object)Paper.schema, (Object)schema);
    }

    @Test
    public void testSchemaConverterDecimal() {
        ParquetMetadataConverter converter = new ParquetMetadataConverter();
        List schemaElements = converter.toParquetSchema((MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.DECIMAL)).precision(9).scale(2).named("aBinaryDecimal")).optional(PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(4).as(OriginalType.DECIMAL)).precision(9).scale(2).named("aFixedDecimal")).named("Message"));
        ArrayList expected = Lists.newArrayList((Object[])new SchemaElement[]{new SchemaElement("Message").setNum_children(2), new SchemaElement("aBinaryDecimal").setRepetition_type(FieldRepetitionType.REQUIRED).setType(Type.BYTE_ARRAY).setConverted_type(ConvertedType.DECIMAL).setPrecision(9).setScale(2), new SchemaElement("aFixedDecimal").setRepetition_type(FieldRepetitionType.OPTIONAL).setType(Type.FIXED_LEN_BYTE_ARRAY).setType_length(4).setConverted_type(ConvertedType.DECIMAL).setPrecision(9).setScale(2)});
        Assert.assertEquals((Object)expected, (Object)schemaElements);
    }

    @Test
    public void testEnumEquivalence() {
        parquet.column.Encoding repetition;
        parquet.column.Encoding encoding;
        ParquetMetadataConverter c = new ParquetMetadataConverter();
        parquet.column.Encoding[] encodingArray = parquet.column.Encoding.values();
        int n = encodingArray.length;
        int n2 = 0;
        while (n2 < n) {
            encoding = encodingArray[n2];
            Assert.assertEquals((Object)encoding, (Object)c.getEncoding(c.getEncoding(encoding)));
            ++n2;
        }
        encodingArray = Encoding.values();
        n = encodingArray.length;
        n2 = 0;
        while (n2 < n) {
            encoding = encodingArray[n2];
            Assert.assertEquals((Object)encoding, (Object)c.getEncoding(c.getEncoding((Encoding)encoding)));
            ++n2;
        }
        encodingArray = Type.Repetition.values();
        n = encodingArray.length;
        n2 = 0;
        while (n2 < n) {
            repetition = encodingArray[n2];
            Assert.assertEquals((Object)repetition, (Object)c.fromParquetRepetition(c.toParquetRepetition((Type.Repetition)repetition)));
            ++n2;
        }
        encodingArray = FieldRepetitionType.values();
        n = encodingArray.length;
        n2 = 0;
        while (n2 < n) {
            repetition = encodingArray[n2];
            Assert.assertEquals((Object)repetition, (Object)c.toParquetRepetition(c.fromParquetRepetition((FieldRepetitionType)repetition)));
            ++n2;
        }
        encodingArray = PrimitiveType.PrimitiveTypeName.values();
        n = encodingArray.length;
        n2 = 0;
        while (n2 < n) {
            parquet.column.Encoding primitiveTypeName = encodingArray[n2];
            Assert.assertEquals((Object)primitiveTypeName, (Object)c.getPrimitive(c.getType((PrimitiveType.PrimitiveTypeName)primitiveTypeName)));
            ++n2;
        }
        encodingArray = Type.values();
        n = encodingArray.length;
        n2 = 0;
        while (n2 < n) {
            parquet.column.Encoding type = encodingArray[n2];
            Assert.assertEquals((Object)type, (Object)c.getType(c.getPrimitive((Type)type)));
            ++n2;
        }
    }
}

