/*
 * Decompiled with CFR 0.152.
 */
package parquet.bytes;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import parquet.bytes.ByteBufferAllocator;
import parquet.bytes.BytesInput;
import parquet.bytes.CapacityByteArrayOutputStream;
import parquet.bytes.DirectByteBufferAllocator;
import parquet.bytes.HeapByteBufferAllocator;

public class TestCapacityByteArrayOutputStream {
    @Test
    public void testWrite() throws Throwable {
        CapacityByteArrayOutputStream capacityByteArrayOutputStream = new CapacityByteArrayOutputStream(10, (ByteBufferAllocator)new HeapByteBufferAllocator());
        int expectedSize = 54;
        for (int i = 0; i < 54; ++i) {
            capacityByteArrayOutputStream.write(i);
            Assert.assertEquals((long)(i + 1), (long)capacityByteArrayOutputStream.size());
        }
        this.validate(capacityByteArrayOutputStream, 54);
    }

    @Test
    public void testWriteArray() throws Throwable {
        CapacityByteArrayOutputStream capacityByteArrayOutputStream = new CapacityByteArrayOutputStream(10, (ByteBufferAllocator)new DirectByteBufferAllocator());
        int v = 23;
        this.writeArraysOf3(capacityByteArrayOutputStream, v);
        this.validate(capacityByteArrayOutputStream, v * 3);
    }

    @Test
    public void testWriteArrayAndInt() throws Throwable {
        CapacityByteArrayOutputStream capacityByteArrayOutputStream = new CapacityByteArrayOutputStream(10, (ByteBufferAllocator)new DirectByteBufferAllocator());
        for (int i = 0; i < 23; ++i) {
            byte[] toWrite = new byte[]{(byte)(i * 3), (byte)(i * 3 + 1)};
            capacityByteArrayOutputStream.write(toWrite);
            capacityByteArrayOutputStream.write((int)((byte)(i * 3 + 2)));
            Assert.assertEquals((long)((i + 1) * 3), (long)capacityByteArrayOutputStream.size());
        }
        this.validate(capacityByteArrayOutputStream, 69);
    }

    @Test
    public void testReset() throws Throwable {
        int i;
        CapacityByteArrayOutputStream capacityByteArrayOutputStream = new CapacityByteArrayOutputStream(10, (ByteBufferAllocator)new DirectByteBufferAllocator());
        for (i = 0; i < 54; ++i) {
            capacityByteArrayOutputStream.write(i);
            Assert.assertEquals((long)(i + 1), (long)capacityByteArrayOutputStream.size());
        }
        capacityByteArrayOutputStream.reset();
        for (i = 0; i < 54; ++i) {
            capacityByteArrayOutputStream.write(54 + i);
            Assert.assertEquals((long)(i + 1), (long)capacityByteArrayOutputStream.size());
        }
        byte[] byteArray = BytesInput.from((CapacityByteArrayOutputStream)capacityByteArrayOutputStream).toByteArray();
        Assert.assertEquals((long)54L, (long)byteArray.length);
        for (int i2 = 0; i2 < 54; ++i2) {
            Assert.assertEquals((String)(i2 + " in " + Arrays.toString(byteArray)), (long)(54 + i2), (long)byteArray[i2]);
        }
    }

    @Test
    public void testWriteArrayBiggerThanSlab() throws Throwable {
        CapacityByteArrayOutputStream capacityByteArrayOutputStream = new CapacityByteArrayOutputStream(10, (ByteBufferAllocator)new DirectByteBufferAllocator());
        int v = 23;
        this.writeArraysOf3(capacityByteArrayOutputStream, v);
        int n = v * 3;
        byte[] toWrite = new byte[]{(byte)n, (byte)(n + 1), (byte)(n + 2), (byte)(n + 3), (byte)(n + 4), (byte)(n + 5), (byte)(n + 6), (byte)(n + 7), (byte)(n + 8), (byte)(n + 9), (byte)(n + 10), (byte)(n + 11), (byte)(n + 12), (byte)(n + 13), (byte)(n + 14), (byte)(n + 15), (byte)(n + 16), (byte)(n + 17), (byte)(n + 18), (byte)(n + 19), (byte)(n + 20)};
        capacityByteArrayOutputStream.write(toWrite);
        Assert.assertEquals((long)(n += toWrite.length), (long)capacityByteArrayOutputStream.size());
        this.validate(capacityByteArrayOutputStream, n);
        capacityByteArrayOutputStream.reset();
        capacityByteArrayOutputStream.write(toWrite);
        Assert.assertEquals((long)toWrite.length, (long)capacityByteArrayOutputStream.size());
        byte[] byteArray = BytesInput.from((CapacityByteArrayOutputStream)capacityByteArrayOutputStream).toByteArray();
        Assert.assertEquals((long)toWrite.length, (long)byteArray.length);
        for (int i = 0; i < toWrite.length; ++i) {
            Assert.assertEquals((long)toWrite[i], (long)byteArray[i]);
        }
    }

    @Test
    public void testWriteArrayManySlabs() throws Throwable {
        int i;
        CapacityByteArrayOutputStream capacityByteArrayOutputStream = new CapacityByteArrayOutputStream(10, (ByteBufferAllocator)new DirectByteBufferAllocator());
        int it = 500;
        int v = 23;
        for (int j = 0; j < it; ++j) {
            for (i = 0; i < v; ++i) {
                byte[] toWrite = new byte[]{(byte)(i * 3), (byte)(i * 3 + 1), (byte)(i * 3 + 2)};
                capacityByteArrayOutputStream.write(toWrite);
                Assert.assertEquals((long)((i + 1) * 3 + v * 3 * j), (long)capacityByteArrayOutputStream.size());
            }
        }
        byte[] byteArray = BytesInput.from((CapacityByteArrayOutputStream)capacityByteArrayOutputStream).toByteArray();
        Assert.assertEquals((long)(v * 3 * it), (long)byteArray.length);
        for (i = 0; i < v * 3 * it; ++i) {
            Assert.assertEquals((long)(i % (v * 3)), (long)byteArray[i]);
        }
        Assert.assertTrue((String)("slab count: " + capacityByteArrayOutputStream.getSlabCount()), (capacityByteArrayOutputStream.getSlabCount() <= 20 ? 1 : 0) != 0);
        capacityByteArrayOutputStream.reset();
        this.writeArraysOf3(capacityByteArrayOutputStream, v);
        this.validate(capacityByteArrayOutputStream, v * 3);
        Assert.assertTrue((String)("slab count: " + capacityByteArrayOutputStream.getSlabCount()), (capacityByteArrayOutputStream.getSlabCount() <= 2 ? 1 : 0) != 0);
    }

    @Test
    public void testReplaceByte() throws Throwable {
        CapacityByteArrayOutputStream cbaos = new CapacityByteArrayOutputStream(5, (ByteBufferAllocator)new DirectByteBufferAllocator());
        cbaos.write(10);
        Assert.assertEquals((long)0L, (long)cbaos.getCurrentIndex());
        cbaos.setByte(0L, (byte)7);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        cbaos.writeTo((OutputStream)baos);
        Assert.assertEquals((long)7L, (long)baos.toByteArray()[0]);
        cbaos = new CapacityByteArrayOutputStream(5, (ByteBufferAllocator)new DirectByteBufferAllocator());
        cbaos.write(10);
        cbaos.write(13);
        cbaos.write(15);
        cbaos.write(17);
        Assert.assertEquals((long)3L, (long)cbaos.getCurrentIndex());
        cbaos.write(19);
        cbaos.setByte(3L, (byte)7);
        baos = new ByteArrayOutputStream();
        cbaos.writeTo((OutputStream)baos);
        Assert.assertArrayEquals((byte[])new byte[]{10, 13, 15, 7, 19}, (byte[])baos.toByteArray());
        cbaos = new CapacityByteArrayOutputStream(5, (ByteBufferAllocator)new DirectByteBufferAllocator());
        for (int i = 0; i < 12; ++i) {
            cbaos.write(100 + i);
        }
        Assert.assertEquals((long)11L, (long)cbaos.getCurrentIndex());
        cbaos.setByte(6L, (byte)7);
        baos = new ByteArrayOutputStream();
        cbaos.writeTo((OutputStream)baos);
        Assert.assertArrayEquals((byte[])new byte[]{100, 101, 102, 103, 104, 105, 7, 107, 108, 109, 110, 111}, (byte[])baos.toByteArray());
        cbaos = new CapacityByteArrayOutputStream(5, (ByteBufferAllocator)new DirectByteBufferAllocator());
        for (int i = 0; i < 12; ++i) {
            cbaos.write(100 + i);
        }
        Assert.assertEquals((long)11L, (long)cbaos.getCurrentIndex());
        cbaos.setByte(9L, (byte)7);
        baos = new ByteArrayOutputStream();
        cbaos.writeTo((OutputStream)baos);
        Assert.assertArrayEquals((byte[])new byte[]{100, 101, 102, 103, 104, 105, 106, 107, 108, 7, 110, 111}, (byte[])baos.toByteArray());
        cbaos = new CapacityByteArrayOutputStream(5, (ByteBufferAllocator)new DirectByteBufferAllocator());
        for (int i = 0; i < 12; ++i) {
            cbaos.write(100 + i);
        }
        Assert.assertEquals((long)11L, (long)cbaos.getCurrentIndex());
        cbaos.setByte(11L, (byte)7);
        baos = new ByteArrayOutputStream();
        cbaos.writeTo((OutputStream)baos);
        Assert.assertArrayEquals((byte[])new byte[]{100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 7}, (byte[])baos.toByteArray());
    }

    private void writeArraysOf3(CapacityByteArrayOutputStream capacityByteArrayOutputStream, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            byte[] toWrite = new byte[]{(byte)(i * 3), (byte)(i * 3 + 1), (byte)(i * 3 + 2)};
            capacityByteArrayOutputStream.write(toWrite);
            Assert.assertEquals((long)((i + 1) * 3), (long)capacityByteArrayOutputStream.size());
        }
    }

    private void validate(CapacityByteArrayOutputStream capacityByteArrayOutputStream, int expectedSize) throws IOException {
        byte[] byteArray = BytesInput.from((CapacityByteArrayOutputStream)capacityByteArrayOutputStream).toByteArray();
        Assert.assertEquals((long)expectedSize, (long)byteArray.length);
        for (int i = 0; i < expectedSize; ++i) {
            Assert.assertEquals((long)i, (long)byteArray[i]);
        }
    }
}

