/*
 * Decompiled with CFR 0.152.
 */
package parquet.column.values.bitpacking;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Test;
import parquet.Log;
import parquet.column.values.bitpacking.BitPacking;
import parquet.column.values.bitpacking.BytePacker;
import parquet.column.values.bitpacking.IntPacker;
import parquet.column.values.bitpacking.Packer;
import parquet.column.values.bitpacking.TestBitPacking;

public class TestLemireBitPacking {
    private static final Log LOG = Log.getLog(TestLemireBitPacking.class);

    @Test
    public void testPackUnPack() {
        Packer[] packerArray = Packer.values();
        int n = packerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Packer packer = packerArray[n2];
            LOG.debug((Object)"");
            LOG.debug((Object)"testPackUnPack");
            int i = 1;
            while (i < 32) {
                LOG.debug((Object)("Width: " + i));
                int[] values = this.generateValues(i);
                int[] unpacked = new int[32];
                this.packUnpack(packer.newIntPacker(i), values, unpacked);
                LOG.debug((Object)("int based Output " + packer.name() + ": " + TestBitPacking.toString(unpacked)));
                Assert.assertArrayEquals((String)(String.valueOf(packer.name()) + " width " + i), (int[])values, (int[])unpacked);
                this.packUnpack(packer.newBytePacker(i), values, unpacked);
                LOG.debug((Object)("byte based Output " + packer.name() + ": " + TestBitPacking.toString(unpacked)));
                Assert.assertArrayEquals((String)(String.valueOf(packer.name()) + " width " + i), (int[])values, (int[])unpacked);
                ++i;
            }
            ++n2;
        }
    }

    private void packUnpack(IntPacker packer, int[] values, int[] unpacked) {
        int[] packed = new int[packer.getBitWidth()];
        packer.pack32Values(values, 0, packed, 0);
        packer.unpack32Values(packed, 0, unpacked, 0);
    }

    private void packUnpack(BytePacker packer, int[] values, int[] unpacked) {
        byte[] packed = new byte[packer.getBitWidth() * 4];
        packer.pack32Values(values, 0, packed, 0);
        packer.unpack32Values(ByteBuffer.wrap(packed), 0, unpacked, 0);
    }

    private int[] generateValues(int bitWidth) {
        int[] values = new int[32];
        int j = 0;
        while (j < values.length) {
            values[j] = (int)(Math.random() * 100000.0) % (int)Math.pow(2.0, bitWidth);
            ++j;
        }
        LOG.debug((Object)("Input:  " + TestBitPacking.toString(values)));
        return values;
    }

    @Test
    public void testPackUnPackAgainstHandWritten() throws IOException {
        LOG.debug((Object)"");
        LOG.debug((Object)"testPackUnPackAgainstHandWritten");
        int i = 1;
        while (i < 8) {
            LOG.debug((Object)("Width: " + i));
            int[] packed = new int[i];
            int[] unpacked = new int[32];
            int[] values = this.generateValues(i);
            IntPacker packer = Packer.BIG_ENDIAN.newIntPacker(i);
            packer.pack32Values(values, 0, packed, 0);
            ByteArrayOutputStream lemireOut = new ByteArrayOutputStream();
            int[] nArray = packed;
            int n = packed.length;
            int n2 = 0;
            while (n2 < n) {
                int v = nArray[n2];
                lemireOut.write(v >>> 24 & 0xFF);
                lemireOut.write(v >>> 16 & 0xFF);
                lemireOut.write(v >>> 8 & 0xFF);
                lemireOut.write(v >>> 0 & 0xFF);
                ++n2;
            }
            byte[] packedByLemireAsBytes = lemireOut.toByteArray();
            LOG.debug((Object)("Lemire: " + TestBitPacking.toString(packedByLemireAsBytes)));
            ByteArrayOutputStream manualOut = new ByteArrayOutputStream();
            BitPacking.BitPackingWriter writer = BitPacking.getBitPackingWriter((int)i, (OutputStream)manualOut);
            int j = 0;
            while (j < values.length) {
                writer.write(values[j]);
                ++j;
            }
            byte[] packedManualAsBytes = manualOut.toByteArray();
            LOG.debug((Object)("Manual: " + TestBitPacking.toString(packedManualAsBytes)));
            BitPacking.BitPackingReader reader = BitPacking.createBitPackingReader((int)i, (InputStream)new ByteArrayInputStream(packedByLemireAsBytes), (long)32L);
            int j2 = 0;
            while (j2 < unpacked.length) {
                unpacked[j2] = reader.read();
                ++j2;
            }
            LOG.debug((Object)("Output: " + TestBitPacking.toString(unpacked)));
            Assert.assertArrayEquals((String)("width " + i), (int[])values, (int[])unpacked);
            ++i;
        }
    }
}

