/*
 * Decompiled with CFR 0.152.
 */
package parquet.column.values.bitpacking;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.junit.Assert;
import org.junit.Test;
import parquet.Log;
import parquet.column.values.bitpacking.BitPacking;

public class TestBitPacking {
    private static final Log LOG = Log.getLog(TestBitPacking.class);

    @Test
    public void testZero() throws IOException {
        int bitLength = 0;
        int[] vals = new int[10];
        String expected = "";
        this.validateEncodeDecode(bitLength, vals, expected);
    }

    @Test
    public void testOne_0() throws IOException {
        int[] vals = new int[1];
        String expected = "00000000";
        this.validateEncodeDecode(1, vals, expected);
    }

    @Test
    public void testOne_1() throws IOException {
        int[] vals = new int[]{1};
        String expected = "10000000";
        this.validateEncodeDecode(1, vals, expected);
    }

    @Test
    public void testOne_0_0() throws IOException {
        int[] vals = new int[2];
        String expected = "00000000";
        this.validateEncodeDecode(1, vals, expected);
    }

    @Test
    public void testOne_1_1() throws IOException {
        int[] vals = new int[]{1, 1};
        String expected = "11000000";
        this.validateEncodeDecode(1, vals, expected);
    }

    @Test
    public void testOne_9_1s() throws IOException {
        int[] vals = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1};
        String expected = "11111111 10000000";
        this.validateEncodeDecode(1, vals, expected);
    }

    @Test
    public void testOne_9_0s() throws IOException {
        int[] vals = new int[9];
        String expected = "00000000 00000000";
        this.validateEncodeDecode(1, vals, expected);
    }

    @Test
    public void testOne_7_0s_1_1() throws IOException {
        int[] nArray = new int[8];
        nArray[7] = 1;
        int[] vals = nArray;
        String expected = "00000001";
        this.validateEncodeDecode(1, vals, expected);
    }

    @Test
    public void testOne_9_0s_1_1() throws IOException {
        int[] nArray = new int[10];
        nArray[9] = 1;
        int[] vals = nArray;
        String expected = "00000000 01000000";
        this.validateEncodeDecode(1, vals, expected);
    }

    @Test
    public void testOne() throws IOException {
        int[] nArray = new int[10];
        nArray[1] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = 1;
        nArray[9] = 1;
        int[] vals = nArray;
        String expected = "01001110 01000000";
        this.validateEncodeDecode(1, vals, expected);
    }

    @Test
    public void testTwo() throws IOException {
        int[] nArray = new int[13];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 3;
        nArray[5] = 3;
        nArray[6] = 2;
        nArray[7] = 1;
        nArray[8] = 1;
        nArray[12] = 1;
        int[] vals = nArray;
        String expected = "00011011 11111001 01000000 01000000";
        this.validateEncodeDecode(2, vals, expected);
    }

    @Test
    public void testThree() throws IOException {
        int[] nArray = new int[9];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 7;
        nArray[8] = 1;
        int[] vals = nArray;
        String expected = "00000101 00111001 01110111 00100000";
        this.validateEncodeDecode(3, vals, expected);
    }

    @Test
    public void testFour() throws IOException {
        int[] nArray = new int[17];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 7;
        nArray[8] = 8;
        nArray[9] = 9;
        nArray[10] = 10;
        nArray[11] = 11;
        nArray[12] = 12;
        nArray[13] = 13;
        nArray[14] = 14;
        nArray[15] = 15;
        nArray[16] = 1;
        int[] vals = nArray;
        String expected = "00000001 00100011 01000101 01100111 10001001 10101011 11001101 11101111 00010000";
        this.validateEncodeDecode(4, vals, expected);
    }

    @Test
    public void testFive() throws IOException {
        int[] nArray = new int[33];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        nArray[7] = 7;
        nArray[8] = 8;
        nArray[9] = 9;
        nArray[10] = 10;
        nArray[11] = 11;
        nArray[12] = 12;
        nArray[13] = 13;
        nArray[14] = 14;
        nArray[15] = 15;
        nArray[16] = 16;
        nArray[17] = 17;
        nArray[18] = 18;
        nArray[19] = 19;
        nArray[20] = 20;
        nArray[21] = 21;
        nArray[22] = 22;
        nArray[23] = 23;
        nArray[24] = 24;
        nArray[25] = 25;
        nArray[26] = 26;
        nArray[27] = 27;
        nArray[28] = 28;
        nArray[29] = 29;
        nArray[30] = 30;
        nArray[31] = 31;
        nArray[32] = 1;
        int[] vals = nArray;
        String expected = "00000000 01000100 00110010 00010100 11000111 01000010 01010100 10110110 00110101 11001111 10000100 01100101 00111010 01010110 11010111 11000110 01110101 10111110 01110111 11011111 00001000";
        this.validateEncodeDecode(5, vals, expected);
    }

    @Test
    public void testSix() throws IOException {
        int[] nArray = new int[6];
        nArray[1] = 28;
        nArray[2] = 34;
        nArray[3] = 35;
        nArray[4] = 63;
        nArray[5] = 1;
        int[] vals = nArray;
        String expected = "00000001 11001000 10100011 11111100 00010000";
        this.validateEncodeDecode(6, vals, expected);
    }

    @Test
    public void testSeven() throws IOException {
        int[] nArray = new int[9];
        nArray[1] = 28;
        nArray[2] = 34;
        nArray[3] = 35;
        nArray[4] = 63;
        nArray[5] = 1;
        nArray[6] = 125;
        nArray[7] = 1;
        nArray[8] = 1;
        int[] vals = nArray;
        String expected = "00000000 01110001 00010010 00110111 11100000 01111110 10000001 00000010";
        this.validateEncodeDecode(7, vals, expected);
    }

    private void validateEncodeDecode(int bitLength, int[] vals, String expected) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BitPacking.BitPackingWriter w = BitPacking.getBitPackingWriter((int)bitLength, (OutputStream)baos);
        int[] nArray = vals;
        int n = vals.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            w.write(i);
            ++n2;
        }
        w.finish();
        byte[] bytes = baos.toByteArray();
        LOG.debug((Object)("vals (" + bitLength + "): " + TestBitPacking.toString(vals)));
        LOG.debug((Object)("bytes: " + TestBitPacking.toString(bytes)));
        Assert.assertEquals((Object)expected, (Object)TestBitPacking.toString(bytes));
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        BitPacking.BitPackingReader r = BitPacking.createBitPackingReader((int)bitLength, (InputStream)bais, (long)vals.length);
        int[] result = new int[vals.length];
        int i = 0;
        while (i < result.length) {
            result[i] = r.read();
            ++i;
        }
        LOG.debug((Object)("result: " + TestBitPacking.toString(result)));
        Assert.assertArrayEquals((int[])vals, (int[])result);
    }

    public static String toString(int[] vals) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        int[] nArray = vals;
        int n = vals.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            if (first) {
                first = false;
            } else {
                sb.append(" ");
            }
            sb.append(i);
            ++n2;
        }
        return sb.toString();
    }

    public static String toString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            int b = byArray[n2];
            if (first) {
                first = false;
            } else {
                sb.append(" ");
            }
            int i = b < 0 ? 256 + b : b;
            String binaryString = Integer.toBinaryString(i);
            int j = binaryString.length();
            while (j < 8) {
                sb.append("0");
                ++j;
            }
            sb.append(binaryString);
            ++n2;
        }
        return sb.toString();
    }
}

