/*
 * Decompiled with CFR 0.152.
 */
package parquet.column.values.bitpacking;

import java.io.IOException;
import java.io.OutputStream;
import parquet.column.values.bitpacking.BitPacking;

abstract class BaseBitPackingWriter
extends BitPacking.BitPackingWriter {
    BaseBitPackingWriter() {
    }

    void finish(int numberOfBits, int buffer, OutputStream out) throws IOException {
        int padding = numberOfBits % 8 == 0 ? 0 : 8 - numberOfBits % 8;
        buffer <<= padding;
        int numberOfBytes = (numberOfBits + padding) / 8;
        int i = (numberOfBytes - 1) * 8;
        while (i >= 0) {
            out.write(buffer >>> i & 0xFF);
            i -= 8;
        }
    }

    void finish(int numberOfBits, long buffer, OutputStream out) throws IOException {
        int padding = numberOfBits % 8 == 0 ? 0 : 8 - numberOfBits % 8;
        buffer <<= padding;
        int numberOfBytes = (numberOfBits + padding) / 8;
        int i = (numberOfBytes - 1) * 8;
        while (i >= 0) {
            out.write((int)(buffer >>> i) & 0xFF);
            i -= 8;
        }
    }
}

