/*
 * Decompiled with CFR 0.152.
 */
package parquet.column.values.bitpacking;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Test;
import parquet.Log;
import parquet.column.values.bitpacking.BitPacking;
import parquet.column.values.bitpacking.BytePacker;
import parquet.column.values.bitpacking.IntPacker;
import parquet.column.values.bitpacking.Packer;
import parquet.column.values.bitpacking.TestBitPacking;

public class TestByteBitPacking {
    private static final Log LOG = Log.getLog(TestByteBitPacking.class);

    @Test
    public void testPackUnPack() {
        LOG.debug((Object)"");
        LOG.debug((Object)"testPackUnPack");
        for (int i = 1; i < 32; ++i) {
            LOG.debug((Object)("Width: " + i));
            int[] unpacked = new int[32];
            int[] values = this.generateValues(i);
            this.packUnpack(Packer.BIG_ENDIAN.newBytePacker(i), values, unpacked);
            LOG.debug((Object)("Output: " + TestBitPacking.toString(unpacked)));
            Assert.assertArrayEquals((String)("width " + i), (int[])values, (int[])unpacked);
        }
    }

    private void packUnpack(BytePacker packer, int[] values, int[] unpacked) {
        byte[] packed = new byte[packer.getBitWidth() * 4];
        packer.pack32Values(values, 0, packed, 0);
        LOG.debug((Object)("packed: " + TestBitPacking.toString(packed)));
        packer.unpack32Values(ByteBuffer.wrap(packed), 0, unpacked, 0);
    }

    private int[] generateValues(int bitWidth) {
        int[] values = new int[32];
        for (int j = 0; j < values.length; ++j) {
            values[j] = (int)(Math.random() * 100000.0) % (int)Math.pow(2.0, bitWidth);
        }
        LOG.debug((Object)("Input:  " + TestBitPacking.toString(values)));
        return values;
    }

    @Test
    public void testPackUnPackAgainstHandWritten() throws IOException {
        LOG.debug((Object)"");
        LOG.debug((Object)"testPackUnPackAgainstHandWritten");
        for (int i = 1; i < 8; ++i) {
            LOG.debug((Object)("Width: " + i));
            byte[] packed = new byte[i * 4];
            int[] unpacked = new int[32];
            int[] values = this.generateValues(i);
            BytePacker packer = Packer.BIG_ENDIAN.newBytePacker(i);
            packer.pack32Values(values, 0, packed, 0);
            LOG.debug((Object)("Generated: " + TestBitPacking.toString(packed)));
            ByteArrayOutputStream manualOut = new ByteArrayOutputStream();
            BitPacking.BitPackingWriter writer = BitPacking.getBitPackingWriter((int)i, (OutputStream)manualOut);
            for (int j = 0; j < values.length; ++j) {
                writer.write(values[j]);
            }
            byte[] packedManualAsBytes = manualOut.toByteArray();
            LOG.debug((Object)("Manual: " + TestBitPacking.toString(packedManualAsBytes)));
            BitPacking.BitPackingReader reader = BitPacking.createBitPackingReader((int)i, (InputStream)new ByteArrayInputStream(packed), (long)32L);
            for (int j = 0; j < unpacked.length; ++j) {
                unpacked[j] = reader.read();
            }
            LOG.debug((Object)("Output: " + TestBitPacking.toString(unpacked)));
            Assert.assertArrayEquals((String)("width " + i), (int[])values, (int[])unpacked);
        }
    }

    @Test
    public void testPackUnPackAgainstLemire() throws IOException {
        for (Packer pack : Packer.values()) {
            LOG.debug((Object)"");
            LOG.debug((Object)("testPackUnPackAgainstLemire " + pack.name()));
            for (int i = 1; i < 32; ++i) {
                LOG.debug((Object)("Width: " + i));
                int[] packed = new int[i];
                int[] unpacked = new int[32];
                int[] values = this.generateValues(i);
                IntPacker packer = pack.newIntPacker(i);
                packer.pack32Values(values, 0, packed, 0);
                ByteArrayOutputStream lemireOut = new ByteArrayOutputStream();
                block6: for (int v : packed) {
                    switch (pack) {
                        case LITTLE_ENDIAN: {
                            lemireOut.write(v >>> 0 & 0xFF);
                            lemireOut.write(v >>> 8 & 0xFF);
                            lemireOut.write(v >>> 16 & 0xFF);
                            lemireOut.write(v >>> 24 & 0xFF);
                            continue block6;
                        }
                        case BIG_ENDIAN: {
                            lemireOut.write(v >>> 24 & 0xFF);
                            lemireOut.write(v >>> 16 & 0xFF);
                            lemireOut.write(v >>> 8 & 0xFF);
                            lemireOut.write(v >>> 0 & 0xFF);
                        }
                    }
                }
                byte[] packedByLemireAsBytes = lemireOut.toByteArray();
                LOG.debug((Object)("Lemire out: " + TestBitPacking.toString(packedByLemireAsBytes)));
                BytePacker bytePacker = pack.newBytePacker(i);
                byte[] packedGenerated = new byte[i * 4];
                bytePacker.pack32Values(values, 0, packedGenerated, 0);
                LOG.debug((Object)("Gener. out: " + TestBitPacking.toString(packedGenerated)));
                Assert.assertEquals((String)(pack.name() + " width " + i), (Object)TestBitPacking.toString(packedByLemireAsBytes), (Object)TestBitPacking.toString(packedGenerated));
                bytePacker.unpack32Values(ByteBuffer.wrap(packedByLemireAsBytes), 0, unpacked, 0);
                LOG.debug((Object)("Output: " + TestBitPacking.toString(unpacked)));
                Assert.assertArrayEquals((String)("width " + i), (int[])values, (int[])unpacked);
            }
        }
    }
}

