/*
 * Decompiled with CFR 0.152.
 */
package parquet.column.values.bitpacking;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.junit.Assert;
import org.junit.Test;
import parquet.Log;
import parquet.column.values.bitpacking.BitPacking;

public class TestBitPacking {
    private static final Log LOG = Log.getLog(TestBitPacking.class);

    @Test
    public void testZero() throws IOException {
        int bitLength = 0;
        int[] vals = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        String expected = "";
        this.validateEncodeDecode(bitLength, vals, expected);
    }

    @Test
    public void testOne_0() throws IOException {
        int[] vals = new int[]{0};
        String expected = "00000000";
        this.validateEncodeDecode(1, vals, expected);
    }

    @Test
    public void testOne_1() throws IOException {
        int[] vals = new int[]{1};
        String expected = "10000000";
        this.validateEncodeDecode(1, vals, expected);
    }

    @Test
    public void testOne_0_0() throws IOException {
        int[] vals = new int[]{0, 0};
        String expected = "00000000";
        this.validateEncodeDecode(1, vals, expected);
    }

    @Test
    public void testOne_1_1() throws IOException {
        int[] vals = new int[]{1, 1};
        String expected = "11000000";
        this.validateEncodeDecode(1, vals, expected);
    }

    @Test
    public void testOne_9_1s() throws IOException {
        int[] vals = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1};
        String expected = "11111111 10000000";
        this.validateEncodeDecode(1, vals, expected);
    }

    @Test
    public void testOne_9_0s() throws IOException {
        int[] vals = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
        String expected = "00000000 00000000";
        this.validateEncodeDecode(1, vals, expected);
    }

    @Test
    public void testOne_7_0s_1_1() throws IOException {
        int[] vals = new int[]{0, 0, 0, 0, 0, 0, 0, 1};
        String expected = "00000001";
        this.validateEncodeDecode(1, vals, expected);
    }

    @Test
    public void testOne_9_0s_1_1() throws IOException {
        int[] vals = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
        String expected = "00000000 01000000";
        this.validateEncodeDecode(1, vals, expected);
    }

    @Test
    public void testOne() throws IOException {
        int[] vals = new int[]{0, 1, 0, 0, 1, 1, 1, 0, 0, 1};
        String expected = "01001110 01000000";
        this.validateEncodeDecode(1, vals, expected);
    }

    @Test
    public void testTwo() throws IOException {
        int[] vals = new int[]{0, 1, 2, 3, 3, 3, 2, 1, 1, 0, 0, 0, 1};
        String expected = "00011011 11111001 01000000 01000000";
        this.validateEncodeDecode(2, vals, expected);
    }

    @Test
    public void testThree() throws IOException {
        int[] vals = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 1};
        String expected = "00000101 00111001 01110111 00100000";
        this.validateEncodeDecode(3, vals, expected);
    }

    @Test
    public void testFour() throws IOException {
        int[] vals = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 1};
        String expected = "00000001 00100011 01000101 01100111 10001001 10101011 11001101 11101111 00010000";
        this.validateEncodeDecode(4, vals, expected);
    }

    @Test
    public void testFive() throws IOException {
        int[] vals = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 1};
        String expected = "00000000 01000100 00110010 00010100 11000111 01000010 01010100 10110110 00110101 11001111 10000100 01100101 00111010 01010110 11010111 11000110 01110101 10111110 01110111 11011111 00001000";
        this.validateEncodeDecode(5, vals, expected);
    }

    @Test
    public void testSix() throws IOException {
        int[] vals = new int[]{0, 28, 34, 35, 63, 1};
        String expected = "00000001 11001000 10100011 11111100 00010000";
        this.validateEncodeDecode(6, vals, expected);
    }

    @Test
    public void testSeven() throws IOException {
        int[] vals = new int[]{0, 28, 34, 35, 63, 1, 125, 1, 1};
        String expected = "00000000 01110001 00010010 00110111 11100000 01111110 10000001 00000010";
        this.validateEncodeDecode(7, vals, expected);
    }

    private void validateEncodeDecode(int bitLength, int[] vals, String expected) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BitPacking.BitPackingWriter w = BitPacking.getBitPackingWriter((int)bitLength, (OutputStream)baos);
        for (int i : vals) {
            w.write(i);
        }
        w.finish();
        byte[] bytes = baos.toByteArray();
        LOG.debug((Object)("vals (" + bitLength + "): " + TestBitPacking.toString(vals)));
        LOG.debug((Object)("bytes: " + TestBitPacking.toString(bytes)));
        Assert.assertEquals((Object)expected, (Object)TestBitPacking.toString(bytes));
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        BitPacking.BitPackingReader r = BitPacking.createBitPackingReader((int)bitLength, (InputStream)bais, (long)vals.length);
        int[] result = new int[vals.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = r.read();
        }
        LOG.debug((Object)("result: " + TestBitPacking.toString(result)));
        Assert.assertArrayEquals((int[])vals, (int[])result);
    }

    public static String toString(int[] vals) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (int i : vals) {
            if (first) {
                first = false;
            } else {
                sb.append(" ");
            }
            sb.append(i);
        }
        return sb.toString();
    }

    public static String toString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (int n : bytes) {
            if (first) {
                first = false;
            } else {
                sb.append(" ");
            }
            int i = n < 0 ? 256 + n : n;
            String binaryString = Integer.toBinaryString(i);
            for (int j = binaryString.length(); j < 8; ++j) {
                sb.append("0");
            }
            sb.append(binaryString);
        }
        return sb.toString();
    }
}

