/*
 * Decompiled with CFR 0.152.
 */
package parquet.cascading;

import cascading.flow.FlowProcess;
import cascading.tap.Tap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.thrift.TBase;
import parquet.cascading.ParquetValueScheme;
import parquet.filter2.predicate.FilterPredicate;
import parquet.hadoop.ParquetInputFormat;
import parquet.hadoop.mapred.DeprecatedParquetInputFormat;
import parquet.hadoop.mapred.DeprecatedParquetOutputFormat;
import parquet.hadoop.thrift.TBaseWriteSupport;
import parquet.hadoop.thrift.ThriftReadSupport;
import parquet.thrift.TBaseRecordConverter;

public class ParquetTBaseScheme<T extends TBase<?, ?>>
extends ParquetValueScheme<T> {
    public ParquetTBaseScheme() {
        this(new ParquetValueScheme.Config());
    }

    public ParquetTBaseScheme(Class<T> thriftClass) {
        this(new ParquetValueScheme.Config<T>().withRecordClass(thriftClass));
    }

    public ParquetTBaseScheme(FilterPredicate filterPredicate) {
        this(new ParquetValueScheme.Config().withFilterPredicate(filterPredicate));
    }

    public ParquetTBaseScheme(FilterPredicate filterPredicate, Class<T> thriftClass) {
        this(new ParquetValueScheme.Config<T>().withRecordClass(thriftClass).withFilterPredicate(filterPredicate));
    }

    public ParquetTBaseScheme(ParquetValueScheme.Config<T> config) {
        super(config);
    }

    @Override
    public void sourceConfInit(FlowProcess<JobConf> fp, Tap<JobConf, RecordReader, OutputCollector> tap, JobConf jobConf) {
        super.sourceConfInit(fp, tap, jobConf);
        jobConf.setInputFormat(DeprecatedParquetInputFormat.class);
        ParquetInputFormat.setReadSupportClass((JobConf)jobConf, ThriftReadSupport.class);
        ThriftReadSupport.setRecordConverterClass((JobConf)jobConf, TBaseRecordConverter.class);
    }

    public void sinkConfInit(FlowProcess<JobConf> fp, Tap<JobConf, RecordReader, OutputCollector> tap, JobConf jobConf) {
        if (this.config.getKlass() == null) {
            throw new IllegalArgumentException("To use ParquetTBaseScheme as a sink, you must specify a thrift class in the constructor");
        }
        jobConf.setOutputFormat(DeprecatedParquetOutputFormat.class);
        DeprecatedParquetOutputFormat.setWriteSupportClass((Configuration)jobConf, TBaseWriteSupport.class);
        TBaseWriteSupport.setThriftClass((Configuration)jobConf, this.config.getKlass());
    }
}

