/*
 * Decompiled with CFR 0.152.
 */
package parquet.cascading;

import cascading.flow.FlowProcess;
import cascading.scheme.Scheme;
import cascading.scheme.SinkCall;
import cascading.scheme.SourceCall;
import cascading.tap.Tap;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import parquet.Preconditions;
import parquet.filter2.predicate.FilterPredicate;
import parquet.hadoop.ParquetInputFormat;
import parquet.hadoop.mapred.Container;
import parquet.hadoop.thrift.ParquetThriftInputFormat;
import parquet.hadoop.thrift.ThriftReadSupport;

public abstract class ParquetValueScheme<T>
extends Scheme<JobConf, RecordReader, OutputCollector, Object[], Object[]> {
    private static final long serialVersionUID = 157560846420730043L;
    protected final Config<T> config;

    public ParquetValueScheme() {
        this(new Config());
    }

    public ParquetValueScheme(FilterPredicate filterPredicate) {
        this(new Config().withFilterPredicate(filterPredicate));
    }

    public ParquetValueScheme(Config<T> config) {
        this.config = config;
    }

    private void setProjectionPushdown(JobConf jobConf) {
        if (((Config)this.config).projectionString != null) {
            ThriftReadSupport.setProjectionPushdown((JobConf)jobConf, (String)((Config)this.config).projectionString);
        }
    }

    private void setPredicatePushdown(JobConf jobConf) {
        if (((Config)this.config).filterPredicate != null) {
            ParquetInputFormat.setFilterPredicate((Configuration)jobConf, (FilterPredicate)((Config)this.config).filterPredicate);
        }
    }

    public void sourceConfInit(FlowProcess<JobConf> jobConfFlowProcess, Tap<JobConf, RecordReader, OutputCollector> jobConfRecordReaderOutputCollectorTap, JobConf jobConf) {
        this.setPredicatePushdown(jobConf);
        this.setProjectionPushdown(jobConf);
        this.setRecordClass(jobConf);
    }

    private void setRecordClass(JobConf jobConf) {
        if (((Config)this.config).klass != null) {
            ParquetThriftInputFormat.setThriftClass((JobConf)jobConf, (Class)((Config)this.config).klass);
        }
    }

    public boolean source(FlowProcess<JobConf> fp, SourceCall<Object[], RecordReader> sc) throws IOException {
        Container value = (Container)((RecordReader)sc.getInput()).createValue();
        boolean hasNext = ((RecordReader)sc.getInput()).next(null, (Object)value);
        if (!hasNext) {
            return false;
        }
        if (value == null) {
            return true;
        }
        sc.getIncomingEntry().setTuple(new Tuple(new Object[]{value.get()}));
        return true;
    }

    public void sink(FlowProcess<JobConf> fp, SinkCall<Object[], OutputCollector> sc) throws IOException {
        TupleEntry tuple = sc.getOutgoingEntry();
        if (tuple.size() != 1) {
            throw new RuntimeException("ParquetValueScheme expects tuples with an arity of exactly 1, but found " + tuple.getFields());
        }
        Object value = tuple.getObject(0);
        OutputCollector output = (OutputCollector)sc.getOutput();
        output.collect(null, value);
    }

    public static final class Config<T>
    implements Serializable {
        private final FilterPredicate filterPredicate;
        private final String projectionString;
        private final Class<T> klass;

        private Config(Class<T> klass, FilterPredicate filterPredicate, String projectionString) {
            this.filterPredicate = filterPredicate;
            this.projectionString = projectionString;
            this.klass = klass;
        }

        public Config() {
            this.filterPredicate = null;
            this.projectionString = null;
            this.klass = null;
        }

        public FilterPredicate getFilterPredicate() {
            return this.filterPredicate;
        }

        public String getProjectionString() {
            return this.projectionString;
        }

        public Class<T> getKlass() {
            return this.klass;
        }

        public Config<T> withFilterPredicate(FilterPredicate f) {
            return new Config<T>(this.klass, (FilterPredicate)Preconditions.checkNotNull((Object)f, (String)"filterPredicate"), this.projectionString);
        }

        public Config<T> withProjectionString(String p) {
            return new Config<T>(this.klass, this.filterPredicate, (String)Preconditions.checkNotNull((Object)p, (String)"projectionFilter"));
        }

        public Config<T> withRecordClass(Class<T> klass) {
            return new Config<T>((Class)Preconditions.checkNotNull(klass, (String)"recordClass"), this.filterPredicate, this.projectionString);
        }
    }
}

