/*
 * Decompiled with CFR 0.152.
 */
package parquet.cascading.convert;

import cascading.tuple.Tuple;
import parquet.io.api.Binary;
import parquet.io.api.Converter;
import parquet.io.api.GroupConverter;
import parquet.io.api.PrimitiveConverter;
import parquet.schema.GroupType;
import parquet.schema.Type;

public class TupleConverter
extends GroupConverter {
    protected Tuple currentTuple;
    private final Converter[] converters;

    public TupleConverter(GroupType parquetSchema) {
        int schemaSize = parquetSchema.getFieldCount();
        this.converters = new Converter[schemaSize];
        for (int i = 0; i < schemaSize; ++i) {
            Type type = parquetSchema.getType(i);
            this.converters[i] = this.newConverter(type, i);
        }
    }

    private Converter newConverter(Type type, int i) {
        if (!type.isPrimitive()) {
            throw new IllegalArgumentException("cascading can only build tuples from primitive types");
        }
        return new TuplePrimitiveConverter(this, i);
    }

    public Converter getConverter(int fieldIndex) {
        return this.converters[fieldIndex];
    }

    public final void start() {
        this.currentTuple = Tuple.size((int)this.converters.length);
    }

    public void end() {
    }

    public final Tuple getCurrentTuple() {
        return this.currentTuple;
    }

    static final class TuplePrimitiveConverter
    extends PrimitiveConverter {
        private final TupleConverter parent;
        private final int index;

        public TuplePrimitiveConverter(TupleConverter parent, int index) {
            this.parent = parent;
            this.index = index;
        }

        public void addBinary(Binary value) {
            this.parent.getCurrentTuple().setString(this.index, value.toStringUsingUTF8());
        }

        public void addBoolean(boolean value) {
            this.parent.getCurrentTuple().setBoolean(this.index, value);
        }

        public void addDouble(double value) {
            this.parent.getCurrentTuple().setDouble(this.index, value);
        }

        public void addFloat(float value) {
            this.parent.getCurrentTuple().setFloat(this.index, value);
        }

        public void addInt(int value) {
            this.parent.getCurrentTuple().setInteger(this.index, value);
        }

        public void addLong(long value) {
            this.parent.getCurrentTuple().setLong(this.index, value);
        }
    }
}

