/*
 * Decompiled with CFR 0.152.
 */
package parquet.cascading;

import cascading.flow.FlowProcess;
import cascading.tap.Tap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.thrift.TBase;
import parquet.cascading.ParquetValueScheme;
import parquet.hadoop.ParquetInputFormat;
import parquet.hadoop.mapred.DeprecatedParquetInputFormat;
import parquet.hadoop.mapred.DeprecatedParquetOutputFormat;
import parquet.hadoop.thrift.ParquetThriftInputFormat;
import parquet.hadoop.thrift.ThriftReadSupport;
import parquet.hadoop.thrift.ThriftWriteSupport;
import parquet.thrift.TBaseRecordConverter;

public class ParquetTBaseScheme<T extends TBase<?, ?>>
extends ParquetValueScheme<T> {
    private Class<T> thriftClass;

    public ParquetTBaseScheme() {
    }

    public ParquetTBaseScheme(Class<T> thriftClass) {
        this.thriftClass = thriftClass;
    }

    public void sourceConfInit(FlowProcess<JobConf> fp, Tap<JobConf, RecordReader, OutputCollector> tap, JobConf jobConf) {
        jobConf.setInputFormat(DeprecatedParquetInputFormat.class);
        ParquetInputFormat.setReadSupportClass((JobConf)jobConf, ThriftReadSupport.class);
        ThriftReadSupport.setRecordConverterClass((JobConf)jobConf, TBaseRecordConverter.class);
        if (this.thriftClass != null) {
            ParquetThriftInputFormat.setThriftClass((JobConf)jobConf, this.thriftClass);
        }
    }

    public void sinkConfInit(FlowProcess<JobConf> fp, Tap<JobConf, RecordReader, OutputCollector> tap, JobConf jobConf) {
        if (this.thriftClass == null) {
            throw new IllegalArgumentException("To use ParquetTBaseScheme as a sink, you must specify a thrift class in the constructor");
        }
        jobConf.setOutputFormat(DeprecatedParquetOutputFormat.class);
        DeprecatedParquetOutputFormat.setWriteSupportClass((Configuration)jobConf, ThriftWriteSupport.class);
        ThriftWriteSupport.setThriftClass((Configuration)jobConf, this.thriftClass);
    }
}

