/*
 * Decompiled with CFR 0.152.
 */
package parquet.cascading;

import cascading.tuple.Fields;
import java.util.ArrayList;
import parquet.schema.MessageType;
import parquet.schema.Type;

public class SchemaIntersection {
    private final MessageType requestedSchema;
    private final Fields sourceFields;

    public SchemaIntersection(MessageType fileSchema, Fields requestedFields) {
        if (requestedFields == Fields.UNKNOWN) {
            requestedFields = Fields.ALL;
        }
        Fields newFields = Fields.NONE;
        ArrayList<Type> newSchemaFields = new ArrayList<Type>();
        int schemaSize = fileSchema.getFieldCount();
        for (int i = 0; i < schemaSize; ++i) {
            Type type = fileSchema.getType(i);
            Fields name = new Fields(new Comparable[]{type.getName()});
            if (!requestedFields.contains(name)) continue;
            newFields = newFields.append(name);
            newSchemaFields.add(type);
        }
        this.sourceFields = newFields;
        this.requestedSchema = new MessageType(fileSchema.getName(), newSchemaFields);
    }

    public MessageType getRequestedSchema() {
        return this.requestedSchema;
    }

    public Fields getSourceFields() {
        return this.sourceFields;
    }
}

