/*
 * Decompiled with CFR 0.152.
 */
package parquet.cascading;

import cascading.flow.FlowProcess;
import cascading.scheme.Scheme;
import cascading.scheme.SinkCall;
import cascading.scheme.SourceCall;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import java.io.IOException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;
import parquet.hadoop.mapred.Container;

public abstract class ParquetValueScheme<T>
extends Scheme<JobConf, RecordReader, OutputCollector, Object[], Object[]> {
    private static final long serialVersionUID = 157560846420730043L;

    public boolean source(FlowProcess<JobConf> fp, SourceCall<Object[], RecordReader> sc) throws IOException {
        Container value = (Container)((RecordReader)sc.getInput()).createValue();
        boolean hasNext = ((RecordReader)sc.getInput()).next(null, (Object)value);
        if (!hasNext) {
            return false;
        }
        if (value == null) {
            return true;
        }
        sc.getIncomingEntry().setTuple(new Tuple(new Object[]{value.get()}));
        return true;
    }

    public void sink(FlowProcess<JobConf> fp, SinkCall<Object[], OutputCollector> sc) throws IOException {
        TupleEntry tuple = sc.getOutgoingEntry();
        if (tuple.size() != 1) {
            throw new RuntimeException("ParquetValueScheme expects tuples with an arity of exactly 1, but found " + tuple.getFields());
        }
        Object value = tuple.getObject(0);
        OutputCollector output = (OutputCollector)sc.getOutput();
        output.collect(null, value);
    }
}

