/*
 * Decompiled with CFR 0.152.
 */
package parquet.avro;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.junit.Test;
import parquet.avro.AvroParquetReader;
import parquet.avro.AvroParquetWriter;
import parquet.avro.AvroReadSupport;
import parquet.avro.Car;
import parquet.avro.Engine;
import parquet.avro.EngineType;
import parquet.avro.LeatherTrim;
import parquet.avro.NewCar;
import parquet.avro.Service;
import parquet.avro.Stereo;
import parquet.avro.Vin;
import parquet.filter.ColumnPredicates;
import parquet.filter.ColumnRecordFilter;
import parquet.hadoop.metadata.CompressionCodecName;

public class TestSpecificReadWrite {
    @Test
    public void testReadWriteSpecific() throws IOException {
        Path path = this.writeCarsToParquetFile(10, CompressionCodecName.UNCOMPRESSED, false);
        AvroParquetReader reader = new AvroParquetReader(path);
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((Object)TestSpecificReadWrite.getVwPolo().toString(), (Object)((Car)((Object)reader.read())).toString());
            Assert.assertEquals((Object)TestSpecificReadWrite.getVwPassat().toString(), (Object)((Car)((Object)reader.read())).toString());
            Assert.assertEquals((Object)TestSpecificReadWrite.getBmwMini().toString(), (Object)((Car)((Object)reader.read())).toString());
        }
        Assert.assertNull((Object)reader.read());
    }

    @Test
    public void testReadWriteSpecificWithDictionary() throws IOException {
        Path path = this.writeCarsToParquetFile(10, CompressionCodecName.UNCOMPRESSED, true);
        AvroParquetReader reader = new AvroParquetReader(path);
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((Object)TestSpecificReadWrite.getVwPolo().toString(), (Object)((Car)((Object)reader.read())).toString());
            Assert.assertEquals((Object)TestSpecificReadWrite.getVwPassat().toString(), (Object)((Car)((Object)reader.read())).toString());
            Assert.assertEquals((Object)TestSpecificReadWrite.getBmwMini().toString(), (Object)((Car)((Object)reader.read())).toString());
        }
        Assert.assertNull((Object)reader.read());
    }

    @Test
    public void testFilterMatchesMultiple() throws IOException {
        Path path = this.writeCarsToParquetFile(10, CompressionCodecName.UNCOMPRESSED, false);
        AvroParquetReader reader = new AvroParquetReader(path, ColumnRecordFilter.column((String)"make", (ColumnPredicates.Predicate)ColumnPredicates.equalTo((String)"Volkswagen")));
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((Object)TestSpecificReadWrite.getVwPolo().toString(), (Object)((Car)((Object)reader.read())).toString());
            Assert.assertEquals((Object)TestSpecificReadWrite.getVwPassat().toString(), (Object)((Car)((Object)reader.read())).toString());
        }
        Assert.assertNull((Object)reader.read());
    }

    @Test
    public void testFilterMatchesMultipleBlocks() throws IOException {
        Path path = this.writeCarsToParquetFile(10000, CompressionCodecName.UNCOMPRESSED, false, 0x200000, 16384);
        AvroParquetReader reader = new AvroParquetReader(path, ColumnRecordFilter.column((String)"make", (ColumnPredicates.Predicate)ColumnPredicates.equalTo((String)"Volkswagen")));
        for (int i = 0; i < 10000; ++i) {
            Assert.assertEquals((Object)TestSpecificReadWrite.getVwPolo().toString(), (Object)((Car)((Object)reader.read())).toString());
            Assert.assertEquals((Object)TestSpecificReadWrite.getVwPassat().toString(), (Object)((Car)((Object)reader.read())).toString());
        }
        Assert.assertNull((Object)reader.read());
    }

    @Test
    public void testFilterMatchesNoBlocks() throws IOException {
        Path path = this.writeCarsToParquetFile(10000, CompressionCodecName.UNCOMPRESSED, false, 0x200000, 16384);
        AvroParquetReader reader = new AvroParquetReader(path, ColumnRecordFilter.column((String)"make", (ColumnPredicates.Predicate)ColumnPredicates.equalTo((String)"Bogus")));
        Assert.assertNull((Object)reader.read());
    }

    @Test
    public void testFilterMatchesFinalBlockOnly() throws IOException {
        File tmp = File.createTempFile(this.getClass().getSimpleName(), ".tmp");
        tmp.deleteOnExit();
        tmp.delete();
        Path path = new Path(tmp.getPath());
        Car vwPolo = TestSpecificReadWrite.getVwPolo();
        Car vwPassat = TestSpecificReadWrite.getVwPassat();
        Car bmwMini = TestSpecificReadWrite.getBmwMini();
        AvroParquetWriter writer = new AvroParquetWriter(path, Car.SCHEMA$, CompressionCodecName.UNCOMPRESSED, 0x100000, 8192, false);
        for (int i = 0; i < 10000; ++i) {
            writer.write((Object)vwPolo);
            writer.write((Object)vwPassat);
            writer.write((Object)vwPolo);
        }
        writer.write((Object)bmwMini);
        writer.close();
        AvroParquetReader reader = new AvroParquetReader(path, ColumnRecordFilter.column((String)"make", (ColumnPredicates.Predicate)ColumnPredicates.equalTo((String)"BMW")));
        Assert.assertEquals((Object)TestSpecificReadWrite.getBmwMini().toString(), (Object)((Car)((Object)reader.read())).toString());
        Assert.assertNull((Object)reader.read());
    }

    @Test
    public void testFilterWithDictionary() throws IOException {
        Path path = this.writeCarsToParquetFile(1, CompressionCodecName.UNCOMPRESSED, true);
        AvroParquetReader reader = new AvroParquetReader(path, ColumnRecordFilter.column((String)"make", (ColumnPredicates.Predicate)ColumnPredicates.equalTo((String)"Volkswagen")));
        Assert.assertEquals((Object)TestSpecificReadWrite.getVwPolo().toString(), (Object)((Car)((Object)reader.read())).toString());
        Assert.assertEquals((Object)TestSpecificReadWrite.getVwPassat().toString(), (Object)((Car)((Object)reader.read())).toString());
        Assert.assertNull((Object)reader.read());
    }

    @Test
    public void testFilterOnSubAttribute() throws IOException {
        Path path = this.writeCarsToParquetFile(1, CompressionCodecName.UNCOMPRESSED, false);
        AvroParquetReader reader = new AvroParquetReader(path, ColumnRecordFilter.column((String)"engine.type", (ColumnPredicates.Predicate)ColumnPredicates.equalTo((Enum)EngineType.DIESEL)));
        Assert.assertEquals((Object)((Car)((Object)reader.read())).toString(), (Object)TestSpecificReadWrite.getVwPassat().toString());
        Assert.assertNull((Object)reader.read());
        reader = new AvroParquetReader(path, ColumnRecordFilter.column((String)"engine.capacity", (ColumnPredicates.Predicate)ColumnPredicates.equalTo((float)1.4f)));
        Assert.assertEquals((Object)TestSpecificReadWrite.getVwPolo().toString(), (Object)((Car)((Object)reader.read())).toString());
        Assert.assertNull((Object)reader.read());
        reader = new AvroParquetReader(path, ColumnRecordFilter.column((String)"engine.hasTurboCharger", (ColumnPredicates.Predicate)ColumnPredicates.equalTo((boolean)true)));
        Assert.assertEquals((Object)TestSpecificReadWrite.getBmwMini().toString(), (Object)((Car)((Object)reader.read())).toString());
        Assert.assertNull((Object)reader.read());
    }

    @Test
    public void testProjection() throws IOException {
        Path path = this.writeCarsToParquetFile(1, CompressionCodecName.UNCOMPRESSED, false);
        Configuration conf = new Configuration();
        Schema schema = Car.getClassSchema();
        List fields = schema.getFields();
        ArrayList<Schema.Field> projectedFields = new ArrayList<Schema.Field>();
        for (Schema.Field field : fields) {
            String name = field.name();
            if ("optionalExtra".equals(name) || "serviceHistory".equals(name)) continue;
            Schema.Field fieldClone = new Schema.Field(name, field.schema(), field.doc(), field.defaultValue());
            projectedFields.add(fieldClone);
        }
        Schema projectedSchema = Schema.createRecord((String)schema.getName(), (String)schema.getDoc(), (String)schema.getNamespace(), (boolean)schema.isError());
        projectedSchema.setFields(projectedFields);
        AvroReadSupport.setRequestedProjection((Configuration)conf, (Schema)projectedSchema);
        AvroParquetReader reader = new AvroParquetReader(conf, path);
        Car car = (Car)((Object)reader.read());
        while (car != null) {
            Assert.assertEquals((Object)(car.getDoors() != null ? 1 : 0), (Object)true);
            Assert.assertEquals((Object)(car.getEngine() != null ? 1 : 0), (Object)true);
            Assert.assertEquals((Object)(car.getMake() != null ? 1 : 0), (Object)true);
            Assert.assertEquals((Object)(car.getModel() != null ? 1 : 0), (Object)true);
            Assert.assertEquals((Object)(car.getYear() != null ? 1 : 0), (Object)true);
            Assert.assertEquals((Object)(car.getVin() != null ? 1 : 0), (Object)true);
            Assert.assertNull((Object)car.getOptionalExtra());
            Assert.assertNull(car.getServiceHistory());
            car = (Car)((Object)reader.read());
        }
    }

    @Test
    public void testAvroReadSchema() throws IOException {
        Path path = this.writeCarsToParquetFile(1, CompressionCodecName.UNCOMPRESSED, false);
        Configuration conf = new Configuration();
        AvroReadSupport.setAvroReadSchema((Configuration)conf, (Schema)NewCar.SCHEMA$);
        AvroParquetReader reader = new AvroParquetReader(conf, path);
        NewCar car = (NewCar)((Object)reader.read());
        while (car != null) {
            Assert.assertEquals((Object)(car.getEngine() != null ? 1 : 0), (Object)true);
            Assert.assertEquals((Object)(car.getBrand() != null ? 1 : 0), (Object)true);
            Assert.assertEquals((Object)(car.getYear() != null ? 1 : 0), (Object)true);
            Assert.assertEquals((Object)(car.getVin() != null ? 1 : 0), (Object)true);
            Assert.assertEquals((Object)(car.getDescription() == null ? 1 : 0), (Object)true);
            Assert.assertEquals((Object)(car.getOpt() == 5 ? 1 : 0), (Object)true);
            car = (NewCar)((Object)reader.read());
        }
    }

    private Path writeCarsToParquetFile(int num, CompressionCodecName compression, boolean enableDictionary) throws IOException {
        return this.writeCarsToParquetFile(num, compression, enableDictionary, 0x8000000, 0x100000);
    }

    private Path writeCarsToParquetFile(int num, CompressionCodecName compression, boolean enableDictionary, int blockSize, int pageSize) throws IOException {
        File tmp = File.createTempFile(this.getClass().getSimpleName(), ".tmp");
        tmp.deleteOnExit();
        tmp.delete();
        Path path = new Path(tmp.getPath());
        Car vwPolo = TestSpecificReadWrite.getVwPolo();
        Car vwPassat = TestSpecificReadWrite.getVwPassat();
        Car bmwMini = TestSpecificReadWrite.getBmwMini();
        AvroParquetWriter writer = new AvroParquetWriter(path, Car.SCHEMA$, compression, blockSize, pageSize, enableDictionary);
        for (int i = 0; i < num; ++i) {
            writer.write((Object)vwPolo);
            writer.write((Object)vwPassat);
            writer.write((Object)bmwMini);
        }
        writer.close();
        return path;
    }

    public static Car getVwPolo() {
        String vin = "WVWDB4505LK000001";
        return Car.newBuilder().setYear(2010L).setRegistration("A123 GTR").setMake("Volkswagen").setModel("Polo").setVin(new Vin(vin.getBytes())).setDoors(4).setEngine(Engine.newBuilder().setType(EngineType.PETROL).setCapacity(1.4f).setHasTurboCharger(false).build()).setOptionalExtra((Object)Stereo.newBuilder().setMake("Blaupunkt").setSpeakers(4).build()).setServiceHistory((List<Service>)ImmutableList.of((Object)((Object)Service.newBuilder().setDate(1325376000L).setMechanic("Jim").build()), (Object)((Object)Service.newBuilder().setDate(1356998400L).setMechanic("Mike").build()))).build();
    }

    public static Car getVwPassat() {
        String vin = "WVWDB4505LK000002";
        return Car.newBuilder().setYear(2010L).setRegistration("A123 GXR").setMake("Volkswagen").setModel("Passat").setVin(new Vin(vin.getBytes())).setDoors(5).setEngine(Engine.newBuilder().setType(EngineType.DIESEL).setCapacity(2.0f).setHasTurboCharger(false).build()).setOptionalExtra((Object)LeatherTrim.newBuilder().setColour("Black").build()).setServiceHistory((List<Service>)ImmutableList.of((Object)((Object)Service.newBuilder().setDate(1325376000L).setMechanic("Jim").build()))).build();
    }

    public static Car getBmwMini() {
        String vin = "WBABA91060AL00003";
        return Car.newBuilder().setYear(2010L).setRegistration("A124 GSR").setMake("BMW").setModel("Mini").setVin(new Vin(vin.getBytes())).setDoors(4).setEngine(Engine.newBuilder().setType(EngineType.PETROL).setCapacity(1.6f).setHasTurboCharger(true).build()).setOptionalExtra(null).setServiceHistory((List<Service>)ImmutableList.of((Object)((Object)Service.newBuilder().setDate(1356998400L).setMechanic("Mike").build()))).build();
    }
}

