/*
 * Decompiled with CFR 0.152.
 */
package parquet.avro;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import parquet.Log;
import parquet.avro.AvroParquetInputFormat;
import parquet.avro.AvroParquetOutputFormat;
import parquet.avro.AvroParquetReader;
import parquet.avro.Car;
import parquet.avro.Engine;
import parquet.avro.EngineType;
import parquet.avro.LeatherTrim;
import parquet.avro.Service;
import parquet.avro.ShortCar;
import parquet.avro.Vin;
import parquet.column.ColumnReader;
import parquet.filter.ColumnPredicates;
import parquet.filter.ColumnRecordFilter;
import parquet.filter.RecordFilter;
import parquet.filter.UnboundRecordFilter;

public class TestSpecificInputOutputFormat {
    private static final Log LOG = Log.getLog(TestSpecificInputOutputFormat.class);
    final Configuration conf = new Configuration();
    final Path inputPath = new Path("src/test/java/parquet/avro/TestSpecificInputOutputFormat.java");
    final Path parquetPath = new Path("target/test/hadoop/TestSpecificInputOutputFormat/parquet");
    final Path outputPath = new Path("target/test/hadoop/TestSpecificInputOutputFormat/out");

    public static Car nextRecord(int i) {
        String vin = "1VXBR12EXCP000000";
        Car.Builder carBuilder = Car.newBuilder().setDoors(2).setMake("Tesla").setModel(String.format("Model X v%d", i % 2)).setVin(new Vin(vin.getBytes())).setYear(2014 + i).setOptionalExtra((Object)LeatherTrim.newBuilder().setColour("black").build()).setRegistration("California");
        Engine.Builder engineBuilder = Engine.newBuilder().setCapacity(85.0f).setHasTurboCharger(false);
        if (i % 2 == 0) {
            engineBuilder.setType(EngineType.ELECTRIC);
        } else {
            engineBuilder.setType(EngineType.PETROL);
        }
        carBuilder.setEngine(engineBuilder.build());
        if (i % 4 == 0) {
            ArrayList serviceList = Lists.newArrayList();
            serviceList.add(Service.newBuilder().setDate(1374084640L).setMechanic("Elon Musk").build());
            carBuilder.setServiceHistory(serviceList);
        }
        return carBuilder.build();
    }

    @Before
    public void createParquetFile() throws Exception {
        FileSystem fileSystem = this.parquetPath.getFileSystem(this.conf);
        fileSystem.delete(this.parquetPath, true);
        fileSystem.delete(this.outputPath, true);
        Job job = new Job(this.conf, "write");
        TextInputFormat.addInputPath((Job)job, (Path)this.inputPath);
        job.setInputFormatClass(TextInputFormat.class);
        job.setMapperClass(MyMapper.class);
        job.setNumReduceTasks(0);
        job.setOutputFormatClass(AvroParquetOutputFormat.class);
        AvroParquetOutputFormat.setOutputPath((Job)job, (Path)this.parquetPath);
        AvroParquetOutputFormat.setSchema((Job)job, (Schema)Car.SCHEMA$);
        this.waitForJob(job);
    }

    @Test
    public void testReadWrite() throws Exception {
        Car car;
        Job job = new Job(this.conf, "read");
        job.setInputFormatClass(AvroParquetInputFormat.class);
        AvroParquetInputFormat.setInputPaths((Job)job, (Path[])new Path[]{this.parquetPath});
        AvroParquetInputFormat.setUnboundRecordFilter((Job)job, ElectricCarFilter.class);
        Schema projection = Schema.createRecord((String)Car.SCHEMA$.getName(), (String)Car.SCHEMA$.getDoc(), (String)Car.SCHEMA$.getNamespace(), (boolean)false);
        ArrayList fields = Lists.newArrayList();
        for (Schema.Field field : Car.SCHEMA$.getFields()) {
            if ("optionalExtra".equals(field.name())) continue;
            fields.add(new Schema.Field(field.name(), field.schema(), field.doc(), field.defaultValue(), field.order()));
        }
        projection.setFields((List)fields);
        AvroParquetInputFormat.setRequestedProjection((Job)job, (Schema)projection);
        job.setMapperClass(MyMapper2.class);
        job.setNumReduceTasks(0);
        job.setOutputFormatClass(AvroParquetOutputFormat.class);
        AvroParquetOutputFormat.setOutputPath((Job)job, (Path)this.outputPath);
        AvroParquetOutputFormat.setSchema((Job)job, (Schema)Car.SCHEMA$);
        this.waitForJob(job);
        Path mapperOutput = new Path(this.outputPath.toString(), "part-m-00000.parquet");
        AvroParquetReader out = new AvroParquetReader(mapperOutput);
        Car previousCar = null;
        int lineNumber = 0;
        while ((car = (Car)((Object)out.read())) != null) {
            if (previousCar != null) {
                Assert.assertTrue((car.getModel() == previousCar.getModel() ? 1 : 0) != 0);
            }
            if (car.getEngine().getType() == EngineType.PETROL) {
                Assert.fail((String)"UnboundRecordFilter failed to remove cars with PETROL engines");
            }
            Car expectedCar = TestSpecificInputOutputFormat.nextRecord(lineNumber * 2);
            expectedCar.setOptionalExtra(null);
            Assert.assertEquals((String)("line " + lineNumber), (Object)((Object)expectedCar), (Object)((Object)car));
            ++lineNumber;
            previousCar = car;
        }
        out.close();
    }

    @Test
    public void testReadWriteChangedCar() throws Exception {
        ShortCar car;
        Job job = new Job(this.conf, "read changed/short");
        job.setInputFormatClass(AvroParquetInputFormat.class);
        AvroParquetInputFormat.setInputPaths((Job)job, (Path[])new Path[]{this.parquetPath});
        AvroParquetInputFormat.setUnboundRecordFilter((Job)job, ElectricCarFilter.class);
        Schema projection = Schema.createRecord((String)Car.SCHEMA$.getName(), (String)Car.SCHEMA$.getDoc(), (String)Car.SCHEMA$.getNamespace(), (boolean)false);
        ArrayList fields = Lists.newArrayList();
        for (Schema.Field field : Car.SCHEMA$.getFields()) {
            if (!"engine".equals(field.name()) && !"year".equals(field.name()) && !"vin".equals(field.name())) continue;
            fields.add(new Schema.Field(field.name(), field.schema(), field.doc(), field.defaultValue(), field.order()));
        }
        projection.setFields((List)fields);
        AvroParquetInputFormat.setRequestedProjection((Job)job, (Schema)projection);
        AvroParquetInputFormat.setAvroReadSchema((Job)job, (Schema)ShortCar.SCHEMA$);
        job.setMapperClass(MyMapperShort.class);
        job.setNumReduceTasks(0);
        job.setOutputFormatClass(AvroParquetOutputFormat.class);
        AvroParquetOutputFormat.setOutputPath((Job)job, (Path)this.outputPath);
        AvroParquetOutputFormat.setSchema((Job)job, (Schema)ShortCar.SCHEMA$);
        this.waitForJob(job);
        Path mapperOutput = new Path(this.outputPath.toString(), "part-m-00000.parquet");
        AvroParquetReader out = new AvroParquetReader(mapperOutput);
        int lineNumber = 0;
        while ((car = (ShortCar)((Object)out.read())) != null) {
            Car expectedCar = TestSpecificInputOutputFormat.nextRecord(lineNumber * 2);
            Assert.assertNull((Object)car.getMake());
            Assert.assertEquals((Object)((Object)car.getEngine()), (Object)((Object)expectedCar.getEngine()));
            Assert.assertEquals((Object)car.getYear(), (Object)expectedCar.getYear());
            Assert.assertEquals((Object)((Object)car.getVin()), (Object)((Object)expectedCar.getVin()));
            ++lineNumber;
        }
        out.close();
    }

    private void waitForJob(Job job) throws Exception {
        job.submit();
        while (!job.isComplete()) {
            LOG.debug((Object)("waiting for job " + job.getJobName()));
            Thread.sleep(100L);
        }
        LOG.info((Object)("status for job " + job.getJobName() + ": " + (job.isSuccessful() ? "SUCCESS" : "FAILURE")));
        if (!job.isSuccessful()) {
            throw new RuntimeException("job failed " + job.getJobName());
        }
    }

    @After
    public void deleteOutputFile() throws IOException {
        FileSystem fileSystem = this.parquetPath.getFileSystem(this.conf);
        fileSystem.delete(this.parquetPath, true);
        fileSystem.delete(this.outputPath, true);
    }

    public static class ElectricCarFilter
    implements UnboundRecordFilter {
        private final UnboundRecordFilter filter = ColumnRecordFilter.column((String)"engine.type", (ColumnPredicates.Predicate)ColumnPredicates.equalTo((Enum)EngineType.ELECTRIC));

        public RecordFilter bind(Iterable<ColumnReader> readers) {
            return this.filter.bind(readers);
        }
    }

    public static class MyMapperShort
    extends Mapper<Void, ShortCar, Void, ShortCar> {
        protected void map(Void key, ShortCar car, Mapper.Context context) throws IOException, InterruptedException {
            if (car != null) {
                context.write(null, (Object)car);
            }
        }
    }

    public static class MyMapper2
    extends Mapper<Void, Car, Void, Car> {
        protected void map(Void key, Car car, Mapper.Context context) throws IOException, InterruptedException {
            if (car != null) {
                context.write(null, (Object)car);
            }
        }
    }

    public static class MyMapper
    extends Mapper<LongWritable, Text, Void, Car> {
        public void run(Mapper.Context context) throws IOException, InterruptedException {
            for (int i = 0; i < 10; ++i) {
                context.write(null, (Object)TestSpecificInputOutputFormat.nextRecord(i));
            }
        }
    }
}

