/*
 * Decompiled with CFR 0.152.
 */
package parquet.avro;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.util.Utf8;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.junit.Test;
import parquet.avro.AvroParquetReader;
import parquet.avro.AvroParquetWriter;
import parquet.hadoop.ParquetWriter;
import parquet.hadoop.api.WriteSupport;
import parquet.io.api.Binary;
import parquet.io.api.RecordConsumer;
import parquet.schema.MessageTypeParser;

public class TestReadWrite {
    @Test
    public void testEmptyArray() throws Exception {
        Schema schema = new Schema.Parser().parse(Resources.getResource((String)"array.avsc").openStream());
        File tmp = File.createTempFile(this.getClass().getSimpleName(), ".tmp");
        tmp.deleteOnExit();
        tmp.delete();
        Path file = new Path(tmp.getPath());
        AvroParquetWriter writer = new AvroParquetWriter(file, schema);
        ArrayList emptyArray = new ArrayList();
        GenericData.Record record = new GenericRecordBuilder(schema).set("myarray", emptyArray).build();
        writer.write((Object)record);
        writer.close();
        AvroParquetReader reader = new AvroParquetReader(file);
        GenericRecord nextRecord = (GenericRecord)reader.read();
        Assert.assertNotNull((Object)nextRecord);
        Assert.assertEquals(emptyArray, (Object)nextRecord.get("myarray"));
    }

    @Test
    public void testEmptyMap() throws Exception {
        Schema schema = new Schema.Parser().parse(Resources.getResource((String)"map.avsc").openStream());
        File tmp = File.createTempFile(this.getClass().getSimpleName(), ".tmp");
        tmp.deleteOnExit();
        tmp.delete();
        Path file = new Path(tmp.getPath());
        AvroParquetWriter writer = new AvroParquetWriter(file, schema);
        ImmutableMap emptyMap = new ImmutableMap.Builder().build();
        GenericData.Record record = new GenericRecordBuilder(schema).set("mymap", (Object)emptyMap).build();
        writer.write((Object)record);
        writer.close();
        AvroParquetReader reader = new AvroParquetReader(file);
        GenericRecord nextRecord = (GenericRecord)reader.read();
        Assert.assertNotNull((Object)nextRecord);
        Assert.assertEquals((Object)emptyMap, (Object)nextRecord.get("mymap"));
    }

    @Test
    public void testMapWithUtf8Key() throws Exception {
        Schema schema = new Schema.Parser().parse(Resources.getResource((String)"map.avsc").openStream());
        File tmp = File.createTempFile(this.getClass().getSimpleName(), ".tmp");
        tmp.deleteOnExit();
        tmp.delete();
        Path file = new Path(tmp.getPath());
        AvroParquetWriter writer = new AvroParquetWriter(file, schema);
        GenericData.Record record = new GenericRecordBuilder(schema).set("mymap", (Object)ImmutableMap.of((Object)new Utf8("a"), (Object)1, (Object)new Utf8("b"), (Object)2)).build();
        writer.write((Object)record);
        writer.close();
        AvroParquetReader reader = new AvroParquetReader(file);
        GenericRecord nextRecord = (GenericRecord)reader.read();
        Assert.assertNotNull((Object)nextRecord);
        Assert.assertEquals((Object)ImmutableMap.of((Object)"a", (Object)1, (Object)"b", (Object)2), (Object)nextRecord.get("mymap"));
    }

    @Test
    public void testAll() throws Exception {
        Schema schema = new Schema.Parser().parse(Resources.getResource((String)"all.avsc").openStream());
        File tmp = File.createTempFile(this.getClass().getSimpleName(), ".tmp");
        tmp.deleteOnExit();
        tmp.delete();
        Path file = new Path(tmp.getPath());
        AvroParquetWriter writer = new AvroParquetWriter(file, schema);
        GenericData.Record nestedRecord = new GenericRecordBuilder(schema.getField("mynestedrecord").schema()).set("mynestedint", (Object)1).build();
        List<Integer> integerArray = Arrays.asList(1, 2, 3);
        GenericData.Array genericIntegerArray = new GenericData.Array(Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.INT)), integerArray);
        GenericData.Fixed genericFixed = new GenericData.Fixed(Schema.createFixed((String)"fixed", null, null, (int)1), new byte[]{65});
        ArrayList emptyArray = new ArrayList();
        ImmutableMap emptyMap = new ImmutableMap.Builder().build();
        GenericData.Record record = new GenericRecordBuilder(schema).set("mynull", null).set("myboolean", (Object)true).set("myint", (Object)1).set("mylong", (Object)2L).set("myfloat", (Object)Float.valueOf(3.1f)).set("mydouble", (Object)4.1).set("mybytes", (Object)ByteBuffer.wrap("hello".getBytes(Charsets.UTF_8))).set("mystring", (Object)"hello").set("mynestedrecord", (Object)nestedRecord).set("myenum", (Object)"a").set("myarray", (Object)genericIntegerArray).set("myemptyarray", emptyArray).set("myoptionalarray", (Object)genericIntegerArray).set("mymap", (Object)ImmutableMap.of((Object)"a", (Object)1, (Object)"b", (Object)2)).set("myemptymap", (Object)emptyMap).set("myfixed", (Object)genericFixed).build();
        writer.write((Object)record);
        writer.close();
        AvroParquetReader reader = new AvroParquetReader(file);
        GenericRecord nextRecord = (GenericRecord)reader.read();
        Assert.assertNotNull((Object)nextRecord);
        Assert.assertEquals(null, (Object)nextRecord.get("mynull"));
        Assert.assertEquals((Object)true, (Object)nextRecord.get("myboolean"));
        Assert.assertEquals((Object)1, (Object)nextRecord.get("myint"));
        Assert.assertEquals((Object)2L, (Object)nextRecord.get("mylong"));
        Assert.assertEquals((Object)Float.valueOf(3.1f), (Object)nextRecord.get("myfloat"));
        Assert.assertEquals((Object)4.1, (Object)nextRecord.get("mydouble"));
        Assert.assertEquals((Object)ByteBuffer.wrap("hello".getBytes(Charsets.UTF_8)), (Object)nextRecord.get("mybytes"));
        Assert.assertEquals((Object)"hello", (Object)nextRecord.get("mystring"));
        Assert.assertEquals((Object)"a", (Object)nextRecord.get("myenum"));
        Assert.assertEquals((Object)nestedRecord, (Object)nextRecord.get("mynestedrecord"));
        Assert.assertEquals(integerArray, (Object)nextRecord.get("myarray"));
        Assert.assertEquals(emptyArray, (Object)nextRecord.get("myemptyarray"));
        Assert.assertEquals(integerArray, (Object)nextRecord.get("myoptionalarray"));
        Assert.assertEquals((Object)ImmutableMap.of((Object)"a", (Object)1, (Object)"b", (Object)2), (Object)nextRecord.get("mymap"));
        Assert.assertEquals((Object)emptyMap, (Object)nextRecord.get("myemptymap"));
        Assert.assertEquals((Object)genericFixed, (Object)nextRecord.get("myfixed"));
    }

    @Test
    public void testAllUsingDefaultAvroSchema() throws Exception {
        File tmp = File.createTempFile(this.getClass().getSimpleName(), ".tmp");
        tmp.deleteOnExit();
        tmp.delete();
        Path file = new Path(tmp.getPath());
        ParquetWriter parquetWriter = new ParquetWriter(file, (WriteSupport)new WriteSupport<Map<String, Object>>(){
            private RecordConsumer recordConsumer;

            public WriteSupport.WriteContext init(Configuration configuration) {
                return new WriteSupport.WriteContext(MessageTypeParser.parseMessageType((String)"message parquet.avro.myrecord {\n  required boolean myboolean;\n  required int32 myint;\n  required int64 mylong;\n  required float myfloat;\n  required double mydouble;\n  required binary mybytes;\n  required binary mystring (UTF8);\n  required group mynestedrecord {\n    required int32 mynestedint;\n  }\n  required binary myenum (ENUM);\n  required group myarray (LIST) {\n    repeated int32 array;\n  }\n  optional group myoptionalarray (LIST) {\n    repeated int32 array;\n  }\n  required group myrecordarray (LIST) {\n    repeated group array {\n      required int32 a;\n      required int32 b;\n    }\n  }\n  required group mymap (MAP) {\n    repeated group map (MAP_KEY_VALUE) {\n      required binary key (UTF8);\n      required int32 value;\n    }\n  }\n  required fixed_len_byte_array(1) myfixed;\n}\n"), new HashMap());
            }

            public void prepareForWrite(RecordConsumer recordConsumer) {
                this.recordConsumer = recordConsumer;
            }

            public void write(Map<String, Object> record) {
                this.recordConsumer.startMessage();
                int index = 0;
                this.recordConsumer.startField("myboolean", index);
                this.recordConsumer.addBoolean(((Boolean)record.get("myboolean")).booleanValue());
                this.recordConsumer.endField("myboolean", index++);
                this.recordConsumer.startField("myint", index);
                this.recordConsumer.addInteger(((Integer)record.get("myint")).intValue());
                this.recordConsumer.endField("myint", index++);
                this.recordConsumer.startField("mylong", index);
                this.recordConsumer.addLong(((Long)record.get("mylong")).longValue());
                this.recordConsumer.endField("mylong", index++);
                this.recordConsumer.startField("myfloat", index);
                this.recordConsumer.addFloat(((Float)record.get("myfloat")).floatValue());
                this.recordConsumer.endField("myfloat", index++);
                this.recordConsumer.startField("mydouble", index);
                this.recordConsumer.addDouble(((Double)record.get("mydouble")).doubleValue());
                this.recordConsumer.endField("mydouble", index++);
                this.recordConsumer.startField("mybytes", index);
                this.recordConsumer.addBinary(Binary.fromByteBuffer((ByteBuffer)((ByteBuffer)record.get("mybytes"))));
                this.recordConsumer.endField("mybytes", index++);
                this.recordConsumer.startField("mystring", index);
                this.recordConsumer.addBinary(Binary.fromString((String)((String)record.get("mystring"))));
                this.recordConsumer.endField("mystring", index++);
                this.recordConsumer.startField("mynestedrecord", index);
                this.recordConsumer.startGroup();
                this.recordConsumer.startField("mynestedint", 0);
                this.recordConsumer.addInteger(((Integer)record.get("mynestedint")).intValue());
                this.recordConsumer.endField("mynestedint", 0);
                this.recordConsumer.endGroup();
                this.recordConsumer.endField("mynestedrecord", index++);
                this.recordConsumer.startField("myenum", index);
                this.recordConsumer.addBinary(Binary.fromString((String)((String)record.get("myenum"))));
                this.recordConsumer.endField("myenum", index++);
                this.recordConsumer.startField("myarray", index);
                this.recordConsumer.startGroup();
                this.recordConsumer.startField("array", 0);
                for (int val : (int[])record.get("myarray")) {
                    this.recordConsumer.addInteger(val);
                }
                this.recordConsumer.endField("array", 0);
                this.recordConsumer.endGroup();
                this.recordConsumer.endField("myarray", index++);
                this.recordConsumer.startField("myoptionalarray", index);
                this.recordConsumer.startGroup();
                this.recordConsumer.startField("array", 0);
                for (int val : (int[])record.get("myoptionalarray")) {
                    this.recordConsumer.addInteger(val);
                }
                this.recordConsumer.endField("array", 0);
                this.recordConsumer.endGroup();
                this.recordConsumer.endField("myoptionalarray", index++);
                this.recordConsumer.startField("myrecordarray", index);
                this.recordConsumer.startGroup();
                this.recordConsumer.startField("array", 0);
                this.recordConsumer.startGroup();
                this.recordConsumer.startField("a", 0);
                for (int val : (int[])record.get("myrecordarraya")) {
                    this.recordConsumer.addInteger(val);
                }
                this.recordConsumer.endField("a", 0);
                this.recordConsumer.startField("b", 1);
                for (int val : (int[])record.get("myrecordarrayb")) {
                    this.recordConsumer.addInteger(val);
                }
                this.recordConsumer.endField("b", 1);
                this.recordConsumer.endGroup();
                this.recordConsumer.endField("array", 0);
                this.recordConsumer.endGroup();
                this.recordConsumer.endField("myrecordarray", index++);
                this.recordConsumer.startField("mymap", index);
                this.recordConsumer.startGroup();
                this.recordConsumer.startField("map", 0);
                this.recordConsumer.startGroup();
                Map mymap = (Map)record.get("mymap");
                this.recordConsumer.startField("key", 0);
                for (String key : mymap.keySet()) {
                    this.recordConsumer.addBinary(Binary.fromString((String)key));
                }
                this.recordConsumer.endField("key", 0);
                this.recordConsumer.startField("value", 1);
                Iterator<Object> i$ = mymap.values().iterator();
                while (i$.hasNext()) {
                    int val = (Integer)i$.next();
                    this.recordConsumer.addInteger(val);
                }
                this.recordConsumer.endField("value", 1);
                this.recordConsumer.endGroup();
                this.recordConsumer.endField("map", 0);
                this.recordConsumer.endGroup();
                this.recordConsumer.endField("mymap", index++);
                this.recordConsumer.startField("myfixed", index);
                this.recordConsumer.addBinary(Binary.fromByteArray((byte[])((byte[])record.get("myfixed"))));
                this.recordConsumer.endField("myfixed", index++);
                this.recordConsumer.endMessage();
            }
        });
        HashMap<String, Object> record = new HashMap<String, Object>();
        record.put("myboolean", true);
        record.put("myint", 1);
        record.put("mylong", 2L);
        record.put("myfloat", Float.valueOf(3.1f));
        record.put("mydouble", 4.1);
        record.put("mybytes", ByteBuffer.wrap("hello".getBytes(Charsets.UTF_8)));
        record.put("mystring", "hello");
        record.put("myenum", "a");
        record.put("mynestedint", 1);
        record.put("myarray", new int[]{1, 2, 3});
        record.put("myoptionalarray", new int[]{1, 2, 3});
        record.put("myrecordarraya", new int[]{1, 2, 3});
        record.put("myrecordarrayb", new int[]{4, 5, 6});
        record.put("mymap", ImmutableMap.of((Object)"a", (Object)1, (Object)"b", (Object)2));
        record.put("myfixed", new byte[]{65});
        parquetWriter.write(record);
        parquetWriter.close();
        Schema nestedRecordSchema = Schema.createRecord((String)"mynestedrecord", null, null, (boolean)false);
        nestedRecordSchema.setFields(Arrays.asList(new Schema.Field("mynestedint", Schema.create((Schema.Type)Schema.Type.INT), null, null)));
        GenericData.Record nestedRecord = new GenericRecordBuilder(nestedRecordSchema).set("mynestedint", (Object)1).build();
        List<Integer> integerArray = Arrays.asList(1, 2, 3);
        Schema recordArraySchema = Schema.createRecord((String)"array", null, null, (boolean)false);
        recordArraySchema.setFields(Arrays.asList(new Schema.Field("a", Schema.create((Schema.Type)Schema.Type.INT), null, null), new Schema.Field("b", Schema.create((Schema.Type)Schema.Type.INT), null, null)));
        GenericRecordBuilder builder = new GenericRecordBuilder(recordArraySchema);
        ArrayList<GenericData.Record> recordArray = new ArrayList<GenericData.Record>();
        recordArray.add(builder.set("a", (Object)1).set("b", (Object)4).build());
        recordArray.add(builder.set("a", (Object)2).set("b", (Object)5).build());
        recordArray.add(builder.set("a", (Object)3).set("b", (Object)6).build());
        GenericData.Array genericRecordArray = new GenericData.Array(Schema.createArray((Schema)recordArraySchema), recordArray);
        GenericData.Fixed genericFixed = new GenericData.Fixed(Schema.createFixed((String)"fixed", null, null, (int)1), new byte[]{65});
        AvroParquetReader reader = new AvroParquetReader(file);
        GenericRecord nextRecord = (GenericRecord)reader.read();
        Assert.assertNotNull((Object)nextRecord);
        Assert.assertEquals((Object)true, (Object)nextRecord.get("myboolean"));
        Assert.assertEquals((Object)1, (Object)nextRecord.get("myint"));
        Assert.assertEquals((Object)2L, (Object)nextRecord.get("mylong"));
        Assert.assertEquals((Object)Float.valueOf(3.1f), (Object)nextRecord.get("myfloat"));
        Assert.assertEquals((Object)4.1, (Object)nextRecord.get("mydouble"));
        Assert.assertEquals((Object)ByteBuffer.wrap("hello".getBytes(Charsets.UTF_8)), (Object)nextRecord.get("mybytes"));
        Assert.assertEquals((Object)"hello", (Object)nextRecord.get("mystring"));
        Assert.assertEquals((Object)"a", (Object)nextRecord.get("myenum"));
        Assert.assertEquals((Object)nestedRecord, (Object)nextRecord.get("mynestedrecord"));
        Assert.assertEquals(integerArray, (Object)nextRecord.get("myarray"));
        Assert.assertEquals(integerArray, (Object)nextRecord.get("myoptionalarray"));
        Assert.assertEquals((Object)genericRecordArray, (Object)nextRecord.get("myrecordarray"));
        Assert.assertEquals((Object)ImmutableMap.of((Object)"a", (Object)1, (Object)"b", (Object)2), (Object)nextRecord.get("mymap"));
        Assert.assertEquals((Object)genericFixed, (Object)nextRecord.get("myfixed"));
    }
}

