/*
 * Decompiled with CFR 0.152.
 */
package parquet.avro;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.junit.Assert;
import org.junit.Test;
import parquet.Log;
import parquet.avro.AvroParquetInputFormat;
import parquet.avro.AvroParquetOutputFormat;

public class TestInputOutputFormat {
    private static final Log LOG = Log.getLog(TestInputOutputFormat.class);
    private static Schema avroSchema = Schema.createRecord((String)"record1", null, null, (boolean)false);

    public static GenericRecord nextRecord(Integer i) {
        return new GenericRecordBuilder(avroSchema).set("a", (Object)i).build();
    }

    @Test
    public void testReadWrite() throws Exception {
        Configuration conf = new Configuration();
        Path inputPath = new Path("src/test/java/parquet/avro/TestInputOutputFormat.java");
        Path parquetPath = new Path("target/test/hadoop/TestInputOutputFormat/parquet");
        Path outputPath = new Path("target/test/hadoop/TestInputOutputFormat/out");
        FileSystem fileSystem = parquetPath.getFileSystem(conf);
        fileSystem.delete(parquetPath, true);
        fileSystem.delete(outputPath, true);
        Job job = new Job(conf, "write");
        TextInputFormat.addInputPath((Job)job, (Path)inputPath);
        job.setInputFormatClass(TextInputFormat.class);
        job.setMapperClass(MyMapper.class);
        job.setNumReduceTasks(0);
        job.setOutputFormatClass(AvroParquetOutputFormat.class);
        AvroParquetOutputFormat.setOutputPath((Job)job, (Path)parquetPath);
        AvroParquetOutputFormat.setSchema((Job)job, (Schema)avroSchema);
        this.waitForJob(job);
        job = new Job(conf, "read");
        job.setInputFormatClass(AvroParquetInputFormat.class);
        AvroParquetInputFormat.setInputPaths((Job)job, (Path[])new Path[]{parquetPath});
        job.setMapperClass(MyMapper2.class);
        job.setNumReduceTasks(0);
        job.setOutputFormatClass(TextOutputFormat.class);
        TextOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        this.waitForJob(job);
        BufferedReader out = new BufferedReader(new FileReader(new File(outputPath.toString(), "part-m-00000")));
        String lineOut = null;
        int lineNumber = 0;
        while ((lineOut = out.readLine()) != null) {
            lineOut = lineOut.substring(lineOut.indexOf("\t") + 1);
            GenericRecord a = TestInputOutputFormat.nextRecord(lineNumber == 4 ? null : Integer.valueOf(lineNumber));
            Assert.assertEquals((String)("line " + lineNumber), (Object)a.toString(), (Object)lineOut);
            ++lineNumber;
        }
        Assert.assertNull((String)("line " + lineNumber), (Object)out.readLine());
        out.close();
    }

    private void waitForJob(Job job) throws Exception {
        job.submit();
        while (!job.isComplete()) {
            LOG.debug((Object)("waiting for job " + job.getJobName()));
            Thread.sleep(100L);
        }
        LOG.info((Object)("status for job " + job.getJobName() + ": " + (job.isSuccessful() ? "SUCCESS" : "FAILURE")));
        if (!job.isSuccessful()) {
            throw new RuntimeException("job failed " + job.getJobName());
        }
    }

    static {
        avroSchema.setFields(Arrays.asList(new Schema.Field("a", Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.INT), Schema.create((Schema.Type)Schema.Type.NULL))), null, null)));
    }

    public static class MyMapper2
    extends Mapper<Void, GenericRecord, LongWritable, Text> {
        protected void map(Void key, GenericRecord value, Mapper.Context context) throws IOException, InterruptedException {
            context.write(null, (Object)new Text(value.toString()));
        }
    }

    public static class MyMapper
    extends Mapper<LongWritable, Text, Void, GenericRecord> {
        public void run(Mapper.Context context) throws IOException, InterruptedException {
            for (int i = 0; i < 10; ++i) {
                GenericRecord a = TestInputOutputFormat.nextRecord(i == 4 ? null : Integer.valueOf(i));
                context.write(null, (Object)a);
            }
        }
    }
}

