/*
 * Decompiled with CFR 0.152.
 */
package parquet.avro;

import com.google.common.collect.Lists;
import com.google.common.io.Resources;
import java.util.Arrays;
import java.util.List;
import org.apache.avro.Schema;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.NullNode;
import org.junit.Assert;
import org.junit.Test;
import parquet.avro.AvroSchemaConverter;
import parquet.schema.MessageType;
import parquet.schema.MessageTypeParser;

public class TestAvroSchemaConverter {
    public static final String ALL_PARQUET_SCHEMA = "message parquet.avro.myrecord {\n  required boolean myboolean;\n  required int32 myint;\n  required int64 mylong;\n  required float myfloat;\n  required double mydouble;\n  required binary mybytes;\n  required binary mystring (UTF8);\n  required group mynestedrecord {\n    required int32 mynestedint;\n  }\n  required binary myenum (ENUM);\n  required group myarray (LIST) {\n    repeated int32 array;\n  }\n  optional group myoptionalarray (LIST) {\n    repeated int32 array;\n  }\n  required group myrecordarray (LIST) {\n    repeated group array {\n      required int32 a;\n      required int32 b;\n    }\n  }\n  required group mymap (MAP) {\n    repeated group map (MAP_KEY_VALUE) {\n      required binary key (UTF8);\n      required int32 value;\n    }\n  }\n  required fixed_len_byte_array(1) myfixed;\n}\n";

    private void testAvroToParquetConversion(Schema avroSchema, String schemaString) throws Exception {
        AvroSchemaConverter avroSchemaConverter = new AvroSchemaConverter();
        MessageType schema = avroSchemaConverter.convert(avroSchema);
        MessageType expectedMT = MessageTypeParser.parseMessageType((String)schemaString);
        Assert.assertEquals((String)("converting " + schema + " to " + schemaString), (Object)expectedMT.toString(), (Object)schema.toString());
    }

    private void testParquetToAvroConversion(Schema avroSchema, String schemaString) throws Exception {
        AvroSchemaConverter avroSchemaConverter = new AvroSchemaConverter();
        Schema schema = avroSchemaConverter.convert(MessageTypeParser.parseMessageType((String)schemaString));
        Assert.assertEquals((String)("converting " + schemaString + " to " + avroSchema), (Object)avroSchema.toString(), (Object)schema.toString());
    }

    private void testRoundTripConversion(Schema avroSchema, String schemaString) throws Exception {
        AvroSchemaConverter avroSchemaConverter = new AvroSchemaConverter();
        MessageType schema = avroSchemaConverter.convert(avroSchema);
        MessageType expectedMT = MessageTypeParser.parseMessageType((String)schemaString);
        Assert.assertEquals((String)("converting " + schema + " to " + schemaString), (Object)expectedMT.toString(), (Object)schema.toString());
        Schema convertedAvroSchema = avroSchemaConverter.convert(expectedMT);
        Assert.assertEquals((String)("converting " + expectedMT + " to " + avroSchema.toString(true)), (Object)avroSchema.toString(), (Object)convertedAvroSchema.toString());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testTopLevelMustBeARecord() {
        new AvroSchemaConverter().convert(Schema.create((Schema.Type)Schema.Type.INT));
    }

    @Test
    public void testAllTypes() throws Exception {
        Schema schema = new Schema.Parser().parse(Resources.getResource((String)"all.avsc").openStream());
        this.testAvroToParquetConversion(schema, "message parquet.avro.myrecord {\n  required boolean myboolean;\n  required int32 myint;\n  required int64 mylong;\n  required float myfloat;\n  required double mydouble;\n  required binary mybytes;\n  required binary mystring (UTF8);\n  required group mynestedrecord {\n    required int32 mynestedint;\n  }\n  required binary myenum (ENUM);\n  required group myarray (LIST) {\n    repeated int32 array;\n  }\n  required group myemptyarray (LIST) {\n    repeated int32 array;\n  }\n  optional group myoptionalarray (LIST) {\n    repeated int32 array;\n  }\n  required group mymap (MAP) {\n    repeated group map (MAP_KEY_VALUE) {\n      required binary key (UTF8);\n      required int32 value;\n    }\n  }\n  required group myemptymap (MAP) {\n    repeated group map (MAP_KEY_VALUE) {\n      required binary key (UTF8);\n      required int32 value;\n    }\n  }\n  required fixed_len_byte_array(1) myfixed;\n}\n");
    }

    @Test
    public void testAllTypesParquetToAvro() throws Exception {
        Schema schema = new Schema.Parser().parse(Resources.getResource((String)"allFromParquet.avsc").openStream());
        this.testParquetToAvroConversion(schema, ALL_PARQUET_SCHEMA);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParquetMapWithNonStringKeyFails() throws Exception {
        MessageType parquetSchema = MessageTypeParser.parseMessageType((String)"message myrecord {\n  required group mymap (MAP) {\n    repeated group map (MAP_KEY_VALUE) {\n      required int32 key;\n      required int32 value;\n    }\n  }\n}\n");
        new AvroSchemaConverter().convert(parquetSchema);
    }

    @Test
    public void testOptionalFields() throws Exception {
        Schema schema = Schema.createRecord((String)"record1", null, null, (boolean)false);
        Schema optionalInt = TestAvroSchemaConverter.optional(Schema.create((Schema.Type)Schema.Type.INT));
        schema.setFields(Arrays.asList(new Schema.Field("myint", optionalInt, null, (JsonNode)NullNode.getInstance())));
        this.testAvroToParquetConversion(schema, "message record1 {\n  optional int32 myint;\n}\n");
    }

    @Test
    public void testUnionOfTwoTypes() throws Exception {
        Schema schema = Schema.createRecord((String)"record2", null, null, (boolean)false);
        Schema multipleTypes = Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)Schema.Type.INT), Schema.create((Schema.Type)Schema.Type.FLOAT)));
        schema.setFields(Arrays.asList(new Schema.Field("myunion", multipleTypes, null, (JsonNode)NullNode.getInstance())));
        this.testAvroToParquetConversion(schema, "message record2 {\n  optional group myunion {\n    optional int32 member0;\n    optional float member1;\n  }\n}\n");
    }

    @Test
    public void testArrayOfOptionalRecords() throws Exception {
        Schema innerRecord = Schema.createRecord((String)"InnerRecord", null, null, (boolean)false);
        Schema optionalString = TestAvroSchemaConverter.optional(Schema.create((Schema.Type)Schema.Type.STRING));
        innerRecord.setFields((List)Lists.newArrayList((Object[])new Schema.Field[]{new Schema.Field("s1", optionalString, null, (JsonNode)NullNode.getInstance()), new Schema.Field("s2", optionalString, null, (JsonNode)NullNode.getInstance())}));
        Schema schema = Schema.createRecord((String)"HasArray", null, null, (boolean)false);
        schema.setFields((List)Lists.newArrayList((Object[])new Schema.Field[]{new Schema.Field("myarray", Schema.createArray((Schema)TestAvroSchemaConverter.optional(innerRecord)), null, (JsonNode)NullNode.getInstance())}));
        System.err.println("Avro schema: " + schema.toString(true));
        this.testAvroToParquetConversion(schema, "message HasArray {\n  required group myarray (LIST) {\n    repeated group array {\n      optional binary s1 (UTF8);\n      optional binary s2 (UTF8);\n    }\n  }\n}\n");
    }

    public static Schema optional(Schema original) {
        return Schema.createUnion((List)Lists.newArrayList((Object[])new Schema[]{original, Schema.create((Schema.Type)Schema.Type.NULL)}));
    }
}

