/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl.splunk.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import net.hydromatic.optiq.impl.splunk.util.StringUtils;
import net.hydromatic.optiq.impl.splunk.util.TrustAllSslSocketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpUtils {
    private static final Logger LOGGER = StringUtils.getClassTracer(HttpUtils.class);

    private HttpUtils() {
    }

    public static HttpURLConnection getURLConnection(String url) throws IOException {
        URLConnection conn = new URL(url).openConnection();
        HttpURLConnection httpConn = (HttpURLConnection)conn;
        if (httpConn instanceof HttpsURLConnection) {
            HttpsURLConnection httpsConn = (HttpsURLConnection)httpConn;
            httpsConn.setSSLSocketFactory(TrustAllSslSocketFactory.createSSLSocketFactory());
            httpsConn.setHostnameVerifier(new HostnameVerifier(){

                public boolean verify(String arg0, SSLSession arg1) {
                    return true;
                }
            });
        }
        return httpConn;
    }

    public static void appendURLEncodedArgs(StringBuilder out, Map<String, String> args) {
        int i = 0;
        try {
            for (Map.Entry<String, String> me : args.entrySet()) {
                if (i++ != 0) {
                    out.append("&");
                }
                out.append(URLEncoder.encode(me.getKey(), "UTF-8"));
                out.append("=").append(URLEncoder.encode(me.getValue(), "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public static void appendURLEncodedArgs(StringBuilder out, CharSequence ... args) {
        if (args.length % 2 != 0) {
            throw new IllegalArgumentException("args should contain an even number of items");
        }
        try {
            int appended = 0;
            for (int i = 0; i < args.length; i += 2) {
                if (args[i + 1] == null) continue;
                if (appended++ > 0) {
                    out.append("&");
                }
                out.append(URLEncoder.encode(args[i].toString(), "UTF-8")).append("=").append(URLEncoder.encode(args[i + 1].toString(), "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public static void close(Closeable c) {
        try {
            c.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static InputStream post(String url, CharSequence data, Map<String, String> headers) throws IOException {
        return HttpUtils.post(url, data, headers, 10000, 60000);
    }

    public static InputStream post(String url, CharSequence data, Map<String, String> headers, int cTimeout, int rTimeout) throws IOException {
        return HttpUtils.executeMethod("POST", url, data, headers, cTimeout, rTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream executeMethod(String method, String url, CharSequence data, Map<String, String> headers, int ctimeout, int rtimeout) throws IOException {
        InputStream inputStream;
        OutputStreamWriter wr = null;
        try {
            HttpURLConnection conn = HttpUtils.getURLConnection(url);
            conn.setRequestMethod(method);
            conn.setReadTimeout(rtimeout);
            conn.setConnectTimeout(ctimeout);
            if (headers != null) {
                for (Map.Entry<String, String> me : headers.entrySet()) {
                    conn.setRequestProperty(me.getKey(), me.getValue());
                }
            }
            if (data != null) {
                conn.setDoOutput(true);
                wr = new OutputStreamWriter(conn.getOutputStream());
                wr.write(data.toString());
                wr.flush();
            }
            InputStream in = conn.getInputStream();
            wr.close();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("url: " + url + ", data: " + String.valueOf(data));
            }
            inputStream = in;
        }
        catch (Throwable throwable) {
            HttpUtils.close(wr);
            throw throwable;
        }
        HttpUtils.close(wr);
        return inputStream;
    }
}

