/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl.splunk;

import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import net.hydromatic.avatica.DriverVersion;
import net.hydromatic.avatica.UnregisteredDriver;
import net.hydromatic.optiq.Schema;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.impl.jdbc.JdbcSchema;
import net.hydromatic.optiq.impl.splunk.SplunkDriverVersion;
import net.hydromatic.optiq.impl.splunk.SplunkSchema;
import net.hydromatic.optiq.impl.splunk.search.SplunkConnection;
import net.hydromatic.optiq.jdbc.OptiqConnection;

public class SplunkDriver
extends UnregisteredDriver {
    protected SplunkDriver() {
    }

    protected String getConnectStringPrefix() {
        return "jdbc:splunk:";
    }

    protected DriverVersion createDriverVersion() {
        return new SplunkDriverVersion();
    }

    public Connection connect(String url, Properties info) throws SQLException {
        SplunkConnection splunkConnection;
        Connection connection = super.connect(url, info);
        OptiqConnection optiqConnection = (OptiqConnection)connection;
        try {
            String url1 = info.getProperty("url");
            if (url1 == null) {
                throw new IllegalArgumentException("Must specify 'url' property");
            }
            URL url2 = new URL(url1);
            String user = info.getProperty("user");
            if (user == null) {
                throw new IllegalArgumentException("Must specify 'user' property");
            }
            String password = info.getProperty("password");
            if (password == null) {
                throw new IllegalArgumentException("Must specify 'password' property");
            }
            splunkConnection = new SplunkConnection(url2, user, password);
        }
        catch (Exception e) {
            throw new SQLException("Cannot connect", e);
        }
        SchemaPlus rootSchema = optiqConnection.getRootSchema();
        rootSchema.add("splunk", (Schema)new SplunkSchema(splunkConnection));
        String mysqlSchemaName = "mysql";
        try {
            Class.forName("com.mysql.jdbc.Driver");
        }
        catch (ClassNotFoundException e) {
            throw new SQLException(e);
        }
        DataSource dataSource = JdbcSchema.dataSource((String)"jdbc:mysql://localhost", null, (String)"foodmart", (String)"foodmart");
        rootSchema.add("foodmart", (Schema)JdbcSchema.create((SchemaPlus)optiqConnection.getRootSchema(), (String)"foodmart", (DataSource)dataSource, (String)"", (String)"mysql"));
        return connection;
    }

    static {
        new SplunkDriver().register();
    }
}

