/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl.splunk;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import net.hydromatic.optiq.impl.splunk.SplunkTableAccessRel;
import net.hydromatic.optiq.impl.splunk.util.StringUtils;
import org.eigenbase.rel.FilterRel;
import org.eigenbase.rel.ProjectRel;
import org.eigenbase.rel.RelCollation;
import org.eigenbase.rel.RelCollationImpl;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptRuleOperand;
import org.eigenbase.relopt.RelOptRuleOperandChildren;
import org.eigenbase.relopt.RelTrait;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.reltype.RelRecordType;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexSlot;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.type.SqlTypeName;
import org.eigenbase.util.NlsString;
import org.eigenbase.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplunkPushDownRule
extends RelOptRule {
    private static final Logger LOGGER = StringUtils.getClassTracer(SplunkPushDownRule.class);
    private static final Set<SqlKind> SUPPORTED_OPS = new HashSet<SqlKind>(Arrays.asList(SqlKind.EQUALS, SqlKind.LESS_THAN, SqlKind.LESS_THAN_OR_EQUAL, SqlKind.GREATER_THAN, SqlKind.GREATER_THAN_OR_EQUAL, SqlKind.NOT_EQUALS, SqlKind.LIKE, SqlKind.AND, SqlKind.OR, SqlKind.NOT));
    public static final SplunkPushDownRule PROJECT_ON_FILTER = new SplunkPushDownRule(SplunkPushDownRule.operand(ProjectRel.class, (RelOptRuleOperand)SplunkPushDownRule.operand(FilterRel.class, (RelOptRuleOperand)SplunkPushDownRule.operand(ProjectRel.class, (RelOptRuleOperand)SplunkPushDownRule.operand(SplunkTableAccessRel.class, (RelOptRuleOperandChildren)SplunkPushDownRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]), "proj on filter on proj");
    public static final SplunkPushDownRule FILTER_ON_PROJECT = new SplunkPushDownRule(SplunkPushDownRule.operand(FilterRel.class, (RelOptRuleOperand)SplunkPushDownRule.operand(ProjectRel.class, (RelOptRuleOperand)SplunkPushDownRule.operand(SplunkTableAccessRel.class, (RelOptRuleOperandChildren)SplunkPushDownRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]), "filter on proj");
    public static final SplunkPushDownRule FILTER = new SplunkPushDownRule(SplunkPushDownRule.operand(FilterRel.class, (RelOptRuleOperand)SplunkPushDownRule.operand(SplunkTableAccessRel.class, (RelOptRuleOperandChildren)SplunkPushDownRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), "filter");
    public static final SplunkPushDownRule PROJECT = new SplunkPushDownRule(SplunkPushDownRule.operand(ProjectRel.class, (RelOptRuleOperand)SplunkPushDownRule.operand(SplunkTableAccessRel.class, (RelOptRuleOperandChildren)SplunkPushDownRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), "proj");

    protected SplunkPushDownRule(RelOptRuleOperand rule, String id) {
        super(rule, "SplunkPushDownRule: " + id);
    }

    public void onMatch(RelOptRuleCall call) {
        String filterString;
        LOGGER.fine(this.description);
        int relLength = call.rels.length;
        SplunkTableAccessRel splunkRel = (SplunkTableAccessRel)call.rels[relLength - 1];
        ProjectRel topProj = null;
        ProjectRel bottomProj = null;
        RelDataType topRow = splunkRel.getRowType();
        int filterIdx = 2;
        if (call.rels[relLength - 2] instanceof ProjectRel) {
            bottomProj = (ProjectRel)call.rels[relLength - 2];
            filterIdx = 3;
            topRow = bottomProj.getRowType();
        }
        if (filterIdx <= relLength && call.rels[relLength - filterIdx] instanceof FilterRel) {
            FilterRel filter = (FilterRel)call.rels[relLength - filterIdx];
            int topProjIdx = filterIdx + 1;
            if (topProjIdx <= relLength && call.rels[relLength - topProjIdx] instanceof ProjectRel) {
                topProj = (ProjectRel)call.rels[relLength - topProjIdx];
            }
            RexCall filterCall = (RexCall)filter.getCondition();
            SqlOperator op = filterCall.getOperator();
            List operands = filterCall.getOperands();
            LOGGER.fine("fieldNames: " + SplunkPushDownRule.getFieldsString(topRow));
            filterString = this.getFilter(op, operands, "", topRow.getFieldNames());
            if (filterString == null) {
                this.transformToFarragoUdxRel(call, splunkRel, filter, topProj, bottomProj);
                return;
            }
        } else {
            filterString = "";
        }
        if (topProj != null) {
            topRow = topProj.getRowType();
        }
        LOGGER.fine("pre transformTo fieldNames: " + SplunkPushDownRule.getFieldsString(topRow));
        call.transformTo(this.appendSearchString(filterString, splunkRel, topProj, bottomProj, topRow, null));
    }

    protected RelNode appendSearchString(String toAppend, SplunkTableAccessRel splunkRel, ProjectRel topProj, ProjectRel bottomProj, RelDataType topRow, RelDataType bottomRow) {
        List topFields;
        StringBuilder updateSearchStr = new StringBuilder(splunkRel.search);
        if (!toAppend.isEmpty()) {
            updateSearchStr.append(" ").append(toAppend);
        }
        ArrayList<RelDataTypeField> bottomFields = bottomRow == null ? null : bottomRow.getFieldList();
        List list = topFields = topRow == null ? null : topRow.getFieldList();
        if (bottomFields == null) {
            bottomFields = splunkRel.getRowType().getFieldList();
        }
        if (bottomProj != null) {
            ArrayList<RelDataTypeField> tmp = new ArrayList<RelDataTypeField>();
            List dRow = bottomProj.getRowType().getFieldList();
            for (RexNode rn : bottomProj.getProjects()) {
                RelDataTypeField rdtf;
                if (rn instanceof RexSlot) {
                    RexSlot rs = (RexSlot)rn;
                    rdtf = (RelDataTypeField)bottomFields.get(rs.getIndex());
                } else {
                    rdtf = (RelDataTypeField)dRow.get(tmp.size());
                }
                tmp.add(rdtf);
            }
            bottomFields = tmp;
        }
        LinkedList<Pair> renames = new LinkedList<Pair>();
        ArrayList<RelDataTypeField> newFields = bottomFields;
        if (topProj != null) {
            LOGGER.fine("topProj: " + String.valueOf(topProj.getPermutation()));
            newFields = new ArrayList();
            int i = 0;
            for (RexNode rn : topProj.getProjects()) {
                RexInputRef rif = (RexInputRef)rn;
                RelDataTypeField field = (RelDataTypeField)bottomFields.get(rif.getIndex());
                if (!((RelDataTypeField)bottomFields.get(rif.getIndex())).getName().equals(((RelDataTypeField)topFields.get(i)).getName())) {
                    renames.add(new Pair((Object)((RelDataTypeField)bottomFields.get(rif.getIndex())).getName(), (Object)((RelDataTypeField)topFields.get(i)).getName()));
                    field = (RelDataTypeField)topFields.get(i);
                }
                newFields.add(field);
            }
        }
        if (!renames.isEmpty()) {
            updateSearchStr.append("| rename ");
            for (Pair p : renames) {
                updateSearchStr.append((String)p.left).append(" AS ").append((String)p.right).append(" ");
            }
        }
        RelRecordType resultType = new RelRecordType((List)newFields);
        String searchWithFilter = updateSearchStr.toString();
        SplunkTableAccessRel rel = new SplunkTableAccessRel(splunkRel.getCluster(), splunkRel.getTable(), splunkRel.splunkTable, searchWithFilter, splunkRel.earliest, splunkRel.latest, resultType.getFieldNames());
        LOGGER.fine("end of appendSearchString fieldNames: " + rel.getRowType().getFieldNames());
        return rel;
    }

    private static RelNode addProjectionRule(ProjectRel proj, RelNode rel) {
        if (proj == null) {
            return rel;
        }
        return new ProjectRel(proj.getCluster(), proj.getCluster().traitSetOf(new RelTrait[]{proj.getCollationList().isEmpty() ? RelCollationImpl.EMPTY : (RelCollation)proj.getCollationList().get(0)}), rel, proj.getProjects(), proj.getRowType(), proj.getFlags());
    }

    private String getFilter(SqlOperator op, List<RexNode> operands, String s, List<String> fieldNames) {
        if (!this.valid(op.getKind())) {
            return null;
        }
        if (op.equals((Object)SqlStdOperatorTable.NOT)) {
            s = s.concat(" NOT ");
        }
        for (int i = 0; i < operands.size(); ++i) {
            RexNode operand = operands.get(i);
            if (operand instanceof RexCall) {
                s = s.concat("(");
                RexCall call = (RexCall)operand;
                s = this.getFilter(call.getOperator(), call.getOperands(), s, fieldNames);
                if (s == null) {
                    return null;
                }
                s = s.concat(")");
                if (i == operands.size() - 1) continue;
                s = s.concat(" " + op.toString() + " ");
                continue;
            }
            if (operands.size() != 2) {
                return null;
            }
            if (operand instanceof RexInputRef) {
                if (i != 0) {
                    return null;
                }
                int fieldIndex = ((RexInputRef)operand).getIndex();
                String name = fieldNames.get(fieldIndex);
                s = s.concat(name);
            } else {
                RexLiteral lit = (RexLiteral)operand;
                String tmp = this.toString(op, lit);
                if (tmp == null) {
                    return null;
                }
                s = s.concat(tmp);
            }
            if (i != 0) continue;
            s = s.concat(this.toString(op));
        }
        return s;
    }

    private boolean valid(SqlKind kind) {
        return SUPPORTED_OPS.contains(kind);
    }

    private String toString(SqlOperator op) {
        if (op.equals((Object)SqlStdOperatorTable.LIKE)) {
            return SqlStdOperatorTable.EQUALS.toString();
        }
        if (op.equals((Object)SqlStdOperatorTable.NOT_EQUALS)) {
            return "!=";
        }
        return op.toString();
    }

    public static String searchEscape(String str) {
        if (str.isEmpty()) {
            return "\"\"";
        }
        StringBuilder sb = new StringBuilder(str.length());
        boolean quote = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\"' || c == '\\') {
                sb.append('\\');
            }
            sb.append(c);
            quote |= !Character.isLetterOrDigit(c) && c != '_';
        }
        if (quote || sb.length() != str.length()) {
            sb.insert(0, '\"');
            sb.append('\"');
            return sb.toString();
        }
        return str;
    }

    private String toString(SqlOperator op, RexLiteral literal) {
        String value = null;
        SqlTypeName litSqlType = literal.getTypeName();
        if (SqlTypeName.NUMERIC_TYPES.contains(litSqlType)) {
            value = literal.getValue().toString();
        } else if (litSqlType.equals((Object)SqlTypeName.CHAR)) {
            value = ((NlsString)literal.getValue()).getValue();
            if (op.equals((Object)SqlStdOperatorTable.LIKE)) {
                value = value.replaceAll("%", "*");
            }
            value = SplunkPushDownRule.searchEscape(value);
        }
        return value;
    }

    protected void transformToFarragoUdxRel(RelOptRuleCall call, SplunkTableAccessRel splunkRel, FilterRel filter, ProjectRel topProj, ProjectRel bottomProj) {
        assert (false);
    }

    public static String getFieldsString(RelDataType row) {
        return row.getFieldNames().toString();
    }
}

