/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl.splunk;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Constructor;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import net.hydromatic.linq4j.expressions.BlockBuilder;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.Expressions;
import net.hydromatic.linq4j.expressions.Types;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.Schemas;
import net.hydromatic.optiq.impl.java.JavaTypeFactory;
import net.hydromatic.optiq.impl.splunk.SplunkPushDownRule;
import net.hydromatic.optiq.impl.splunk.SplunkQuery;
import net.hydromatic.optiq.impl.splunk.SplunkSchema;
import net.hydromatic.optiq.impl.splunk.SplunkTable;
import net.hydromatic.optiq.impl.splunk.search.SplunkConnection;
import net.hydromatic.optiq.prepare.OptiqPrepareImpl;
import net.hydromatic.optiq.rules.java.EnumerableConvention;
import net.hydromatic.optiq.rules.java.EnumerableRel;
import net.hydromatic.optiq.rules.java.EnumerableRelImplementor;
import net.hydromatic.optiq.rules.java.JavaRowFormat;
import net.hydromatic.optiq.rules.java.PhysType;
import net.hydromatic.optiq.rules.java.PhysTypeImpl;
import net.hydromatic.optiq.runtime.Hook;
import org.eigenbase.rel.RelWriter;
import org.eigenbase.rel.TableAccessRelBase;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptTable;
import org.eigenbase.relopt.RelTrait;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplunkTableAccessRel
extends TableAccessRelBase
implements EnumerableRel {
    final SplunkTable splunkTable;
    final SchemaPlus schema;
    final String search;
    final String earliest;
    final String latest;
    final List<String> fieldList;
    private static final Constructor CONSTRUCTOR = Types.lookupConstructor(SplunkQuery.class, (Class[])new Class[]{SplunkConnection.class, String.class, String.class, String.class, List.class});

    protected SplunkTableAccessRel(RelOptCluster cluster, RelOptTable table, SplunkTable splunkTable, String search, String earliest, String latest, List<String> fieldList) {
        super(cluster, cluster.traitSetOf(new RelTrait[]{EnumerableConvention.INSTANCE}), table);
        this.splunkTable = splunkTable;
        this.schema = null;
        this.search = search;
        this.earliest = earliest;
        this.latest = latest;
        this.fieldList = fieldList;
        assert (splunkTable != null);
        assert (search != null);
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("table", (Object)this.table.getQualifiedName()).item("earliest", (Object)this.earliest).item("latest", (Object)this.latest).item("fieldList", this.fieldList);
    }

    public void register(RelOptPlanner planner) {
        planner.addRule((RelOptRule)SplunkPushDownRule.FILTER);
        planner.addRule((RelOptRule)SplunkPushDownRule.FILTER_ON_PROJECT);
        planner.addRule((RelOptRule)SplunkPushDownRule.PROJECT);
        planner.addRule((RelOptRule)SplunkPushDownRule.PROJECT_ON_FILTER);
    }

    public RelDataType deriveRowType() {
        RelDataTypeFactory.FieldInfoBuilder builder = this.getCluster().getTypeFactory().builder();
        for (String field : this.fieldList) {
            builder.add(this.table.getRowType().getField(field, true));
        }
        return builder.build();
    }

    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        ImmutableMap map = ImmutableMap.builder().put((Object)"search", (Object)this.search).put((Object)"earliest", (Object)this.earliest).put((Object)"latest", (Object)this.latest).put((Object)"fieldList", this.fieldList).build();
        if (OptiqPrepareImpl.DEBUG) {
            System.out.println("Splunk: " + map);
        }
        Hook.QUERY_PLAN.run((Object)map);
        PhysType physType = PhysTypeImpl.of((JavaTypeFactory)implementor.getTypeFactory(), (RelDataType)this.getRowType(), (JavaRowFormat)pref.preferCustom());
        BlockBuilder builder = new BlockBuilder();
        return implementor.result(physType, builder.append((Expression)Expressions.new_((Constructor)CONSTRUCTOR, (Expression[])new Expression[]{Expressions.field((Expression)Types.castIfNecessary(SplunkSchema.class, (Expression)Schemas.expression((SchemaPlus)this.schema)), (String)"splunkConnection"), Expressions.constant((Object)this.search), Expressions.constant((Object)this.earliest), Expressions.constant((Object)this.latest), this.fieldList == null ? Expressions.constant(null) : SplunkTableAccessRel.constantStringList(this.fieldList)})).toBlock());
    }

    private static Expression constantStringList(final List<String> strings) {
        return Expressions.call(Arrays.class, (String)"asList", (Expression[])new Expression[]{Expressions.newArrayInit(Object.class, (Iterable)new AbstractList<Expression>(){

            @Override
            public Expression get(int index) {
                return Expressions.constant(strings.get(index));
            }

            @Override
            public int size() {
                return strings.size();
            }
        })});
    }
}

