/*
// Licensed to Julian Hyde under one or more contributor license
// agreements. See the NOTICE file distributed with this work for
// additional information regarding copyright ownership.
//
// Julian Hyde licenses this file to you under the Apache License,
// Version 2.0 (the "License"); you may not use this file except in
// compliance with the License. You may obtain a copy of the License at:
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
*/
package net.hydromatic.optiq.impl.splunk;

import net.hydromatic.optiq.*;
import net.hydromatic.optiq.Table;
import net.hydromatic.optiq.impl.AbstractSchema;
import net.hydromatic.optiq.impl.splunk.search.SplunkConnection;

import com.google.common.collect.ImmutableMap;

import java.util.*;

/**
 * Splunk schema.
 */
public class SplunkSchema extends AbstractSchema {
  /** The name of the one and only table. */
  public static final String SPLUNK_TABLE_NAME = "splunk";

  public final SplunkConnection splunkConnection;

  /** Creates a SplunkSchema. */
  public SplunkSchema(SchemaPlus parentSchema, String name,
      SplunkConnection splunkConnection) {
    super(parentSchema, name);
    this.splunkConnection = splunkConnection;
  }

  @Override protected Map<String, Table> getTableMap() {
    return ImmutableMap.of(
        SPLUNK_TABLE_NAME, (Table) new SplunkTable(this));
  }
}

// End SplunkSchema.java
