/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl.spark;

import java.lang.reflect.Method;
import java.util.List;
import net.hydromatic.linq4j.expressions.BlockBuilder;
import net.hydromatic.linq4j.expressions.BlockStatement;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.Expressions;
import net.hydromatic.linq4j.expressions.Statement;
import net.hydromatic.optiq.impl.java.JavaTypeFactory;
import net.hydromatic.optiq.impl.spark.SparkMethod;
import net.hydromatic.optiq.impl.spark.SparkRel;
import net.hydromatic.optiq.rules.java.EnumerableRel;
import net.hydromatic.optiq.rules.java.EnumerableRelImplementor;
import net.hydromatic.optiq.rules.java.JavaRowFormat;
import net.hydromatic.optiq.rules.java.PhysType;
import net.hydromatic.optiq.rules.java.PhysTypeImpl;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.convert.ConverterRelImpl;
import org.eigenbase.relopt.ConventionTraitDef;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptCost;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelTraitDef;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparkToEnumerableConverter
extends ConverterRelImpl
implements EnumerableRel {
    protected SparkToEnumerableConverter(RelOptCluster cluster, RelTraitSet traits, RelNode input) {
        super(cluster, (RelTraitDef)ConventionTraitDef.INSTANCE, traits, input);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new SparkToEnumerableConverter(this.getCluster(), traitSet, (RelNode)SparkToEnumerableConverter.sole(inputs));
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner) {
        return super.computeSelfCost(planner).multiplyBy(0.01);
    }

    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        BlockBuilder list = new BlockBuilder();
        SparkRel child = (SparkRel)this.getChild();
        PhysType physType = PhysTypeImpl.of((JavaTypeFactory)implementor.getTypeFactory(), (RelDataType)this.getRowType(), (JavaRowFormat)JavaRowFormat.CUSTOM);
        SparkImplementorImpl sparkImplementor = new SparkImplementorImpl(implementor);
        SparkRel.Result result = child.implementSpark(sparkImplementor);
        Expression rdd = list.append("rdd", result.block);
        Expression enumerable = list.append("enumerable", (Expression)Expressions.call((Method)SparkMethod.AS_ENUMERABLE.method, (Expression[])new Expression[]{rdd}));
        list.add((Statement)Expressions.return_(null, (Expression)enumerable));
        return implementor.result(physType, list.toBlock());
    }

    private static class SparkImplementorImpl
    extends SparkRel.Implementor {
        private final EnumerableRelImplementor implementor;

        public SparkImplementorImpl(EnumerableRelImplementor implementor) {
            super(implementor.getRexBuilder());
            this.implementor = implementor;
        }

        public SparkRel.Result result(PhysType physType, BlockStatement blockStatement) {
            return new SparkRel.Result(physType, blockStatement);
        }

        SparkRel.Result visitInput(SparkRel parent, int ordinal, SparkRel input) {
            if (parent != null) assert (input == parent.getInputs().get(ordinal));
            this.createFrame(parent, ordinal, input);
            return input.implementSpark(this);
        }

        public JavaTypeFactory getTypeFactory() {
            return this.implementor.getTypeFactory();
        }
    }
}

