/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl.spark;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.hydromatic.linq4j.expressions.BlockBuilder;
import net.hydromatic.linq4j.expressions.BlockStatement;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.Expressions;
import net.hydromatic.linq4j.expressions.Node;
import net.hydromatic.linq4j.expressions.ParameterExpression;
import net.hydromatic.linq4j.expressions.Primitive;
import net.hydromatic.linq4j.expressions.Statement;
import net.hydromatic.linq4j.expressions.Types;
import net.hydromatic.optiq.BuiltinMethod;
import net.hydromatic.optiq.impl.java.JavaTypeFactory;
import net.hydromatic.optiq.impl.spark.EnumerableToSparkConverter;
import net.hydromatic.optiq.impl.spark.SparkMethod;
import net.hydromatic.optiq.impl.spark.SparkRel;
import net.hydromatic.optiq.impl.spark.SparkRuntime;
import net.hydromatic.optiq.impl.spark.SparkToEnumerableConverter;
import net.hydromatic.optiq.rules.java.EnumerableConvention;
import net.hydromatic.optiq.rules.java.JavaRowFormat;
import net.hydromatic.optiq.rules.java.PhysType;
import net.hydromatic.optiq.rules.java.PhysTypeImpl;
import net.hydromatic.optiq.rules.java.RexImpTable;
import net.hydromatic.optiq.rules.java.RexToLixTranslator;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.eigenbase.rel.CalcRel;
import org.eigenbase.rel.FilterRel;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelWriter;
import org.eigenbase.rel.SingleRel;
import org.eigenbase.rel.ValuesRel;
import org.eigenbase.rel.ValuesRelBase;
import org.eigenbase.rel.convert.ConverterRule;
import org.eigenbase.rel.metadata.RelMetadataQuery;
import org.eigenbase.rel.rules.FilterToCalcRule;
import org.eigenbase.rel.rules.ProjectToCalcRule;
import org.eigenbase.relopt.Convention;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptCost;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelTrait;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexMultisetUtil;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexProgram;
import org.eigenbase.util.Pair;
import scala.Tuple2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SparkRules {
    public static final SparkValuesRule SPARK_VALUES_RULE = new SparkValuesRule();
    public static final SparkCalcRule SPARK_CALC_RULE = new SparkCalcRule();

    private SparkRules() {
    }

    public static List<RelOptRule> rules() {
        return ImmutableList.of((Object)ProjectToCalcRule.INSTANCE, (Object)FilterToCalcRule.INSTANCE, (Object)((Object)EnumerableToSparkConverterRule.INSTANCE), (Object)((Object)SparkToEnumerableConverterRule.INSTANCE), (Object)((Object)SPARK_VALUES_RULE), (Object)((Object)SPARK_CALC_RULE));
    }

    public static void main(String[] args) {
        JavaSparkContext sc = new JavaSparkContext("local[1]", "optiq");
        JavaRDD file = sc.textFile("/usr/share/dict/words");
        System.out.println(file.map((Function)new Function<String, Object>(){

            public Object call(String s) throws Exception {
                return s.substring(0, Math.min(s.length(), 1));
            }
        }).distinct().count());
        file.cache();
        String s = file.groupBy((Function)new Function<String, String>(){

            public String call(String s) throws Exception {
                return s.substring(0, Math.min(s.length(), 1));
            }
        }).map((Function)new Function<Tuple2<String, List<String>>, Object>(){

            public Object call(Tuple2<String, List<String>> pair) {
                return (String)pair._1() + ":" + ((List)pair._2()).size();
            }
        }).collect().toString();
        System.out.print(s);
        JavaRDD rdd = sc.parallelize((List)new AbstractList<Integer>(){
            final Random random = new Random();

            @Override
            public Integer get(int index) {
                System.out.println("get(" + index + ")");
                return this.random.nextInt(100);
            }

            @Override
            public int size() {
                System.out.println("size");
                return 10;
            }
        });
        System.out.println(rdd.groupBy((Function)new Function<Integer, Integer>(){

            public Integer call(Integer integer) {
                return integer % 2;
            }
        }).collect().toString());
        System.out.println(file.flatMap((FlatMapFunction)new FlatMapFunction<String, Pair<String, Integer>>(){

            public List<Pair<String, Integer>> call(String x) {
                if (!x.startsWith("a")) {
                    return Collections.emptyList();
                }
                return Collections.singletonList(Pair.of((Object)x.toUpperCase(), (Object)x.length()));
            }
        }).take(5).toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SparkCalcRel
    extends SingleRel
    implements SparkRel {
        private final RexProgram program;
        protected int flags;

        public SparkCalcRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RexProgram program, int flags) {
            super(cluster, traitSet, child);
            assert (this.getConvention() == SparkRel.CONVENTION);
            assert (!program.containsAggs());
            this.flags = flags;
            this.program = program;
            this.rowType = program.getOutputRowType();
        }

        public RelWriter explainTerms(RelWriter pw) {
            return this.program.explainCalc(super.explainTerms(pw));
        }

        public double getRows() {
            return FilterRel.estimateFilteredRows((RelNode)this.getChild(), (RexProgram)this.program);
        }

        public RelOptCost computeSelfCost(RelOptPlanner planner) {
            double dRows = RelMetadataQuery.getRowCount((RelNode)this);
            double dCpu = RelMetadataQuery.getRowCount((RelNode)this.getChild()) * (double)this.program.getExprCount();
            double dIo = 0.0;
            return planner.getCostFactory().makeCost(dRows, dCpu, dIo);
        }

        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            return new SparkCalcRel(this.getCluster(), traitSet, (RelNode)SparkCalcRel.sole(inputs), this.program, this.getFlags());
        }

        public int getFlags() {
            return this.flags;
        }

        @Override
        public SparkRel.Result implementSpark(SparkRel.Implementor implementor) {
            JavaTypeFactory typeFactory = implementor.getTypeFactory();
            BlockBuilder builder = new BlockBuilder();
            SparkRel child = (SparkRel)this.getChild();
            SparkRel.Result result = implementor.visitInput(this, 0, child);
            PhysType physType = PhysTypeImpl.of((JavaTypeFactory)typeFactory, (RelDataType)this.getRowType(), (JavaRowFormat)JavaRowFormat.CUSTOM);
            Type outputJavaType = physType.getJavaRowType();
            Type rddType = Types.of(JavaRDD.class, (Type[])new Type[]{outputJavaType});
            Type inputJavaType = result.physType.getJavaRowType();
            Expression inputRdd_ = builder.append("inputRdd", result.block);
            BlockBuilder builder2 = new BlockBuilder();
            ParameterExpression e_ = Expressions.parameter((Type)inputJavaType, (String)"e");
            if (this.program.getCondition() != null) {
                Expression condition = RexToLixTranslator.translateCondition((RexProgram)this.program, (JavaTypeFactory)typeFactory, (BlockBuilder)builder2, (RexToLixTranslator.InputGetter)new RexToLixTranslator.InputGetterImpl(Collections.singletonList(Pair.of((Object)e_, (Object)result.physType))));
                builder2.add((Statement)Expressions.ifThen((Expression)Expressions.not((Expression)condition), (Node)Expressions.return_(null, (Expression)Expressions.call((Method)BuiltinMethod.COLLECTIONS_EMPTY_LIST.method, (Expression[])new Expression[0]))));
            }
            List expressions = RexToLixTranslator.translateProjects((RexProgram)this.program, (JavaTypeFactory)typeFactory, (BlockBuilder)builder2, null, (RexToLixTranslator.InputGetter)new RexToLixTranslator.InputGetterImpl(Collections.singletonList(Pair.of((Object)e_, (Object)result.physType))));
            builder2.add((Statement)Expressions.return_(null, (Expression)Expressions.convert_((Expression)Expressions.call((Method)BuiltinMethod.COLLECTIONS_SINGLETON_LIST.method, (Expression[])new Expression[]{physType.record(expressions)}), List.class)));
            BlockStatement callBody = builder2.toBlock();
            builder.add((Statement)Expressions.return_(null, (Expression)Expressions.call((Expression)inputRdd_, (Method)SparkMethod.RDD_FLAT_MAP.method, (Expression[])new Expression[]{Expressions.lambda(SparkRuntime.OptiqFlatMapFunction.class, (BlockStatement)callBody, (ParameterExpression[])new ParameterExpression[]{e_})})));
            return implementor.result(physType, builder.toBlock());
        }
    }

    private static class SparkCalcRule
    extends ConverterRule {
        private SparkCalcRule() {
            super(CalcRel.class, (RelTrait)Convention.NONE, (RelTrait)SparkRel.CONVENTION, "SparkCalcRule");
        }

        public RelNode convert(RelNode rel) {
            CalcRel calc = (CalcRel)rel;
            RexProgram program = calc.getProgram();
            if (RexMultisetUtil.containsMultiset((RexProgram)program) || program.containsAggs()) {
                return null;
            }
            return new SparkCalcRel(rel.getCluster(), rel.getTraitSet().replace((RelTrait)SparkRel.CONVENTION), SparkCalcRule.convert((RelNode)calc.getChild(), (RelTraitSet)calc.getChild().getTraitSet().replace((RelTrait)SparkRel.CONVENTION)), program, 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SparkValuesRel
    extends ValuesRelBase
    implements SparkRel {
        SparkValuesRel(RelOptCluster cluster, RelDataType rowType, List<List<RexLiteral>> tuples, RelTraitSet traitSet) {
            super(cluster, rowType, tuples, traitSet);
        }

        public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
            assert (inputs.isEmpty());
            return new SparkValuesRel(this.getCluster(), this.rowType, this.tuples, traitSet);
        }

        @Override
        public SparkRel.Result implementSpark(SparkRel.Implementor implementor) {
            JavaTypeFactory typeFactory = (JavaTypeFactory)this.getCluster().getTypeFactory();
            BlockBuilder builder = new BlockBuilder();
            PhysType physType = PhysTypeImpl.of((JavaTypeFactory)implementor.getTypeFactory(), (RelDataType)this.getRowType(), (JavaRowFormat)JavaRowFormat.CUSTOM);
            Type rowClass = physType.getJavaRowType();
            ArrayList<Expression> expressions = new ArrayList<Expression>();
            List fields = this.rowType.getFieldList();
            for (List tuple : this.tuples) {
                ArrayList<Expression> literals = new ArrayList<Expression>();
                for (Pair pair : Pair.zip((List)fields, (List)tuple)) {
                    literals.add(RexToLixTranslator.translateLiteral((RexNode)((RexNode)pair.right), (RelDataType)((RelDataTypeField)pair.left).getType(), (JavaTypeFactory)typeFactory, (RexImpTable.NullAs)RexImpTable.NullAs.NULL));
                }
                expressions.add(physType.record(literals));
            }
            builder.add((Statement)Expressions.return_(null, (Expression)Expressions.call((Method)SparkMethod.ARRAY_TO_RDD.method, (Expression[])new Expression[]{Expressions.call((Method)SparkMethod.GET_SPARK_CONTEXT.method, (Expression[])new Expression[]{implementor.getRootExpression()}), Expressions.newArrayInit((Type)Primitive.box((Type)rowClass), expressions)})));
            return implementor.result(physType, builder.toBlock());
        }
    }

    public static class SparkValuesRule
    extends ConverterRule {
        private SparkValuesRule() {
            super(ValuesRel.class, (RelTrait)Convention.NONE, (RelTrait)SparkRel.CONVENTION, "SparkValuesRule");
        }

        public RelNode convert(RelNode rel) {
            ValuesRel valuesRel = (ValuesRel)rel;
            return new SparkValuesRel(valuesRel.getCluster(), valuesRel.getRowType(), valuesRel.getTuples(), valuesRel.getTraitSet().replace(this.getOutTrait()));
        }
    }

    static class SparkToEnumerableConverterRule
    extends ConverterRule {
        public static final SparkToEnumerableConverterRule INSTANCE = new SparkToEnumerableConverterRule();

        private SparkToEnumerableConverterRule() {
            super(RelNode.class, (RelTrait)SparkRel.CONVENTION, (RelTrait)EnumerableConvention.INSTANCE, "SparkToEnumerableConverterRule");
        }

        public RelNode convert(RelNode rel) {
            return new SparkToEnumerableConverter(rel.getCluster(), rel.getTraitSet().replace((RelTrait)EnumerableConvention.INSTANCE), rel);
        }
    }

    static class EnumerableToSparkConverterRule
    extends ConverterRule {
        public static final EnumerableToSparkConverterRule INSTANCE = new EnumerableToSparkConverterRule();

        private EnumerableToSparkConverterRule() {
            super(RelNode.class, (RelTrait)EnumerableConvention.INSTANCE, (RelTrait)SparkRel.CONVENTION, "EnumerableToSparkConverterRule");
        }

        public RelNode convert(RelNode rel) {
            return new EnumerableToSparkConverter(rel.getCluster(), rel.getTraitSet().replace((RelTrait)SparkRel.CONVENTION), rel);
        }
    }
}

